/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.InsertConstructorCallFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class InsertThisFix
extends InsertConstructorCallFix {
    public InsertThisFix(@NotNull PsiMethod constructor) {
        super(constructor, "this();");
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return super.isAvailable(project, editor, file) && this.hasConstructorToDelegate();
    }

    private boolean hasConstructorToDelegate() {
        PsiClass containingClass = this.myConstructor.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return Arrays.stream(containingClass.getConstructors()).anyMatch(constructor -> constructor != this.myConstructor);
    }
}

