/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.ImportFilter;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportClassFixBase<T extends PsiElement, R extends PsiReference>
implements HintAction,
HighPriorityAction {
    @NotNull
    private final T myElement;
    @NotNull
    private final R myRef;
    private final List<PsiClass> myClassesToImport;

    protected ImportClassFixBase(@NotNull T elem, @NotNull R ref) {
        this.myElement = elem;
        this.myRef = ref;
        this.myClassesToImport = this.calcClassesToImport();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiFile file) {
        PsiExpression expression2;
        if (!this.myElement.isValid() || !this.myRef.getElement().isValid()) {
            return false;
        }
        PsiElement parent = this.myElement.getParent();
        if (parent instanceof PsiNewExpression && ((PsiNewExpression)parent).getQualifier() != null) {
            return false;
        }
        if (parent instanceof PsiReferenceExpression && (expression2 = ((PsiReferenceExpression)parent).getQualifierExpression()) != null && expression2 != this.myElement) {
            return false;
        }
        if (file instanceof PsiJavaCodeReferenceCodeFragment && !((PsiJavaCodeReferenceCodeFragment)file).isClassesAccepted()) {
            return false;
        }
        return !this.getClassesToImport(true).isEmpty();
    }

    @Nullable
    protected abstract String getReferenceName(@NotNull R var1);

    protected abstract PsiElement getReferenceNameElement(@NotNull R var1);

    protected abstract boolean hasTypeParameters(@NotNull R var1);

    @NotNull
    public List<PsiClass> getClassesToImport() {
        return this.getClassesToImport(false);
    }

    @NotNull
    public List<PsiClass> getClassesToImport(boolean acceptWrongNumberOfTypeParams) {
        if (!this.myElement.isValid() || ContainerUtil.exists(this.myClassesToImport, c -> !c.isValid())) {
            return Collections.emptyList();
        }
        if (!acceptWrongNumberOfTypeParams && this.hasTypeParameters(this.myRef)) {
            return ContainerUtil.findAll(this.myClassesToImport, PsiTypeParameterListOwner::hasTypeParameters);
        }
        return this.myClassesToImport;
    }

    private List<PsiClass> calcClassesToImport() {
        JavaResolveResult result;
        PsiElement element;
        if (this.myRef instanceof PsiJavaReference && (element = (result = ((PsiJavaReference)this.myRef).advancedResolve(true)).getElement()) instanceof PsiClass && (result.isValidResult() || result.getCurrentFileResolveScope() instanceof PsiImportStatement)) {
            return Collections.emptyList();
        }
        String name2 = this.getReferenceName(this.myRef);
        GlobalSearchScope scope = this.myElement.getResolveScope();
        if (name2 == null) {
            return Collections.emptyList();
        }
        if (!this.canReferenceClass(this.myRef)) {
            return Collections.emptyList();
        }
        Project project = this.myElement.getProject();
        PsiClass[] classes2 = PsiShortNamesCache.getInstance((Project)project).getClassesByName(name2, scope);
        if (classes2.length == 0) {
            return Collections.emptyList();
        }
        List<PsiClass> classList = new ArrayList<PsiClass>(classes2.length);
        boolean isAnnotationReference = this.myElement.getParent() instanceof PsiAnnotation;
        PsiFile file = this.myElement.getContainingFile();
        for (PsiClass aClass2 : classes2) {
            String qName;
            if (isAnnotationReference && !aClass2.isAnnotationType() || JavaCompletionUtil.isInExcludedPackage((PsiMember)aClass2, false) || (qName = aClass2.getQualifiedName()) == null || qName.indexOf(46) == -1 || !PsiNameHelper.getInstance((Project)project).isQualifiedName(qName) || !qName.endsWith(name2) || file != null && !ImportFilter.shouldImport((PsiFile)file, (String)qName)) continue;
            classList.add(aClass2);
        }
        boolean anyAccessibleFound = classList.stream().anyMatch(aClass -> this.isAccessible((PsiMember)aClass, this.myElement));
        PsiManager manager = this.myElement.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        classList.removeIf(aClass -> (anyAccessibleFound || !BaseIntentionAction.canModify((PsiElement)aClass) || facade.arePackagesTheSame((PsiElement)aClass, this.myElement)) && !this.isAccessible((PsiMember)aClass, this.myElement));
        classList = this.filterByRequiredMemberName(classList);
        List<PsiClass> filtered = this.filterByContext(classList, this.myElement);
        if (!filtered.isEmpty()) {
            classList = filtered;
        }
        this.filerByPackageName(classList, file);
        return ImportClassFixBase.removeDuplicates(classList);
    }

    @NotNull
    private static List<PsiClass> removeDuplicates(@NotNull List<PsiClass> classList) {
        HashSet uniqueNames = new HashSet();
        classList.removeIf(aClass -> !uniqueNames.add(aClass.getQualifiedName()));
        return classList;
    }

    private void filerByPackageName(@NotNull List<? extends PsiClass> classList, PsiFile file) {
        String packageName = StringUtil.getPackageName((String)this.getQualifiedName(this.myElement));
        if (!packageName.isEmpty() && file instanceof PsiJavaFile && Arrays.binarySearch(((PsiJavaFile)file).getImplicitlyImportedPackages(), packageName) < 0) {
            Iterator<? extends PsiClass> iterator = classList.iterator();
            while (iterator.hasNext()) {
                String classQualifiedName = iterator.next().getQualifiedName();
                if (classQualifiedName == null || packageName.equals(StringUtil.getPackageName((String)classQualifiedName))) continue;
                iterator.remove();
            }
        }
    }

    protected boolean canReferenceClass(@NotNull R ref) {
        return true;
    }

    @NotNull
    private List<PsiClass> filterByRequiredMemberName(@NotNull List<PsiClass> classList) {
        List filtered;
        String memberName = this.getRequiredMemberName(this.myElement);
        if (memberName != null && !(filtered = ContainerUtil.findAll(classList, psiClass -> {
            PsiField field = psiClass.findFieldByName(memberName, true);
            if (field != null && field.hasModifierProperty("static") && this.isAccessible((PsiMember)field, this.myElement)) {
                return true;
            }
            PsiClass inner = psiClass.findInnerClassByName(memberName, true);
            if (inner != null && this.isAccessible((PsiMember)inner, this.myElement)) {
                return true;
            }
            for (PsiMethod method : psiClass.findMethodsByName(memberName, true)) {
                if (!method.hasModifierProperty("static") || !this.isAccessible((PsiMember)method, this.myElement)) continue;
                return true;
            }
            return false;
        })).isEmpty()) {
            classList = filtered;
        }
        return classList;
    }

    private void filterAlreadyImportedButUnresolved(@NotNull List<? extends PsiClass> list) {
        PsiElement element = this.myRef.getElement();
        PsiFile containingFile = element.getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)containingFile;
        PsiImportList importList = javaFile.getImportList();
        PsiImportStatementBase[] importStatements = importList == null ? PsiImportStatementBase.EMPTY_ARRAY : importList.getAllImportStatements();
        THashSet importedNames = new THashSet(importStatements.length);
        for (PsiImportStatementBase statement : importStatements) {
            String name2;
            PsiJavaCodeReferenceElement ref = statement.getImportReference();
            String string = name2 = ref == null ? null : ref.getReferenceName();
            if (name2 == null || ref.resolve() != null) continue;
            importedNames.add(name2);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            PsiClass aClass = list.get(i);
            String className2 = aClass.getName();
            if (className2 == null || !importedNames.contains(className2)) continue;
            list.remove(i);
        }
    }

    @Nullable
    protected String getRequiredMemberName(@NotNull T reference) {
        return null;
    }

    @NotNull
    protected List<PsiClass> filterByContext(@NotNull List<PsiClass> candidates, @NotNull T ref) {
        return candidates;
    }

    protected abstract boolean isAccessible(@NotNull PsiMember var1, @NotNull T var2);

    protected abstract String getQualifiedName(@NotNull T var1);

    @NotNull
    protected static List<PsiClass> filterAssignableFrom(@NotNull PsiType type2, @NotNull List<PsiClass> candidates) {
        PsiClass actualClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        if (actualClass != null) {
            return ContainerUtil.findAll(candidates, psiClass -> InheritanceUtil.isInheritorOrSelf((PsiClass)actualClass, (PsiClass)psiClass, (boolean)true));
        }
        return candidates;
    }

    @NotNull
    protected static List<PsiClass> filterBySuperMethods(@NotNull PsiParameter parameter2, @NotNull List<PsiClass> candidates) {
        PsiMethod method;
        PsiElement granny;
        PsiElement parent = parameter2.getParent();
        if (parent instanceof PsiParameterList && (granny = parent.getParent()) instanceof PsiMethod && (method = (PsiMethod)granny).getModifierList().hasAnnotation("java.lang.Override")) {
            PsiClass aClass = method.getContainingClass();
            HashSet probableTypes = new HashSet();
            InheritanceUtil.processSupers((PsiClass)aClass, (boolean)false, psiClass -> {
                for (PsiMethod psiMethod : psiClass.findMethodsByName(method.getName(), false)) {
                    for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                        ContainerUtil.addIfNotNull((Collection)probableTypes, (Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)psiParameter.getType()));
                    }
                }
                return true;
            });
            List filtered = ContainerUtil.filter(candidates, psiClass -> probableTypes.contains(psiClass));
            if (!filtered.isEmpty()) {
                return filtered;
            }
        }
        return candidates;
    }

    public boolean fixSilently(@NotNull Editor editor) {
        PsiFile file;
        PsiFile psiFile = file = this.myElement.isValid() ? this.myElement.getContainingFile() : null;
        if (file == null || !ShowAutoImportPass.isAddUnambiguousImportsOnTheFlyEnabled((PsiFile)file)) {
            return false;
        }
        return this.doFix(editor, false, false, true) == Result.CLASS_AUTO_IMPORTED;
    }

    @NotNull
    public Result doFix(@NotNull Editor editor, boolean allowPopup, boolean allowCaretNearRef, boolean mayAddUnambiguousImportsSilently) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<PsiClass> classesToImport = this.getClassesToImport();
        this.filterAlreadyImportedButUnresolved(classesToImport);
        if (classesToImport.isEmpty()) {
            return Result.POPUP_NOT_SHOWN;
        }
        try {
            Pattern pattern;
            Matcher matcher;
            String name2 = this.getQualifiedName(this.myElement);
            if (name2 != null && (matcher = (pattern = Pattern.compile(DaemonCodeAnalyzerSettings.getInstance().NO_AUTO_IMPORT_PATTERN)).matcher(name2)).matches()) {
                return Result.POPUP_NOT_SHOWN;
            }
        }
        catch (PatternSyntaxException name2) {
            // empty catch block
        }
        PsiFile psiFile = this.myElement.getContainingFile();
        if (classesToImport.size() > 1) {
            ImportClassFixBase.reduceSuggestedClassesBasedOnDependencyRuleViolation(psiFile, classesToImport);
        }
        PsiClass[] classes2 = classesToImport.toArray(PsiClass.EMPTY_ARRAY);
        Project project = this.myElement.getProject();
        CodeInsightUtil.sortIdenticalShortNamedMembers((PsiMember[])classes2, this.myRef);
        AddImportAction action = this.createAddImportAction(classes2, project, editor);
        boolean canImportHere = true;
        if (classes2.length == 1 && (canImportHere = this.canImportHere(allowCaretNearRef, editor, psiFile, classes2[0].getName())) && mayAddUnambiguousImportsSilently && !ImportClassFixBase.autoImportWillInsertUnexpectedCharacters(classes2[0])) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> action.execute());
            return Result.CLASS_AUTO_IMPORTED;
        }
        if (allowPopup && canImportHere) {
            String hintText = ShowAutoImportPass.getMessage((classes2.length > 1 ? 1 : 0) != 0, (String)classes2[0].getQualifiedName());
            if (!ApplicationManager.getApplication().isUnitTestMode() && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
                HintManager.getInstance().showQuestionHint(editor, hintText, this.getStartOffset(this.myElement, this.myRef), this.getEndOffset(this.myElement, this.myRef), (QuestionAction)action);
            }
            return Result.POPUP_SHOWN;
        }
        return Result.POPUP_NOT_SHOWN;
    }

    protected int getStartOffset(@NotNull T element, @NotNull R ref) {
        return element.getTextOffset();
    }

    protected int getEndOffset(@NotNull T element, @NotNull R ref) {
        return element.getTextRange().getEndOffset();
    }

    private static boolean autoImportWillInsertUnexpectedCharacters(@NotNull PsiClass aClass) {
        PsiClass containingClass = aClass.getContainingClass();
        return containingClass != null && !((JavaCodeStyleSettings)CodeStyle.getSettings((PsiFile)aClass.getContainingFile()).getCustomSettings(JavaCodeStyleSettings.class)).INSERT_INNER_CLASS_IMPORTS;
    }

    private boolean canImportHere(boolean allowCaretNearRef, @NotNull Editor editor, PsiFile psiFile, String exampleClassName) {
        return (allowCaretNearRef || !this.isCaretNearRef(editor, this.myRef)) && !this.hasUnresolvedImportWhichCanImport(psiFile, exampleClassName);
    }

    protected abstract boolean isQualified(@NotNull R var1);

    public boolean showHint(@NotNull Editor editor) {
        PsiFile file;
        if (this.isQualified(this.myRef)) {
            return false;
        }
        PsiFile psiFile = file = this.myElement.isValid() ? this.myElement.getContainingFile() : null;
        if (file == null) {
            return false;
        }
        Result result = this.doFix(editor, true, false, ShowAutoImportPass.mayAutoImportNow((PsiFile)file));
        return result == Result.POPUP_SHOWN || result == Result.CLASS_AUTO_IMPORTED;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("import.class.fix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("import.class.fix", new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract boolean hasUnresolvedImportWhichCanImport(PsiFile var1, String var2);

    private static void reduceSuggestedClassesBasedOnDependencyRuleViolation(@NotNull PsiFile file, @NotNull List<? extends PsiClass> availableClasses) {
        Project project = file.getProject();
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)project);
        for (int i = availableClasses.size() - 1; i >= 0; --i) {
            DependencyRule[] violated;
            PsiClass psiClass = availableClasses.get(i);
            PsiFile targetFile = psiClass.getContainingFile();
            if (targetFile == null || (violated = validationManager.getViolatorDependencyRules(file, targetFile)).length == 0) continue;
            availableClasses.remove(i);
            if (availableClasses.size() == 1) break;
        }
    }

    private boolean isCaretNearRef(@NotNull Editor editor, @NotNull R ref) {
        PsiElement nameElement = this.getReferenceNameElement(ref);
        if (nameElement == null) {
            return false;
        }
        TextRange range = nameElement.getTextRange();
        int offset = editor.getCaretModel().getOffset();
        return offset == range.getEndOffset();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            List<PsiClass> classesToImport = this.getClassesToImport(true);
            PsiClass[] classes2 = classesToImport.toArray(PsiClass.EMPTY_ARRAY);
            if (classes2.length == 0) {
                return;
            }
            AddImportAction action = this.createAddImportAction(classes2, project, editor);
            action.execute();
        });
    }

    protected void bindReference(@NotNull PsiReference reference, @NotNull PsiClass targetClass) {
        reference.bindToElement((PsiElement)targetClass);
    }

    @NotNull
    protected AddImportAction createAddImportAction(PsiClass @NotNull [] classes2, @NotNull Project project, @NotNull Editor editor) {
        return new AddImportAction(project, (PsiReference)this.myRef, editor, classes2){

            @Override
            protected void bindReference(@NotNull PsiReference ref, @NotNull PsiClass targetClass) {
                ImportClassFixBase.this.bindReference(ref, targetClass);
            }
        };
    }

    public static enum Result {
        POPUP_SHOWN,
        CLASS_AUTO_IMPORTED,
        POPUP_NOT_SHOWN;

    }
}

