/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.filters.FilterPositionUtil;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ImportClassFix
extends ImportClassFixBase<PsiJavaCodeReferenceElement, PsiJavaCodeReferenceElement> {
    public ImportClassFix(@NotNull PsiJavaCodeReferenceElement element) {
        super(element, element);
    }

    @Override
    protected String getReferenceName(@NotNull PsiJavaCodeReferenceElement reference) {
        return reference.getReferenceName();
    }

    @Override
    protected PsiElement getReferenceNameElement(@NotNull PsiJavaCodeReferenceElement reference) {
        return reference.getReferenceNameElement();
    }

    @Override
    protected void bindReference(@NotNull PsiReference ref, @NotNull PsiClass targetClass) {
        if (ref instanceof PsiImportStaticReferenceElement) {
            ((PsiImportStaticReferenceElement)ref).bindToTargetClass(targetClass);
        } else {
            super.bindReference(ref, targetClass);
        }
    }

    @Override
    protected boolean hasTypeParameters(@NotNull PsiJavaCodeReferenceElement reference) {
        PsiReferenceParameterList refParameters = reference.getParameterList();
        return refParameters != null && refParameters.getTypeParameterElements().length > 0;
    }

    @Override
    protected String getQualifiedName(@NotNull PsiJavaCodeReferenceElement reference) {
        return reference.getQualifiedName();
    }

    @Override
    protected boolean isQualified(@NotNull PsiJavaCodeReferenceElement reference) {
        return reference.isQualified();
    }

    @Override
    protected boolean hasUnresolvedImportWhichCanImport(PsiFile psiFile, String name2) {
        PsiImportStaticStatement[] importStaticStatements;
        PsiImportStatement[] importStatements;
        if (!(psiFile instanceof PsiJavaFile)) {
            return false;
        }
        PsiImportList importList = ((PsiJavaFile)psiFile).getImportList();
        if (importList == null) {
            return false;
        }
        for (PsiImportStatement importStatement : importStatements = importList.getImportStatements()) {
            String className2;
            if (importStatement.resolve() != null) continue;
            if (importStatement.isOnDemand()) {
                return true;
            }
            String qualifiedName = importStatement.getQualifiedName();
            String string = className2 = qualifiedName == null ? null : ClassUtil.extractClassName((String)qualifiedName);
            if (!Comparing.strEqual((String)className2, (String)name2)) continue;
            return true;
        }
        for (PsiImportStaticStatement importStaticStatement : importStaticStatements = importList.getImportStaticStatements()) {
            if (importStaticStatement.resolve() != null) continue;
            if (importStaticStatement.isOnDemand()) {
                return true;
            }
            String qualifiedName = importStaticStatement.getReferenceName();
            if (qualifiedName == null || !StringUtil.split((String)qualifiedName, (String)".").contains(name2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getRequiredMemberName(@NotNull PsiJavaCodeReferenceElement reference) {
        PsiElement parent = reference.getParent();
        if (parent instanceof PsiJavaCodeReferenceElement) {
            return ((PsiJavaCodeReferenceElement)parent).getReferenceName();
        }
        return super.getRequiredMemberName(reference);
    }

    @Override
    protected boolean canReferenceClass(@NotNull PsiJavaCodeReferenceElement ref) {
        if (PsiTreeUtil.getParentOfType((PsiElement)ref, PsiImportStatementBase.class) != null) {
            return false;
        }
        if (ref instanceof PsiReferenceExpression) {
            PsiElement parent = ref.getParent();
            return parent instanceof PsiReferenceExpression || parent instanceof PsiExpressionStatement;
        }
        return !ImportClassFix.inReturnTypeOfIncompleteGenericMethod(ref);
    }

    private static boolean inReturnTypeOfIncompleteGenericMethod(@NotNull PsiJavaCodeReferenceElement element) {
        PsiTypeElement type2 = (PsiTypeElement)SyntaxTraverser.psiApi().parents((Object)element).filter(PsiTypeElement.class).last();
        PsiElement prev = FilterPositionUtil.searchNonSpaceNonCommentBack((PsiElement)type2);
        PsiTypeParameterList typeParameterList = (PsiTypeParameterList)PsiTreeUtil.getParentOfType((PsiElement)prev, PsiTypeParameterList.class);
        if (typeParameterList != null && typeParameterList.getParent() instanceof PsiErrorElement) {
            return Arrays.stream(typeParameterList.getTypeParameters()).anyMatch(p -> Objects.equals(element.getReferenceName(), p.getName()));
        }
        return false;
    }

    @Override
    @NotNull
    protected List<PsiClass> filterByContext(@NotNull List<PsiClass> candidates, @NotNull PsiJavaCodeReferenceElement ref) {
        if (ref instanceof PsiReferenceExpression) {
            return Collections.emptyList();
        }
        PsiElement typeElement = ref.getParent();
        if (typeElement instanceof PsiTypeElement) {
            PsiType type2;
            PsiExpression initializer;
            PsiElement var = typeElement.getParent();
            if (var instanceof PsiVariable && (initializer = ((PsiVariable)var).getInitializer()) != null && (type2 = initializer.getType()) != null) {
                return ImportClassFix.filterAssignableFrom(type2, candidates);
            }
            if (var instanceof PsiParameter) {
                return ImportClassFix.filterBySuperMethods((PsiParameter)var, candidates);
            }
        }
        return super.filterByContext(candidates, ref);
    }

    @Override
    protected boolean isAccessible(@NotNull PsiMember member, @NotNull PsiJavaCodeReferenceElement reference) {
        return PsiUtil.isAccessible((PsiMember)member, (PsiElement)reference, null);
    }
}

