/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuessTypeParameters {
    private static final Logger LOG = Logger.getInstance(GuessTypeParameters.class);
    private final Project myProject;
    private final PsiManager myManager;
    private final JVMElementFactory myFactory;
    private final TemplateBuilder myBuilder;
    private final PsiSubstitutor mySubstitutor;
    private static final int SUBSTITUTED_NONE = 0;
    private static final int SUBSTITUTED_IN_REF = 1;
    private static final int SUBSTITUTED_IN_PARAMETERS = 2;

    public GuessTypeParameters(@NotNull Project project, @NotNull JVMElementFactory factory, @NotNull TemplateBuilder builder, @Nullable PsiSubstitutor substitutor) {
        this.myProject = project;
        this.myManager = PsiManager.getInstance((Project)project);
        this.myFactory = factory;
        this.myBuilder = builder;
        this.mySubstitutor = substitutor == null ? PsiSubstitutor.EMPTY : substitutor;
    }

    @NotNull
    public PsiTypeElement setupTypeElement(@NotNull PsiTypeElement typeElement, ExpectedTypeInfo @NotNull [] infos, @Nullable PsiElement context, @NotNull PsiClass targetClass) {
        PsiType[] psiTypeArray;
        LOG.assertTrue(typeElement.isValid());
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        GlobalSearchScope scope = typeElement.getResolveScope();
        if (infos.length == 1 && this.mySubstitutor != PsiSubstitutor.EMPTY) {
            int substitionResult;
            ExpectedTypeInfo info = infos[0];
            PsiType expectedType = info.getType();
            List<PsiTypeParameter> matchedParameters = GuessTypeParameters.matchingTypeParameters(this.mySubstitutor, expectedType, info.getKind());
            if (!matchedParameters.isEmpty()) {
                SmartList types = new SmartList((Collection)ContainerUtil.map(matchedParameters, it -> this.myFactory.createType((PsiClass)it)));
                ContainerUtil.addAll((Collection)types, (Object[])ExpectedTypesProvider.processExpectedTypes(infos, new MyTypeVisitor(this.myManager, scope), this.myProject));
                this.myBuilder.replaceElement((PsiElement)typeElement, (Expression)new TypeExpression(this.myProject, (Iterable<? extends PsiType>)types));
                return typeElement;
            }
            typeElement = this.replaceTypeElement(typeElement, info.getType());
            PsiSubstitutor rawingSubstitutor = GuessTypeParameters.getRawingSubstitutor(this.myProject, context, targetClass);
            int n = substitionResult = GuessTypeParameters.hasNullSubstitutions(this.mySubstitutor) ? 0 : this.substituteToTypeParameters(typeElement, expectedType, rawingSubstitutor, true);
            if (substitionResult == 2) {
                PsiElement referenceNameElement2;
                PsiJavaCodeReferenceElement refElement = typeElement.getInnermostComponentReferenceElement();
                LOG.assertTrue(refElement != null);
                PsiElement qualifier = refElement.getQualifier();
                if (qualifier != null) {
                    qualifier.delete();
                }
                LOG.assertTrue((referenceNameElement2 = refElement.getReferenceNameElement()) != null);
                PsiClassType defaultType = GuessTypeParameters.getComponentType(info.getDefaultType());
                LOG.assertTrue(defaultType != null);
                PsiClassType rawDefaultType = defaultType.rawType();
                ExpectedTypeInfo info1 = ExpectedTypesProvider.createInfo((PsiType)rawDefaultType, 0, (PsiType)rawDefaultType, info.getTailType());
                MyTypeVisitor visitor2 = new MyTypeVisitor(this.myManager, scope);
                PsiType[] types = ExpectedTypesProvider.processExpectedTypes(new ExpectedTypeInfo[]{info1}, visitor2, this.myProject);
                this.myBuilder.replaceElement(referenceNameElement2, (Expression)new TypeExpression(this.myProject, types));
                return typeElement;
            }
            if (substitionResult != 0) {
                return typeElement;
            }
        }
        if (infos.length == 0) {
            PsiType[] psiTypeArray2 = new PsiType[1];
            psiTypeArray = psiTypeArray2;
            psiTypeArray2[0] = typeElement.getType();
        } else {
            psiTypeArray = ExpectedTypesProvider.processExpectedTypes(infos, new MyTypeVisitor(this.myManager, scope), this.myProject);
        }
        PsiType[] types = psiTypeArray;
        this.myBuilder.replaceElement((PsiElement)typeElement, (Expression)new TypeExpression(this.myProject, types));
        return typeElement;
    }

    private PsiTypeElement replaceTypeElement(@NotNull PsiTypeElement templateElement, @NotNull PsiType type2) {
        PsiTypeElement newTypeElement = JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeElement(type2);
        return (PsiTypeElement)PostprocessReformattingAspect.getInstance((Project)this.myProject).disablePostprocessFormattingInside(() -> (PsiTypeElement)templateElement.replace((PsiElement)newTypeElement));
    }

    private static PsiSubstitutor getRawingSubstitutor(Project project, PsiElement context, PsiClass targetClass) {
        if (context == null || targetClass == null) {
            return PsiSubstitutor.EMPTY;
        }
        PsiManager manager = context.getManager();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (PsiTypeParameterListOwner currContext = (PsiTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)context, PsiTypeParameterListOwner.class); currContext != null && !manager.areElementsEquivalent((PsiElement)currContext, (PsiElement)targetClass); currContext = currContext.getContainingClass()) {
            PsiTypeParameter[] typeParameters = currContext.getTypeParameters();
            substitutor = JavaPsiFacade.getElementFactory((Project)project).createRawSubstitutor(substitutor, typeParameters);
        }
        return substitutor;
    }

    @Nullable
    private static PsiClassType getComponentType(PsiType type2) {
        if ((type2 = type2.getDeepComponentType()) instanceof PsiClassType) {
            return (PsiClassType)type2;
        }
        return null;
    }

    private int substituteToTypeParameters(PsiTypeElement typeElement, PsiType expectedType, PsiSubstitutor rawingSubstitutor, boolean toplevel) {
        List<PsiTypeParameter> matchedParameters = GuessTypeParameters.matchingTypeParameters(this.mySubstitutor, expectedType, 0);
        if (!matchedParameters.isEmpty()) {
            SmartList types = new SmartList((Collection)ContainerUtil.map(matchedParameters, it -> this.myFactory.createType((PsiClass)it)));
            PsiType substituted = rawingSubstitutor.substitute(expectedType);
            if (!"java.lang.Object".equals(substituted.getCanonicalText()) && (toplevel || substituted.equals(expectedType))) {
                types.add(substituted);
            }
            this.myBuilder.replaceElement((PsiElement)typeElement, (Expression)new TypeExpression(this.myProject, (Iterable<? extends PsiType>)types));
            return toplevel ? 1 : 2;
        }
        PsiTypeElement[] innerTypeElements = GuessTypeParameters.typeArguments(typeElement);
        if (innerTypeElements == null) {
            return 0;
        }
        PsiType[] expectedTypeArguments = GuessTypeParameters.typeArguments(expectedType);
        if (expectedTypeArguments == null) {
            return 0;
        }
        boolean substituted = false;
        for (int i = 0; i < innerTypeElements.length; ++i) {
            substituted |= this.substituteToTypeParameters(innerTypeElements[i], expectedTypeArguments[i], rawingSubstitutor, false) != 0;
        }
        return substituted ? 2 : 0;
    }

    private static PsiTypeElement @Nullable [] typeArguments(@NotNull PsiTypeElement typeElement) {
        PsiJavaCodeReferenceElement unwrappedRef = typeElement.getInnermostComponentReferenceElement();
        if (unwrappedRef == null) {
            return null;
        }
        PsiReferenceParameterList typeArgumentList = unwrappedRef.getParameterList();
        if (typeArgumentList == null) {
            return null;
        }
        return typeArgumentList.getTypeParameterElements();
    }

    private static PsiType @Nullable [] typeArguments(@NotNull PsiType type2) {
        PsiClassType unwrappedType = GuessTypeParameters.getComponentType(type2);
        return unwrappedType == null ? null : unwrappedType.getParameters();
    }

    @NotNull
    private static List<PsiTypeParameter> matchingTypeParameters(@NotNull PsiSubstitutor substitutor, @NotNull PsiType expectedType, @ExpectedTypeInfo.Type int kind2) {
        SmartList result = new SmartList();
        for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
            PsiType typeArgument = (PsiType)entry.getValue();
            if (typeArgument == null || !GuessTypeParameters.matches(typeArgument, expectedType, kind2)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private static boolean matches(@NotNull PsiType type2, @NotNull PsiType expectedType, @ExpectedTypeInfo.Type int kind2) {
        switch (kind2) {
            case 0: {
                return type2.equals(expectedType);
            }
            case 1: {
                return expectedType.isAssignableFrom(type2);
            }
            case 2: {
                return type2.isAssignableFrom(expectedType);
            }
        }
        return false;
    }

    private static boolean hasNullSubstitutions(@NotNull PsiSubstitutor substitutor) {
        for (PsiType type2 : substitutor.getSubstitutionMap().values()) {
            if (type2 != null) continue;
            return true;
        }
        return false;
    }

    public static class MyTypeVisitor
    extends PsiTypeVisitor<PsiType> {
        private final GlobalSearchScope myResolveScope;
        private final PsiManager myManager;

        public MyTypeVisitor(PsiManager manager, GlobalSearchScope resolveScope) {
            this.myManager = manager;
            this.myResolveScope = resolveScope;
        }

        public PsiType visitType(@NotNull PsiType type2) {
            if (type2.equals(PsiType.NULL)) {
                return PsiType.getJavaLangObject((PsiManager)this.myManager, (GlobalSearchScope)this.myResolveScope);
            }
            return type2;
        }

        public PsiType visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
            return (PsiType)capturedWildcardType.getUpperBound().accept((PsiTypeVisitor)this);
        }
    }
}

