/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendsListFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(ExtendsListFix.class);
    @FileModifier.SafeFieldForPreview
    @Nullable
    protected final SmartPsiElementPointer<PsiClass> myClassToExtendFromPointer;
    private final boolean myToAdd;
    @FileModifier.SafeFieldForPreview
    private final PsiClassType myTypeToExtendFrom;
    private final String myName;

    public ExtendsListFix(@NotNull PsiClass aClass, @NotNull PsiClassType typeToExtendFrom, boolean toAdd) {
        this(aClass, typeToExtendFrom.resolve(), typeToExtendFrom, toAdd);
    }

    public ExtendsListFix(@NotNull PsiClass aClass, @NotNull PsiClass classToExtendFrom, boolean toAdd) {
        this(aClass, classToExtendFrom, JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(classToExtendFrom), toAdd);
    }

    private ExtendsListFix(@NotNull PsiClass aClass, @Nullable PsiClass classToExtendFrom, @NotNull PsiClassType typeToExtendFrom, boolean toAdd) {
        super((PsiElement)aClass);
        this.myClassToExtendFromPointer = classToExtendFrom == null ? null : SmartPointerManager.createPointer((PsiElement)classToExtendFrom);
        this.myToAdd = toAdd;
        PsiClassType psiClassType = this.myTypeToExtendFrom = aClass instanceof PsiTypeParameter ? typeToExtendFrom : (PsiClassType)GenericsUtil.eliminateWildcards((PsiType)typeToExtendFrom);
        String messageKey = classToExtendFrom != null && aClass.isInterface() == classToExtendFrom.isInterface() ? (toAdd ? "add.class.to.extends.list" : "remove.class.from.extends.list") : (toAdd ? "add.interface.to.implements.list" : "remove.interface.from.implements.list");
        this.myName = QuickFixBundle.message(messageKey, aClass.getName(), classToExtendFrom == null ? "" : (classToExtendFrom instanceof PsiTypeParameter ? classToExtendFrom.getName() : classToExtendFrom.getQualifiedName()));
    }

    @NotNull
    public String getText() {
        return this.myName;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("change.extends.list.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass classToExtendFrom;
        PsiClass myClass = (PsiClass)startElement;
        PsiClass psiClass = classToExtendFrom = this.myClassToExtendFromPointer != null ? (PsiClass)this.myClassToExtendFromPointer.getElement() : null;
        return BaseIntentionAction.canModify((PsiElement)myClass) && classToExtendFrom != null && classToExtendFrom.isValid() && !classToExtendFrom.hasModifierProperty("final") && (classToExtendFrom.isInterface() || !myClass.isInterface() && myClass.getExtendsList() != null && myClass.getExtendsList().getReferencedTypes().length == 0 == this.myToAdd);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass myClass = (PsiClass)startElement;
        this.invokeImpl(myClass);
        UndoUtil.markPsiFileForUndo((PsiFile)file);
    }

    protected void invokeImpl(PsiClass myClass) {
        PsiClass classToExtendFrom = this.myClassToExtendFromPointer != null ? (PsiClass)this.myClassToExtendFromPointer.getElement() : null;
        PsiReferenceList extendsList = !(myClass instanceof PsiTypeParameter) && classToExtendFrom != null && myClass.isInterface() != classToExtendFrom.isInterface() ? myClass.getImplementsList() : myClass.getExtendsList();
        PsiReferenceList otherList = extendsList == myClass.getImplementsList() ? myClass.getExtendsList() : myClass.getImplementsList();
        try {
            if (extendsList != null) {
                this.modifyList(extendsList, this.myToAdd, -1);
            }
            if (otherList != null) {
                this.modifyList(otherList, false, -1);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    void modifyList(@NotNull PsiReferenceList extendsList, boolean add, int position) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] referenceElements = extendsList.getReferenceElements();
        boolean alreadyExtends = false;
        PsiClass classToExtendFrom = this.myClassToExtendFromPointer != null ? (PsiClass)this.myClassToExtendFromPointer.getElement() : null;
        for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
            if (!referenceElement.getManager().areElementsEquivalent((PsiElement)classToExtendFrom, referenceElement.resolve())) continue;
            alreadyExtends = true;
            if (add) continue;
            referenceElement.delete();
        }
        PsiReferenceList list = extendsList;
        Project project = extendsList.getProject();
        if (add && !alreadyExtends) {
            PsiJavaCodeReferenceElement anchor = position == -1 ? (referenceElements.length == 0 ? null : referenceElements[referenceElements.length - 1]) : (position == 0 ? null : referenceElements[position - 1]);
            PsiJavaCodeReferenceElement classReferenceElement = JavaPsiFacade.getElementFactory((Project)project).createReferenceElementByType(this.myTypeToExtendFrom);
            PsiElement element = anchor == null ? (referenceElements.length == 0 ? extendsList.add((PsiElement)classReferenceElement) : extendsList.addBefore((PsiElement)classReferenceElement, (PsiElement)referenceElements[0])) : extendsList.addAfter((PsiElement)classReferenceElement, (PsiElement)anchor);
            list = (PsiReferenceList)element.getParent();
        }
        if (!add && !alreadyExtends) {
            return;
        }
        CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)list));
    }
}

