/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import org.jetbrains.annotations.NotNull;

public final class EnableOptimizeImportsOnTheFlyFix
implements IntentionAction,
LowPriorityAction {
    @NotNull
    public String getText() {
        return QuickFixBundle.message("enable.optimize.imports.on.the.fly", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return BaseIntentionAction.canModify((PsiElement)file) && file instanceof PsiJavaFile && !CodeInsightWorkspaceSettings.getInstance((Project)project).isOptimizeImportsOnTheFly();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        CodeInsightWorkspaceSettings.getInstance((Project)project).setOptimizeImportsOnTheFly(true);
        SaveAndSyncHandler.getInstance().scheduleSave(SaveAndSyncHandler.SaveTask.projectIncludingAllSettings((Project)project), false);
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

