/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.RecordConstructorMember;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.ParameterClassMember;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefineParamsDefaultValueAction
extends PsiElementBaseIntentionAction
implements Iconable,
LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(DefineParamsDefaultValueAction.class);

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("generate.overloaded.method.with.default.parameter.values", new Object[0]);
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.RefactoringBulb;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (!JavaLanguage.INSTANCE.equals(element.getLanguage())) {
            return false;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiCodeBlock.class});
        if (!(parent instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)parent;
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.isEmpty()) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || containingClass.isInterface() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)method)) {
            return false;
        }
        this.setText(QuickFixBundle.message("generate.overloaded.method.or.constructor.with.default.parameter.values", method.isConstructor() ? "constructor" : "method"));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        assert (method != null);
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter[] parameters2 = DefineParamsDefaultValueAction.getParams(element, parameterList);
        if (parameters2 == null || parameters2.length == 0) {
            return;
        }
        PsiMethod methodPrototype = DefineParamsDefaultValueAction.generateMethodPrototype(method, parameters2);
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        PsiMethod existingMethod = containingClass.findMethodBySignature(methodPrototype, false);
        if (existingMethod != null) {
            editor.getCaretModel().moveToOffset(existingMethod.getTextOffset());
            HintManager.getInstance().showErrorHint(editor, (existingMethod.isConstructor() ? "Constructor" : "Method") + " with the chosen signature already exists");
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        Runnable runnable = () -> {
            PsiMethod prototype = (PsiMethod)containingClass.addBefore((PsiElement)methodPrototype, (PsiElement)method);
            RefactoringUtil.fixJavadocsForParams(prototype, ContainerUtil.set((Object[])prototype.getParameterList().getParameters()));
            PsiCodeBlock body2 = prototype.getBody();
            String callArgs = "(" + StringUtil.join((Object[])parameterList.getParameters(), psiParameter -> {
                if (ArrayUtil.find((Object[])parameters2, (Object)psiParameter) > -1) {
                    return "IntelliJIDEARulezzz";
                }
                return psiParameter.getName();
            }, (String)",") + ");";
            String methodCall = method.getReturnType() == null ? "this" : (!PsiType.VOID.equals((Object)method.getReturnType()) ? "return " + method.getName() : method.getName());
            LOG.assertTrue(body2 != null);
            body2.add((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(methodCall + callArgs, (PsiElement)method));
            body2 = (PsiCodeBlock)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)body2);
            PsiStatement stmt = body2.getStatements()[0];
            Object expr2 = stmt instanceof PsiReturnStatement ? ((PsiReturnStatement)stmt).getReturnValue() : (stmt instanceof PsiExpressionStatement ? ((PsiExpressionStatement)stmt).getExpression() : null);
            if (expr2 instanceof PsiMethodCallExpression) {
                PsiExpression[] args = ((PsiMethodCallExpression)expr2).getArgumentList().getExpressions();
                PsiExpression[] toDefaults = (PsiExpression[])ContainerUtil.map2Array((Object[])parameters2, PsiExpression.class, parameter2 -> args[parameterList.getParameterIndex(parameter2)]);
                DefineParamsDefaultValueAction.startTemplate(project, editor, toDefaults, prototype);
            }
        };
        if (this.startInWriteAction()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().runWriteAction(runnable);
        }
    }

    public static void startTemplate(@NotNull Project project, Editor editor, PsiExpression[] argsToBeDelegated, PsiMethod delegateMethod) {
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)delegateMethod);
        RangeMarker rangeMarker = editor.getDocument().createRangeMarker(delegateMethod.getTextRange());
        for (PsiExpression exprToBeDefault : argsToBeDelegated) {
            builder.replaceElement((PsiElement)exprToBeDefault, (Expression)new TextExpression(""));
        }
        Template template = builder.buildTemplate();
        editor.getCaretModel().moveToOffset(rangeMarker.getStartOffset());
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        editor.getDocument().deleteString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        rangeMarker.dispose();
        CreateFromUsageBaseFix.startTemplate(editor, template, project);
    }

    private static PsiParameter @Nullable [] getParams(@NotNull PsiElement element, @NotNull PsiParameterList parameterList) {
        List elements;
        int idx;
        Object[] parameters2 = parameterList.getParameters();
        if (parameters2.length == 1) {
            return parameters2;
        }
        ClassMember[] members = new ParameterClassMember[parameters2.length];
        for (int i = 0; i < members.length; ++i) {
            members[i] = new ParameterClassMember(parameters2[i]);
        }
        PsiParameter selectedParam = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class);
        int n = idx = selectedParam != null ? ArrayUtil.find((Object[])parameters2, (Object)selectedParam) : -1;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiParameter[] psiParameterArray;
            if (idx >= 0) {
                PsiParameter[] psiParameterArray2 = new PsiParameter[1];
                psiParameterArray = psiParameterArray2;
                psiParameterArray2[0] = selectedParam;
            } else {
                psiParameterArray = null;
            }
            return psiParameterArray;
        }
        MemberChooser chooser = new MemberChooser(members, false, true, parameterList.getProject());
        if (idx >= 0) {
            chooser.selectElements(new ClassMember[]{members[idx]});
        } else {
            chooser.selectElements(members);
        }
        chooser.setTitle(QuickFixBundle.message("choose.default.value.parameters.popup.title", new Object[0]));
        chooser.setCopyJavadocVisible(false);
        if (chooser.showAndGet() && (elements = chooser.getSelectedElements()) != null) {
            PsiParameter[] params = new PsiParameter[elements.size()];
            for (int i = 0; i < params.length; ++i) {
                params[i] = ((ParameterClassMember)elements.get(i)).getParameter();
            }
            return params;
        }
        return null;
    }

    private static PsiMethod generateMethodPrototype(PsiMethod method, PsiParameter ... params) {
        PsiMethod prototype = JavaPsiRecordUtil.isCompactConstructor(method) ? new RecordConstructorMember(method.getContainingClass(), false).generateRecordConstructor() : (PsiMethod)method.copy();
        PsiCodeBlock body2 = prototype.getBody();
        PsiCodeBlock emptyBody = JavaPsiFacade.getElementFactory((Project)method.getProject()).createCodeBlock();
        if (body2 != null) {
            body2.replace((PsiElement)emptyBody);
        } else {
            prototype.getModifierList().setModifierProperty("abstract", false);
            prototype.addBefore((PsiElement)emptyBody, null);
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass != null && aClass.isInterface() && !method.hasModifierProperty("static")) {
            prototype.getModifierList().setModifierProperty("default", true);
        }
        PsiParameterList parameterList = method.getParameterList();
        Arrays.sort(params, Comparator.comparingInt(arg_0 -> ((PsiParameterList)parameterList).getParameterIndex(arg_0)).reversed());
        for (PsiParameter param : params) {
            int parameterIndex = parameterList.getParameterIndex(param);
            Objects.requireNonNull(prototype.getParameterList().getParameter(parameterIndex)).delete();
        }
        return prototype;
    }
}

