/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateGetterOrSetterFix
implements IntentionAction,
LowPriorityAction {
    private final boolean myCreateGetter;
    private final boolean myCreateSetter;
    private final PsiField myField;
    private final String myPropertyName;

    public CreateGetterOrSetterFix(boolean createGetter, boolean createSetter, @NotNull PsiField field) {
        this.myCreateGetter = createGetter;
        this.myCreateSetter = createSetter;
        this.myField = field;
        this.myPropertyName = PropertyUtilBase.suggestPropertyName((PsiField)field);
    }

    @NotNull
    public String getText() {
        String what;
        if (this.myCreateGetter && this.myCreateSetter) {
            what = "create.getter.and.setter.for.field";
        } else if (this.myCreateGetter) {
            what = "create.getter.for.field";
        } else if (this.myCreateSetter) {
            what = "create.setter.for.field";
        } else {
            throw new IllegalStateException("Either createGetter or createSetter must be true");
        }
        return QuickFixBundle.message(what, this.myField.getName());
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.accessor.for.unused.field.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!this.myField.isValid()) {
            return false;
        }
        PsiClass aClass = this.myField.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (this.myCreateGetter && (CreateGetterOrSetterFix.isStaticFinal(this.myField) || PropertyUtilBase.findPropertyGetter((PsiClass)aClass, (String)this.myPropertyName, (boolean)CreateGetterOrSetterFix.isStatic(this.myField), (boolean)false) != null)) {
            return false;
        }
        return !this.myCreateSetter || !CreateGetterOrSetterFix.isFinal(this.myField) && PropertyUtilBase.findPropertySetter((PsiClass)aClass, (String)this.myPropertyName, (boolean)CreateGetterOrSetterFix.isStatic(this.myField), (boolean)false) == null;
    }

    private static boolean isFinal(@NotNull PsiField field) {
        return field.hasModifierProperty("final");
    }

    private static boolean isStatic(@NotNull PsiField field) {
        return field.hasModifierProperty("static");
    }

    private static boolean isStaticFinal(@NotNull PsiField field) {
        return CreateGetterOrSetterFix.isStatic(field) && CreateGetterOrSetterFix.isFinal(field);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return this.myField;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiClass aClass = this.myField.getContainingClass();
        ArrayList methods = new ArrayList();
        if (this.myCreateGetter) {
            Collections.addAll(methods, GetterSetterPrototypeProvider.generateGetterSetters(this.myField, true));
        }
        if (this.myCreateSetter) {
            Collections.addAll(methods, GetterSetterPrototypeProvider.generateGetterSetters(this.myField, false));
        }
        assert (aClass != null);
        JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)aClass.getProject());
        for (PsiMethod method : methods) {
            PsiElement newMember = GenerateMembersUtil.insert(aClass, (PsiMember)method, null, true);
            manager.shortenClassReferences(newMember);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        return new CreateGetterOrSetterFix(this.myCreateGetter, this.myCreateSetter, (PsiField)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myField, (PsiFile)target));
    }
}

