/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public enum CreateClassKind implements ClassKind
{
    CLASS(JavaElementKind.CLASS),
    INTERFACE(JavaElementKind.INTERFACE),
    ENUM(JavaElementKind.ENUM),
    ANNOTATION(JavaElementKind.ANNOTATION),
    RECORD(JavaElementKind.RECORD);

    private final JavaElementKind myKind;

    private CreateClassKind(JavaElementKind kind2) {
        this.myKind = kind2;
    }

    @Override
    public String getDescription() {
        return this.myKind.subject();
    }

    @Override
    public String getDescriptionAccusative() {
        return this.myKind.object();
    }

    @NotNull
    public Icon getKindIcon() {
        switch (this) {
            case CLASS: {
                return PlatformIcons.CLASS_ICON;
            }
            case INTERFACE: {
                return PlatformIcons.INTERFACE_ICON;
            }
            case ENUM: {
                return PlatformIcons.ENUM_ICON;
            }
            case ANNOTATION: {
                return PlatformIcons.ANNOTATION_TYPE_ICON;
            }
            case RECORD: {
                return PlatformIcons.RECORD_ICON;
            }
        }
        throw new IllegalStateException("Unexpected value: " + this);
    }

    @NotNull
    public PsiClass create(PsiElementFactory factory, String name2) {
        switch (this) {
            case CLASS: {
                return factory.createClass(name2);
            }
            case INTERFACE: {
                return factory.createInterface(name2);
            }
            case ENUM: {
                return factory.createEnum(name2);
            }
            case ANNOTATION: {
                return factory.createAnnotationType(name2);
            }
            case RECORD: {
                return factory.createRecord(name2);
            }
        }
        throw new IllegalStateException("Unexpected value: " + this);
    }

    @NotNull
    public PsiClass createInDirectory(PsiDirectory directory, String name2) {
        JavaDirectoryService service = JavaDirectoryService.getInstance();
        switch (this) {
            case INTERFACE: {
                return service.createInterface(directory, name2);
            }
            case CLASS: {
                return service.createClass(directory, name2);
            }
            case ENUM: {
                return service.createEnum(directory, name2);
            }
            case RECORD: {
                return service.createRecord(directory, name2);
            }
            case ANNOTATION: {
                return service.createAnnotationType(directory, name2);
            }
        }
        throw new IllegalStateException("Unexpected value: " + this);
    }
}

