/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SwitchStatementBranch;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BreakConverter;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConvertSwitchToIfIntention
implements IntentionAction {
    private final PsiSwitchStatement mySwitchStatement;

    public ConvertSwitchToIfIntention(@NotNull PsiSwitchStatement switchStatement) {
        this.mySwitchStatement = switchStatement;
    }

    @NotNull
    public String getText() {
        return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"switch", "if"});
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return ConvertSwitchToIfIntention.isAvailable(this.mySwitchStatement);
    }

    public static boolean isAvailable(PsiSwitchStatement switchStatement) {
        PsiCodeBlock body2 = switchStatement.getBody();
        return body2 != null && !body2.isEmpty() && BreakConverter.from((PsiSwitchBlock)switchStatement) != null && !ConvertSwitchToIfIntention.mayFallThroughNonTerminalDefaultCase(body2);
    }

    private static boolean mayFallThroughNonTerminalDefaultCase(PsiCodeBlock body2) {
        List labels2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)body2, PsiSwitchLabelStatementBase.class);
        return StreamEx.of((Collection)labels2).pairMap((prev, next) -> {
            if (prev.isDefaultCase()) {
                Set<PsiSwitchLabelStatementBase> targets = ConvertSwitchToIfIntention.getFallThroughTargets(body2);
                return targets.contains(prev) || targets.contains(next);
            }
            return false;
        }).has((Object)true);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        ConvertSwitchToIfIntention.doProcessIntention(this.mySwitchStatement);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.mySwitchStatement;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void doProcessIntention(@NotNull PsiSwitchStatement switchStatement) {
        String ifStatementText;
        String declarationString;
        String expressionText;
        boolean hadSideEffects;
        PsiCodeBlock body2;
        PsiExpression switchExpression = switchStatement.getExpression();
        if (switchExpression == null) {
            return;
        }
        PsiType switchExpressionType = RefactoringUtil.getTypeByExpressionWithExpectedType(switchExpression);
        if (switchExpressionType == null) {
            return;
        }
        CommentTracker commentTracker = new CommentTracker();
        boolean isSwitchOnString = switchExpressionType.equalsToText("java.lang.String");
        boolean useEquals = isSwitchOnString;
        if (!useEquals) {
            String fqn;
            PsiClass aClass = PsiUtil.resolveClassInType((PsiType)switchExpressionType);
            boolean bl = useEquals = aClass != null && !aClass.isEnum() && ((fqn = aClass.getQualifiedName()) == null || !TypeConversionUtil.isPrimitiveWrapper((String)fqn));
        }
        if ((body2 = switchStatement.getBody()) == null) {
            return;
        }
        Set<PsiSwitchLabelStatementBase> fallThroughTargets = ConvertSwitchToIfIntention.getFallThroughTargets(body2);
        boolean mayCompleteNormally = ControlFlowUtils.statementMayCompleteNormally((PsiStatement)switchStatement);
        BreakConverter converter = BreakConverter.from((PsiSwitchBlock)switchStatement);
        if (converter == null) {
            return;
        }
        converter.process();
        List<SwitchStatementBranch> allBranches = ConvertSwitchToIfIntention.extractBranches(commentTracker, body2, fallThroughTargets);
        Project project = switchStatement.getProject();
        int totalCases = allBranches.stream().mapToInt(br -> br.getCaseValues().size()).sum();
        if (totalCases > 0) {
            commentTracker.markUnchanged(switchExpression);
        }
        if (totalCases > 1 && RemoveUnusedVariableUtil.checkSideEffects(switchExpression, null, new ArrayList())) {
            String variableName2;
            hadSideEffects = true;
            expressionText = variableName2 = new VariableNameGenerator((PsiElement)switchExpression, VariableKind.LOCAL_VARIABLE).byExpression(switchExpression).byType(switchExpressionType).byName(isSwitchOnString ? "s" : "i").generate(true);
            declarationString = switchExpressionType.getCanonicalText() + ' ' + variableName2 + " = " + switchExpression.getText() + ';';
        } else {
            hadSideEffects = false;
            declarationString = null;
            expressionText = ParenthesesUtils.getPrecedence(switchExpression) > 9 ? '(' + switchExpression.getText() + ')' : switchExpression.getText();
        }
        StringBuilder ifStatementBuilder = new StringBuilder();
        boolean firstBranch = true;
        SwitchStatementBranch defaultBranch = null;
        for (SwitchStatementBranch branch : allBranches) {
            if (branch.isDefault()) {
                defaultBranch = branch;
                continue;
            }
            ConvertSwitchToIfIntention.dumpBranch(branch, expressionText, firstBranch, useEquals, ifStatementBuilder, commentTracker);
            firstBranch = false;
        }
        boolean unwrapDefault = false;
        if (defaultBranch != null) {
            boolean bl = unwrapDefault = defaultBranch.isAlwaysExecuted() || switchStatement.getParent() instanceof PsiCodeBlock && !mayCompleteNormally;
            if (!unwrapDefault && defaultBranch.hasStatements()) {
                ifStatementBuilder.append("else ");
                ConvertSwitchToIfIntention.dumpBody(defaultBranch, ifStatementBuilder, commentTracker);
            }
        }
        if ((ifStatementText = ifStatementBuilder.toString()).isEmpty()) {
            if (!unwrapDefault) {
                return;
            }
            ifStatementText = ";";
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiCodeBlock parent = (PsiCodeBlock)ObjectUtils.tryCast((Object)switchStatement.getParent(), PsiCodeBlock.class);
        if ((unwrapDefault || hadSideEffects) && parent == null) {
            commentTracker.grabComments((PsiElement)switchStatement);
            switchStatement = BlockUtils.expandSingleStatementToBlockStatement(switchStatement);
            parent = (PsiCodeBlock)switchStatement.getParent();
        }
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        if (hadSideEffects) {
            PsiStatement declarationStatement = factory.createStatementFromText(declarationString, (PsiElement)switchStatement);
            javaCodeStyleManager.shortenClassReferences(parent.addBefore((PsiElement)declarationStatement, (PsiElement)switchStatement));
        }
        PsiStatement ifStatement = factory.createStatementFromText(ifStatementText, (PsiElement)switchStatement);
        if (unwrapDefault) {
            PsiElement addedIf = parent.addBefore((PsiElement)ifStatement, (PsiElement)switchStatement);
            StringBuilder sb = new StringBuilder();
            ConvertSwitchToIfIntention.dumpBody(defaultBranch, sb, commentTracker);
            PsiBlockStatement defaultBody = (PsiBlockStatement)factory.createStatementFromText(sb.toString(), (PsiElement)switchStatement);
            if (!BlockUtils.containsConflictingDeclarations(Objects.requireNonNull(switchStatement.getBody()), parent)) {
                commentTracker.grabComments((PsiElement)switchStatement);
                BlockUtils.inlineCodeBlock((PsiStatement)switchStatement, defaultBody.getCodeBlock());
            } else {
                commentTracker.replace((PsiElement)switchStatement, (PsiElement)defaultBody);
            }
            commentTracker.insertCommentsBefore(addedIf);
            if (ifStatementText.equals(";")) {
                addedIf.delete();
            } else {
                javaCodeStyleManager.shortenClassReferences(addedIf);
            }
        } else {
            javaCodeStyleManager.shortenClassReferences(commentTracker.replaceAndRestoreComments((PsiElement)switchStatement, (PsiElement)ifStatement));
        }
    }

    @NotNull
    private static List<SwitchStatementBranch> extractBranches(CommentTracker commentTracker, PsiCodeBlock body2, Set<PsiSwitchLabelStatementBase> fallThroughTargets) {
        ArrayList<SwitchStatementBranch> openBranches = new ArrayList<SwitchStatementBranch>();
        HashSet declaredElements = new HashSet();
        ArrayList<SwitchStatementBranch> allBranches = new ArrayList<SwitchStatementBranch>();
        SwitchStatementBranch currentBranch = null;
        PsiElement[] children = body2.getChildren();
        List labels2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)body2, PsiSwitchLabelStatementBase.class);
        boolean defaultAlwaysExecuted = !labels2.isEmpty() && ((PsiSwitchLabelStatementBase)Objects.requireNonNull(ContainerUtil.getLastItem((List)labels2))).isDefaultCase() && fallThroughTargets.containsAll(labels2.subList(1, labels2.size()));
        for (int i = 1; i < children.length - 1; ++i) {
            PsiElement statement = children[i];
            if (statement instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement label = (PsiSwitchLabelStatement)statement;
                if (currentBranch == null || !fallThroughTargets.contains(statement)) {
                    openBranches.clear();
                    currentBranch = new SwitchStatementBranch();
                    currentBranch.addPendingDeclarations(declaredElements);
                    allBranches.add(currentBranch);
                    openBranches.add(currentBranch);
                } else if (currentBranch.hasStatements()) {
                    currentBranch = new SwitchStatementBranch();
                    allBranches.add(currentBranch);
                    openBranches.add(currentBranch);
                }
                if (label.isDefaultCase() && defaultAlwaysExecuted) {
                    openBranches.retainAll(Collections.singleton(currentBranch));
                }
                currentBranch.addCaseValues((PsiSwitchLabelStatementBase)label, defaultAlwaysExecuted, commentTracker);
                continue;
            }
            if (statement instanceof PsiSwitchLabeledRuleStatement) {
                openBranches.clear();
                PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)statement;
                currentBranch = new SwitchStatementBranch();
                PsiStatement ruleBody = rule.getBody();
                if (ruleBody != null) {
                    currentBranch.addStatement(ruleBody);
                }
                currentBranch.addCaseValues((PsiSwitchLabelStatementBase)rule, defaultAlwaysExecuted, commentTracker);
                openBranches.add(currentBranch);
                allBranches.add(currentBranch);
                continue;
            }
            if (statement instanceof PsiStatement) {
                if (statement instanceof PsiDeclarationStatement) {
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                    Collections.addAll(declaredElements, declarationStatement.getDeclaredElements());
                }
                for (SwitchStatementBranch branch : openBranches) {
                    branch.addStatement((PsiStatement)statement);
                }
                continue;
            }
            for (SwitchStatementBranch branch : openBranches) {
                if (statement instanceof PsiWhiteSpace) {
                    branch.addWhiteSpace(statement);
                    continue;
                }
                branch.addComment(statement);
            }
        }
        return allBranches;
    }

    private static Set<PsiSwitchLabelStatementBase> getFallThroughTargets(PsiCodeBlock body2) {
        return (Set)StreamEx.of((Object[])body2.getStatements()).pairMap((s1, s2) -> s2 instanceof PsiSwitchLabelStatement && !(s1 instanceof PsiSwitchLabeledRuleStatement) && ControlFlowUtils.statementMayCompleteNormally(s1) ? (PsiSwitchLabelStatement)s2 : null).nonNull().collect(Collectors.toSet());
    }

    private static void dumpBranch(SwitchStatementBranch branch, String expressionText, boolean firstBranch, boolean useEquals, @NonNls StringBuilder out, CommentTracker commentTracker) {
        if (!firstBranch) {
            out.append("else ");
        }
        ConvertSwitchToIfIntention.dumpCaseValues(expressionText, branch.getCaseValues(), useEquals, out);
        ConvertSwitchToIfIntention.dumpBody(branch, out, commentTracker);
    }

    private static void dumpCaseValues(String expressionText, List<String> caseValues2, boolean useEquals, @NonNls StringBuilder out) {
        out.append("if(");
        boolean firstCaseValue = true;
        for (String caseValue : caseValues2) {
            if (!firstCaseValue) {
                out.append("||");
            }
            firstCaseValue = false;
            if (useEquals) {
                out.append(caseValue).append(".equals(").append(expressionText).append(')');
                continue;
            }
            if (caseValue.equals("true")) {
                out.append(expressionText);
                continue;
            }
            if (caseValue.equals("false")) {
                out.append("!(").append(expressionText).append(")");
                continue;
            }
            out.append(expressionText).append("==").append(caseValue);
        }
        out.append(')');
    }

    private static void dumpBody(SwitchStatementBranch branch, @NonNls StringBuilder out, CommentTracker commentTracker) {
        PsiExpressionList values;
        PsiElement firstBodyElement;
        PsiElement prev;
        List<PsiElement> bodyStatements = branch.getBodyElements();
        out.append('{');
        if (!bodyStatements.isEmpty() && (prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)(firstBodyElement = bodyStatements.get(0)))) instanceof PsiSwitchLabelStatementBase && (values = ((PsiSwitchLabelStatementBase)prev).getCaseValues()) != null) {
            out.append(CommentTracker.commentsBetween((PsiElement)values, firstBodyElement));
        }
        for (PsiElement element : branch.getPendingDeclarations()) {
            if (ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope(bodyStatements.toArray(PsiElement.EMPTY_ARRAY))).findFirst() == null) continue;
            if (element instanceof PsiVariable) {
                PsiVariable var = (PsiVariable)element;
                out.append(var.getType().getCanonicalText()).append(' ').append(var.getName()).append(';');
                continue;
            }
            out.append(element.getText());
        }
        block1: for (PsiElement bodyStatement : bodyStatements) {
            if (bodyStatement instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)bodyStatement;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiElement start = PsiTreeUtil.skipWhitespacesForward((PsiElement)codeBlock.getFirstBodyElement());
                PsiElement end = PsiTreeUtil.skipWhitespacesBackward((PsiElement)codeBlock.getLastBodyElement());
                if (start == null || end == null || start == codeBlock.getRBrace()) continue;
                for (PsiElement child = start; child != null; child = child.getNextSibling()) {
                    out.append(commentTracker.text(child));
                    if (child == end) continue block1;
                }
                continue;
            }
            out.append(commentTracker.text(bodyStatement));
        }
        out.append("\n").append("}");
    }
}

