/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertDoubleToFloatFix
implements IntentionAction {
    private final PsiExpression myExpression;

    public ConvertDoubleToFloatFix(PsiExpression expression2) {
        this.myExpression = expression2;
    }

    @NotNull
    public String getText() {
        return JavaAnalysisBundle.message((String)"convert.0.to.float", (Object[])new Object[]{this.myExpression.getText()});
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (this.myExpression.isValid() && !StringUtil.endsWithIgnoreCase((String)this.myExpression.getText(), (String)"f")) {
            PsiLiteralExpression expression2 = (PsiLiteralExpression)this.createFloatingPointExpression(project);
            Object value2 = expression2.getValue();
            return value2 instanceof Float && !((Float)value2).isInfinite() && (((Float)value2).floatValue() != 0.0f || TypeConversionUtil.isFPZero((String)expression2.getText()));
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.myExpression.replace((PsiElement)this.createFloatingPointExpression(project));
    }

    private PsiExpression createFloatingPointExpression(Project project) {
        String text2 = this.myExpression.getText();
        if (StringUtil.endsWithIgnoreCase((String)text2, (String)"d")) {
            return JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(text2.substring(0, text2.length() - 1) + "f", (PsiElement)this.myExpression);
        }
        return JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(text2 + "f", (PsiElement)this.myExpression);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void registerIntentions(JavaResolveResult @NotNull [] candidates, @NotNull PsiExpressionList list, @Nullable HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions2 = list.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            ConvertDoubleToFloatFix.registerIntention(expressions2, highlightInfo, fixRange, candidate, (PsiElement)list);
        }
    }

    private static void registerIntention(PsiExpression @NotNull [] expressions2, @Nullable HighlightInfo highlightInfo, TextRange fixRange, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        PsiParameter[] parameters2;
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        if (method != null && BaseIntentionAction.canModify((PsiElement)method) && (parameters2 = method.getParameterList().getParameters()).length == expressions2.length) {
            int length = parameters2.length;
            for (int i = 0; i < length; ++i) {
                PsiParameter parameter2 = parameters2[i];
                PsiExpression expression2 = expressions2[i];
                if (!(expression2 instanceof PsiLiteralExpression) || !PsiType.FLOAT.equals((Object)parameter2.getType()) || !PsiType.DOUBLE.equals((Object)expression2.getType())) continue;
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)new ConvertDoubleToFloatFix(expression2));
            }
        }
    }
}

