/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.util.ChangeToAppendUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeToAppendFix
implements IntentionAction {
    private final IElementType myTokenType;
    private final PsiType myLhsType;
    private final PsiAssignmentExpression myAssignmentExpression;
    private volatile TypeInfo myTypeInfo;

    public ChangeToAppendFix(@NotNull IElementType eqOpSign, @NotNull PsiType lType, @NotNull PsiAssignmentExpression assignmentExpression) {
        this.myTokenType = eqOpSign;
        this.myLhsType = lType;
        this.myAssignmentExpression = assignmentExpression;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("change.to.append.text", ChangeToAppendUtil.buildAppendExpression(this.myAssignmentExpression.getRExpression(), this.getTypeInfo().myUseStringValueOf, new StringBuilder(this.myAssignmentExpression.getLExpression().getText())));
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("change.to.append.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return JavaTokenType.PLUSEQ == this.myTokenType && this.myAssignmentExpression.isValid() && BaseIntentionAction.canModify((PsiElement)this.myAssignmentExpression) && this.getTypeInfo().myAppendable;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiExpression appendExpression = ChangeToAppendUtil.buildAppendExpression(this.myAssignmentExpression.getLExpression(), this.myAssignmentExpression.getRExpression());
        if (appendExpression == null) {
            return;
        }
        this.myAssignmentExpression.replace((PsiElement)appendExpression);
    }

    @NotNull
    private TypeInfo getTypeInfo() {
        if (this.myTypeInfo != null) {
            return this.myTypeInfo;
        }
        this.myTypeInfo = this.calculateTypeInfo();
        return this.myTypeInfo;
    }

    @NotNull
    private TypeInfo calculateTypeInfo() {
        if (this.myLhsType.equalsToText("java.lang.StringBuilder") || this.myLhsType.equalsToText("java.lang.StringBuffer")) {
            return new TypeInfo(true, false);
        }
        if (InheritanceUtil.isInheritor((PsiType)this.myLhsType, (String)"java.lang.Appendable")) {
            return new TypeInfo(true, true);
        }
        return new TypeInfo(false, false);
    }

    private static class TypeInfo {
        private final boolean myAppendable;
        private final boolean myUseStringValueOf;

        TypeInfo(boolean appendable, boolean useStringValueOf) {
            this.myAppendable = appendable;
            this.myUseStringValueOf = useStringValueOf;
        }
    }
}

