/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeStringLiteralToCharInMethodCallFix
implements IntentionAction {
    private final PsiLiteralExpression myLiteral;
    private final PsiCall myCall;

    public ChangeStringLiteralToCharInMethodCallFix(PsiLiteralExpression literal, PsiCall methodCall) {
        this.myLiteral = literal;
        this.myCall = methodCall;
    }

    @NotNull
    public String getText() {
        String convertedValue = this.convertedValue();
        boolean isString = ChangeStringLiteralToCharInMethodCallFix.isString(this.myLiteral.getType());
        return QuickFixBundle.message("fix.single.character.string.to.char.literal.text", this.myLiteral.getText(), ChangeStringLiteralToCharInMethodCallFix.quote(convertedValue, !isString), isString ? PsiType.CHAR.getCanonicalText() : "String");
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("fix.single.character.string.to.char.literal.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myCall.isValid() && this.myLiteral.isValid() && BaseIntentionAction.canModify((PsiElement)this.myCall);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        Object value2 = this.myLiteral.getValue();
        if (value2 != null && value2.toString().length() == 1) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression newExpression = factory.createExpressionFromText(ChangeStringLiteralToCharInMethodCallFix.quote(this.convertedValue(), !ChangeStringLiteralToCharInMethodCallFix.isString(this.myLiteral.getType())), this.myLiteral.getParent());
            this.myLiteral.replace((PsiElement)newExpression);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static String quote(String value2, boolean doubleQuotes) {
        char quote = doubleQuotes ? (char)'\"' : '\'';
        return quote + value2 + quote;
    }

    private String convertedValue() {
        String value2 = String.valueOf(this.myLiteral.getValue());
        StringBuilder builder = new StringBuilder();
        StringUtil.escapeStringCharacters((int)value2.length(), (String)value2, (String)"\"'", (StringBuilder)builder);
        return builder.toString();
    }

    public static void registerFixes(PsiMethod @NotNull [] candidates, @NotNull PsiConstructorCall call, @NotNull HighlightInfo out) {
        HashSet literals = new HashSet();
        if (call.getArgumentList() == null) {
            return;
        }
        boolean exactMatch = false;
        for (PsiMethod method : candidates) {
            exactMatch |= ChangeStringLiteralToCharInMethodCallFix.findMatchingExpressions(call.getArgumentList().getExpressions(), method, literals);
        }
        if (!exactMatch) {
            ChangeStringLiteralToCharInMethodCallFix.processLiterals(literals, (PsiCall)call, out);
        }
    }

    public static void registerFixes(CandidateInfo @NotNull [] candidates, @NotNull PsiMethodCallExpression methodCall, @Nullable HighlightInfo info) {
        if (info == null) {
            return;
        }
        HashSet literals = new HashSet();
        boolean exactMatch = false;
        for (CandidateInfo candidate : candidates) {
            if (!(candidate instanceof MethodCandidateInfo)) continue;
            PsiMethod method = ((MethodCandidateInfo)candidate).getElement();
            exactMatch |= ChangeStringLiteralToCharInMethodCallFix.findMatchingExpressions(methodCall.getArgumentList().getExpressions(), method, literals);
        }
        if (!exactMatch) {
            ChangeStringLiteralToCharInMethodCallFix.processLiterals(literals, (PsiCall)methodCall, info);
        }
    }

    private static void processLiterals(@NotNull Set<? extends PsiLiteralExpression> literals, @NotNull PsiCall call, @NotNull HighlightInfo info) {
        for (PsiLiteralExpression psiLiteralExpression : literals) {
            ChangeStringLiteralToCharInMethodCallFix fix = new ChangeStringLiteralToCharInMethodCallFix(psiLiteralExpression, call);
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)fix);
        }
    }

    private static boolean findMatchingExpressions(PsiExpression[] arguments, PsiMethod existingMethod, Set<? super PsiLiteralExpression> result) {
        PsiParameterList parameterList = existingMethod.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        if (arguments.length != parameters2.length) {
            return false;
        }
        boolean typeMatch = true;
        for (int i = 0; i < parameters2.length; ++i) {
            String value2;
            PsiParameter parameter2 = parameters2[i];
            PsiType parameterType = parameter2.getType();
            PsiType argumentType = arguments[i].getType();
            typeMatch &= Comparing.equal((Object)parameterType, (Object)argumentType);
            PsiLiteralExpression argument = (PsiLiteralExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[i]), PsiLiteralExpression.class);
            if (argument == null || result.contains(argument) || !ChangeStringLiteralToCharInMethodCallFix.charToString(parameterType, argumentType) && !ChangeStringLiteralToCharInMethodCallFix.charToString(argumentType, parameterType) || (value2 = String.valueOf(argument.getValue())) == null || value2.length() != 1) continue;
            result.add((PsiLiteralExpression)argument);
        }
        return typeMatch;
    }

    private static boolean charToString(PsiType firstType, PsiType secondType) {
        return Comparing.equal((Object)PsiType.CHAR, (Object)firstType) && ChangeStringLiteralToCharInMethodCallFix.isString(secondType);
    }

    private static boolean isString(PsiType type2) {
        return type2 != null && type2.equalsToText("java.lang.String");
    }
}

