/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArgumentFixerActionFactory {
    private static final Logger LOG = Logger.getInstance(ArgumentFixerActionFactory.class);

    @Nullable
    protected abstract PsiExpression getModifiedArgument(PsiExpression var1, PsiType var2) throws IncorrectOperationException;

    public void registerCastActions(CandidateInfo @NotNull [] candidates, @NotNull PsiCall call, HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates.length == 0) {
            return;
        }
        ArrayList<CandidateInfo> methodCandidates = new ArrayList<CandidateInfo>(Arrays.asList(candidates));
        PsiExpressionList list = call.getArgumentList();
        if (list == null) {
            return;
        }
        PsiExpression[] expressions2 = list.getExpressions();
        if (expressions2.length == 0) {
            return;
        }
        block2: for (int i = methodCandidates.size() - 1; i >= 0; --i) {
            CandidateInfo candidate = (CandidateInfo)methodCandidates.get(i);
            PsiMethod method = (PsiMethod)candidate.getElement();
            PsiSubstitutor substitutor = candidate.getSubstitutor();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (expressions2.length != parameters2.length && !method.isVarArgs()) {
                methodCandidates.remove(i);
                continue;
            }
            for (int j = 0; j < Math.min(parameters2.length, expressions2.length); ++j) {
                PsiParameter parameter2 = parameters2[j];
                PsiExpression expression2 = expressions2[j];
                PsiType exprType = expression2.getType();
                PsiType parameterType = substitutor.substitute(parameter2.getType());
                if (exprType != null && parameterType != null && this.areTypesConvertible(exprType, parameterType, (PsiElement)call)) continue;
                methodCandidates.remove(i);
                continue block2;
            }
        }
        if (methodCandidates.isEmpty()) {
            return;
        }
        try {
            PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent((PsiElement)call);
            for (int i = 0; i < expressions2.length; ++i) {
                PsiExpression expression3 = expressions2[i];
                PsiType exprType = expression3.getType();
                THashSet suggestedCasts = new THashSet();
                for (CandidateInfo candidate : methodCandidates) {
                    PsiType type2;
                    PsiExpressionList argumentList;
                    PsiExpression modifiedExpression;
                    PsiCall newCall;
                    PsiPrimitiveType unboxedParameterType;
                    PsiType originalParameterType;
                    PsiMethod method = (PsiMethod)candidate.getElement();
                    PsiSubstitutor substitutor = candidate.getSubstitutor();
                    PsiType parameterType = substitutor.substitute(originalParameterType = PsiTypesUtil.getParameterType((PsiParameter[])method.getParameterList().getParameters(), (int)i, (boolean)true));
                    if (parameterType instanceof PsiWildcardType || !GenericsUtil.isFromExternalTypeLanguage((PsiType)parameterType) || suggestedCasts.contains(parameterType.getCanonicalText())) continue;
                    if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)exprType) && parameterType instanceof PsiClassType && (unboxedParameterType = PsiPrimitiveType.getUnboxedType((PsiType)parameterType)) != null) {
                        parameterType = unboxedParameterType;
                    }
                    if (Comparing.equal((Object)exprType, (Object)parameterType) || (newCall = LambdaUtil.copyTopLevelCall((PsiCall)call)) == null || (modifiedExpression = this.getModifiedArgument(expression3, parameterType)) == null || (argumentList = newCall.getArgumentList()) == null) continue;
                    argumentList.getExpressions()[i].replace((PsiElement)modifiedExpression);
                    JavaResolveResult resolveResult = newCall.resolveMethodGenerics();
                    if (resolveResult.getElement() == null || !resolveResult.isValidResult() || expectedTypeByParent != null && newCall instanceof PsiCallExpression && (type2 = ((PsiCallExpression)newCall).getType()) != null && !TypeConversionUtil.isAssignable((PsiType)expectedTypeByParent, (PsiType)type2)) continue;
                    suggestedCasts.add(parameterType.getCanonicalText());
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)this.createFix(list, i, parameterType));
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public abstract boolean areTypesConvertible(@NotNull PsiType var1, @NotNull PsiType var2, @NotNull PsiElement var3);

    public abstract IntentionAction createFix(PsiExpressionList var1, int var2, PsiType var3);
}

