/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnTypeFix;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddReturnFix
implements IntentionAction {
    private final PsiParameterListOwner myMethod;

    public AddReturnFix(@NotNull PsiParameterListOwner methodOrLambda) {
        this.myMethod = methodOrLambda;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("add.return.statement.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myMethod.isValid() && BaseIntentionAction.canModify((PsiElement)this.myMethod) && this.myMethod.getBody() instanceof PsiCodeBlock && ((PsiCodeBlock)this.myMethod.getBody()).getRBrace() != null;
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.myMethod;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (this.invokeSingleExpressionLambdaFix()) {
            return;
        }
        String value2 = this.suggestReturnValue();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myMethod.getProject());
        PsiReturnStatement returnStatement = (PsiReturnStatement)factory.createStatementFromText("return " + value2 + ";", (PsiElement)this.myMethod);
        PsiCodeBlock body2 = (PsiCodeBlock)ObjectUtils.tryCast((Object)this.myMethod.getBody(), PsiCodeBlock.class);
        assert (body2 != null);
        returnStatement = (PsiReturnStatement)body2.addBefore((PsiElement)returnStatement, (PsiElement)body2.getRBrace());
        MethodReturnTypeFix.selectInEditor((PsiElement)returnStatement.getReturnValue(), editor);
    }

    private String suggestReturnValue() {
        String conversion;
        PsiType type2;
        if (this.myMethod instanceof PsiMethod) {
            type2 = ((PsiMethod)this.myMethod).getReturnType();
        } else if (this.myMethod instanceof PsiLambdaExpression) {
            type2 = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)this.myMethod));
        } else {
            return "null";
        }
        List<PsiVariable> variables = AddReturnFix.getDeclaredVariables(this.myMethod);
        for (PsiVariable variable : variables) {
            PsiType varType = variable.getType();
            if (!varType.equals(type2)) continue;
            return variable.getName();
        }
        for (PsiVariable variable : variables) {
            conversion = this.getConversionToType(variable, type2, true);
            if (conversion == null) continue;
            return conversion;
        }
        for (PsiVariable variable : variables) {
            conversion = this.getConversionToType(variable, type2, false);
            if (conversion == null) continue;
            return conversion;
        }
        return PsiTypesUtil.getDefaultValueOfType((PsiType)type2);
    }

    private String getConversionToType(@NotNull PsiVariable variable, @Nullable PsiType type2, boolean preciseTypeReqired) {
        PsiType arrayComponentType;
        PsiType varType = variable.getType();
        if (type2 instanceof PsiArrayType && !((arrayComponentType = ((PsiArrayType)type2).getComponentType()) instanceof PsiPrimitiveType) && !(PsiUtil.resolveClassInType((PsiType)arrayComponentType) instanceof PsiTypeParameter) && InheritanceUtil.isInheritor((PsiType)varType, (String)"java.util.Collection")) {
            PsiType collectionItemType;
            PsiType erasedComponentType = TypeConversionUtil.erasure((PsiType)arrayComponentType);
            if ((!preciseTypeReqired || arrayComponentType.equals(erasedComponentType)) && (collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)varType, (GlobalSearchScope)this.myMethod.getResolveScope())) != null && erasedComponentType.isAssignableFrom(collectionItemType)) {
                if (erasedComponentType.equalsToText("java.lang.Object")) {
                    return variable.getName() + ".toArray()";
                }
                return variable.getName() + ".toArray(new " + erasedComponentType.getCanonicalText() + "[0])";
            }
        }
        return null;
    }

    @NotNull
    private static List<PsiVariable> getDeclaredVariables(PsiParameterListOwner method) {
        ArrayList<PsiVariable> variables = new ArrayList<PsiVariable>();
        PsiCodeBlock body2 = (PsiCodeBlock)ObjectUtils.tryCast((Object)method.getBody(), PsiCodeBlock.class);
        if (body2 != null) {
            PsiStatement[] statements;
            for (PsiStatement statement : statements = body2.getStatements()) {
                PsiElement[] declaredElements;
                if (!(statement instanceof PsiDeclarationStatement)) continue;
                for (PsiElement declaredElement : declaredElements = ((PsiDeclarationStatement)statement).getDeclaredElements()) {
                    if (!(declaredElement instanceof PsiLocalVariable)) continue;
                    variables.add((PsiVariable)declaredElement);
                }
            }
        }
        Object[] parameters2 = method.getParameterList().getParameters();
        ContainerUtil.addAll(variables, (Object[])parameters2);
        return variables;
    }

    private boolean invokeSingleExpressionLambdaFix() {
        PsiExpressionStatement expressionStatement;
        PsiExpression expression2;
        PsiType expressionType;
        PsiStatement[] statements;
        PsiCodeBlock body2;
        PsiType returnType;
        if (this.myMethod instanceof PsiLambdaExpression && (returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)this.myMethod))) != null && (body2 = (PsiCodeBlock)ObjectUtils.tryCast((Object)this.myMethod.getBody(), PsiCodeBlock.class)) != null && (statements = body2.getStatements()).length == 1 && statements[0] instanceof PsiExpressionStatement && (expressionType = (expression2 = (expressionStatement = (PsiExpressionStatement)statements[0]).getExpression()).getType()) != null && returnType.isAssignableFrom(expressionType)) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myMethod.getProject());
            PsiReturnStatement returnStatement = (PsiReturnStatement)factory.createStatementFromText("return 0;", (PsiElement)this.myMethod);
            Objects.requireNonNull(returnStatement.getReturnValue()).replace((PsiElement)expression2);
            CommentTracker tracker = new CommentTracker();
            tracker.markUnchanged(expression2);
            tracker.replaceAndRestoreComments((PsiElement)expressionStatement, (PsiElement)returnStatement);
            return true;
        }
        return false;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        return new AddReturnFix((PsiParameterListOwner)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myMethod, (PsiFile)target));
    }
}

