/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMethodQualifierFix
implements IntentionAction {
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    private final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCall;
    private List<PsiVariable> myCandidates;

    public AddMethodQualifierFix(PsiMethodCallExpression methodCallExpression) {
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCallExpression.getProject()).createSmartPsiElementPointer((PsiElement)methodCallExpression);
    }

    @NotNull
    public String getText() {
        if (this.myCandidates == null || this.myCandidates.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return "";
            }
            throw new IllegalStateException();
        }
        if (this.myCandidates.size() == 1) {
            return QuickFixBundle.message("add.method.qualifier.fix.text", this.myCandidates.get(0).getName());
        }
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("add.method.qualifier.fix.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiMethodCallExpression element = (PsiMethodCallExpression)this.myMethodCall.getElement();
        if (element == null || !element.isValid() || element.getMethodExpression().getQualifierExpression() != null) {
            return false;
        }
        if (this.myCandidates == null) {
            this.myCandidates = this.findCandidates(SearchMode.MAX_2_CANDIDATES);
        }
        return !this.myCandidates.isEmpty();
    }

    private List<PsiVariable> findCandidates(@NotNull SearchMode mode) {
        ArrayList<PsiVariable> candidates = new ArrayList<PsiVariable>();
        PsiMethodCallExpression methodCallElement = (PsiMethodCallExpression)this.myMethodCall.getElement();
        String methodName = methodCallElement.getMethodExpression().getReferenceName();
        if (methodName == null) {
            return Collections.emptyList();
        }
        for (PsiVariable var : CreateFromUsageUtils.guessMatchingVariables((PsiExpression)methodCallElement)) {
            PsiClass resolvedClass;
            PsiType type2;
            if (var.getName() == null || !((type2 = var.getType()) instanceof PsiClassType) || (resolvedClass = ((PsiClassType)type2).resolve()) == null || resolvedClass.findMethodsByName(methodName, true).length <= 0) continue;
            candidates.add(var);
            if (mode != SearchMode.MAX_2_CANDIDATES || candidates.size() < 2) continue;
            return candidates;
        }
        return candidates;
    }

    public List<PsiVariable> getCandidates() {
        return this.findCandidates(SearchMode.FULL_SEARCH);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return this.myMethodCall.getElement();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        List<PsiVariable> candidates = this.findCandidates(SearchMode.FULL_SEARCH);
        if (candidates.size() == 1 || UNIT_TEST_MODE) {
            this.qualify(candidates.get(0), editor);
        } else {
            this.chooseAndQualify(project, editor, candidates);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private void chooseAndQualify(Project project, final Editor editor, List<? extends PsiVariable> candidates) {
        BaseListPopupStep<PsiVariable> step2 = new BaseListPopupStep<PsiVariable>(QuickFixBundle.message("add.qualifier", new Object[0]), candidates){

            public PopupStep onChosen(PsiVariable selectedValue, boolean finalChoice) {
                if (selectedValue != null && finalChoice) {
                    AddMethodQualifierFix.this.qualify(selectedValue, editor);
                }
                return FINAL_CHOICE;
            }

            @NotNull
            public String getTextFor(PsiVariable value2) {
                return value2.getName();
            }

            public Icon getIconFor(PsiVariable aValue) {
                return aValue.getIcon(0);
            }
        };
        ListPopupImpl popup = new ListPopupImpl(project, (ListPopupStep)step2);
        popup.showInBestPositionFor(editor);
    }

    private void qualify(PsiVariable qualifier, Editor editor) {
        WriteCommandAction.runWriteCommandAction((Project)qualifier.getProject(), () -> {
            String qualifierPresentableText = qualifier.getName();
            PsiMethodCallExpression oldExpression = (PsiMethodCallExpression)this.myMethodCall.getElement();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)qualifier.getProject());
            PsiExpression expression2 = elementFactory.createExpressionFromText(qualifierPresentableText + "." + oldExpression.getMethodExpression().getReferenceName() + "()", null);
            PsiElement replacedExpression = oldExpression.replace((PsiElement)expression2);
            editor.getCaretModel().moveToOffset(replacedExpression.getTextOffset() + replacedExpression.getTextLength());
        });
    }

    private static enum SearchMode {
        MAX_2_CANDIDATES,
        FULL_SEARCH;

    }
}

