/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMethodFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final SmartPsiElementPointer<PsiMethod> myMethodPrototype;
    private final List<String> myExceptions = new ArrayList<String>();
    private String myText;

    public AddMethodFix(@NotNull PsiMethod methodPrototype, @NotNull PsiClass implClass) {
        super((PsiElement)implClass);
        this.myMethodPrototype = SmartPointerManager.createPointer((PsiElement)methodPrototype);
        this.setText(QuickFixBundle.message("add.method.text", methodPrototype.getName(), implClass.getName()));
    }

    public AddMethodFix(@NonNls @NotNull String methodText, @NotNull PsiClass implClass, String ... exceptions) {
        this(AddMethodFix.createMethod(methodText, implClass), implClass);
        ContainerUtil.addAll(this.myExceptions, (Object[])exceptions);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return this.myStartElement.getContainingFile();
    }

    @NotNull
    private static PsiMethod createMethod(String methodText, PsiClass implClass) {
        return JavaPsiFacade.getElementFactory((Project)implClass.getProject()).createMethodFromText(methodText, (PsiElement)implClass);
    }

    private static PsiMethod reformat(Project project, PsiMethod result) throws IncorrectOperationException {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        result = (PsiMethod)codeStyleManager.reformat((PsiElement)result);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        result = (PsiMethod)javaCodeStyleManager.shortenClassReferences((PsiElement)result);
        return result;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    protected void setText(@NotNull String text2) {
        this.myText = text2;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("add.method.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass myClass = (PsiClass)startElement;
        PsiMethod methodPrototype = (PsiMethod)this.myMethodPrototype.getElement();
        return methodPrototype != null && methodPrototype.isValid() && BaseIntentionAction.canModify((PsiElement)myClass) && this.myText != null && MethodSignatureUtil.findMethodBySignature((PsiClass)myClass, (PsiMethod)methodPrototype, (boolean)false) == null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiCodeBlock body2;
        PsiMethod methodPrototype = (PsiMethod)this.myMethodPrototype.getElement();
        if (methodPrototype == null) {
            return;
        }
        PsiClass myClass = (PsiClass)startElement;
        if (myClass.isInterface() && (body2 = methodPrototype.getBody()) != null) {
            body2.delete();
        }
        for (String exception : this.myExceptions) {
            PsiUtil.addException((PsiMethod)methodPrototype, (String)exception);
        }
        PsiMethod method = (PsiMethod)myClass.add((PsiElement)methodPrototype);
        method = (PsiMethod)method.replace((PsiElement)AddMethodFix.reformat(project, method));
        this.postAddAction(file, editor, method);
    }

    protected void postAddAction(@NotNull PsiFile file, @Nullable Editor editor, PsiMethod newMethod) {
        if (editor != null && newMethod.getContainingFile() == file) {
            GenerateMembersUtil.positionCaret(editor, (PsiElement)newMethod, true);
        }
    }
}

