/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddLibraryDependencyFix
extends OrderEntryFix {
    private final Module myCurrentModule;
    private final Library myLibrary;
    private final DependencyScope myScope;
    private final boolean myExported;
    private final String myQualifiedClassName;

    AddLibraryDependencyFix(PsiReference reference, Module currentModule, Library library, DependencyScope scope, boolean exported, String qName) {
        super(reference);
        this.myCurrentModule = currentModule;
        this.myLibrary = library;
        this.myScope = scope;
        this.myExported = exported;
        this.myQualifiedClassName = qName;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("orderEntry.fix.add.library.to.classpath", LibraryUtil.getPresentableName((Library)this.myLibrary));
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("orderEntry.fix.family.add.library.to.classpath", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return !project.isDisposed() && !this.myCurrentModule.isDisposed() && !((LibraryEx)this.myLibrary).isDisposed();
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
        JavaProjectModelModificationService.getInstance(project).addDependency(this.myCurrentModule, this.myLibrary, this.myScope, this.myExported);
        if (this.myQualifiedClassName != null && editor != null) {
            AddLibraryDependencyFix.importClass(this.myCurrentModule, editor, this.restoreReference(), this.myQualifiedClassName);
        }
    }
}

