/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddEmptyRecordHeaderFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public AddEmptyRecordHeaderFix(@NotNull PsiClass record) {
        super((PsiElement)record);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass record = (PsiClass)startElement;
        if (!record.isRecord() || record.getRecordHeader() != null) {
            return;
        }
        PsiTypeParameterList typeParameterList = record.getTypeParameterList();
        if (typeParameterList == null) {
            return;
        }
        PsiRecordHeader recordHeader = JavaPsiFacade.getElementFactory((Project)project).createRecordHeaderFromText("", (PsiElement)record);
        record.addAfter((PsiElement)recordHeader, (PsiElement)typeParameterList);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("insert.empty.parenthesis", new Object[0]);
    }
}

