/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MoveAnnotationOnStaticMemberQualifyingTypeFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    MoveAnnotationOnStaticMemberQualifyingTypeFix(@NotNull PsiAnnotation annotation) {
        super((PsiElement)annotation);
    }

    public @IntentionFamilyName @NotNull String getFamilyName() {
        return JavaErrorBundle.message("annotation.on.static.member.qualifying.type.family.name", new Object[0]);
    }

    public @IntentionName @NotNull String getText() {
        return this.getFamilyName();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiTypeElement psiTypeElement = MoveAnnotationOnStaticMemberQualifyingTypeFix.getTypeElement(startElement);
        if (psiTypeElement == null) {
            return;
        }
        PsiJavaCodeReferenceElement innermostParent = psiTypeElement.getInnermostComponentReferenceElement();
        if (innermostParent == null) {
            return;
        }
        PsiElement rightmostDot = MoveAnnotationOnStaticMemberQualifyingTypeFix.getRightmostDot(innermostParent.getLastChild());
        if (rightmostDot == null) {
            return;
        }
        innermostParent.addAfter(startElement, rightmostDot);
        CommentTracker ct = new CommentTracker();
        ct.markUnchanged(startElement);
        ct.deleteAndRestoreComments(startElement);
    }

    @Nullable(value="The type does not have DOT tokens")
    @Contract(value="null -> null", pure=true)
    private static @Nullable(value="The type does not have DOT tokens") PsiElement getRightmostDot(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        return PsiTreeUtil.findSiblingBackward((PsiElement)element, (IElementType)JavaTokenType.DOT, null);
    }

    @Nullable(value="No type element found")
    @Contract(pure=true)
    private static @Nullable(value="No type element found") PsiTypeElement getTypeElement(@NotNull PsiElement startElement) {
        PsiTypeElement psiTypeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiTypeElement.class);
        if (psiTypeElement != null) {
            return psiTypeElement;
        }
        PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiVariable.class);
        if (variable == null) {
            return null;
        }
        return variable.getTypeElement();
    }
}

