/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaHighlightUtil {
    public static boolean isSerializable(@NotNull PsiClass aClass) {
        return JavaHighlightUtil.isSerializable(aClass, "java.io.Serializable");
    }

    public static boolean isSerializable(@NotNull PsiClass aClass, @NotNull String serializableClassName) {
        Project project = aClass.getManager().getProject();
        PsiClass serializableClass = JavaPsiFacade.getInstance((Project)project).findClass(serializableClassName, aClass.getResolveScope());
        return serializableClass != null && aClass.isInheritor(serializableClass, true);
    }

    public static boolean isSerializationRelatedMethod(@NotNull PsiMethod method, @Nullable PsiClass containingClass) {
        if (containingClass == null) {
            return false;
        }
        if (method.isConstructor()) {
            return JavaHighlightUtil.isSerializable(containingClass, "java.io.Externalizable") && method.getParameterList().isEmpty() && method.hasModifierProperty("public");
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        String name2 = method.getName();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if ("readObjectNoData".equals(name2)) {
            PsiType returnType = method.getReturnType();
            return parameters2.length == 0 && TypeConversionUtil.isVoidType((PsiType)returnType) && JavaHighlightUtil.isSerializable(containingClass);
        }
        if ("readObject".equals(name2)) {
            PsiType returnType = method.getReturnType();
            return parameters2.length == 1 && parameters2[0].getType().equalsToText("java.io.ObjectInputStream") && TypeConversionUtil.isVoidType((PsiType)returnType) && method.hasModifierProperty("private") && JavaHighlightUtil.isSerializable(containingClass);
        }
        if ("readResolve".equals(name2)) {
            PsiType returnType = method.getReturnType();
            return parameters2.length == 0 && returnType != null && returnType.equalsToText("java.lang.Object") && (containingClass.hasModifierProperty("abstract") || JavaHighlightUtil.isSerializable(containingClass));
        }
        if ("writeReplace".equals(name2)) {
            PsiType returnType = method.getReturnType();
            return parameters2.length == 0 && returnType != null && returnType.equalsToText("java.lang.Object") && (containingClass.hasModifierProperty("abstract") || JavaHighlightUtil.isSerializable(containingClass));
        }
        if ("writeObject".equals(name2)) {
            PsiType returnType = method.getReturnType();
            return parameters2.length == 1 && TypeConversionUtil.isVoidType((PsiType)returnType) && parameters2[0].getType().equalsToText("java.io.ObjectOutputStream") && method.hasModifierProperty("private") && JavaHighlightUtil.isSerializable(containingClass);
        }
        return false;
    }

    @NotNull
    public static String formatType(@Nullable PsiType type2) {
        return type2 == null ? "null" : type2.getInternalCanonicalText();
    }

    @Nullable
    private static PsiType getArrayInitializerType(@NotNull PsiArrayInitializerExpression element) {
        PsiType typeCheckResult = JavaHighlightUtil.sameType(element.getInitializers());
        return typeCheckResult != null ? typeCheckResult.createArrayType() : null;
    }

    @Nullable
    public static PsiType sameType(PsiExpression @NotNull [] expressions2) {
        PsiType type2 = null;
        for (PsiExpression expression2 : expressions2) {
            PsiType currentType = expression2 instanceof PsiArrayInitializerExpression ? JavaHighlightUtil.getArrayInitializerType((PsiArrayInitializerExpression)expression2) : expression2.getType();
            if (type2 == null) {
                type2 = currentType;
                continue;
            }
            if (type2.equals(currentType)) continue;
            return null;
        }
        return type2;
    }

    @NotNull
    public static String formatMethod(@NotNull PsiMethod method) {
        return PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
    }

    public static boolean isSuperOrThisCall(@NotNull PsiStatement statement, boolean testForSuper, boolean testForThis) {
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression2 = ((PsiExpressionStatement)statement).getExpression();
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)expression2).getMethodExpression();
        if (testForSuper && "super".equals(methodExpression.getText())) {
            return true;
        }
        return testForThis && "this".equals(methodExpression.getText());
    }

    @NotNull
    public static List<PsiMethod> getChainedConstructors(@NotNull PsiMethod constructor) {
        ConstructorVisitorInfo info = new ConstructorVisitorInfo();
        JavaHighlightUtil.visitConstructorChain(constructor, info);
        if (info.visitedConstructors != null) {
            info.visitedConstructors.remove(constructor);
        }
        return (List)ObjectUtils.notNull(info.visitedConstructors, Collections.emptyList());
    }

    static void visitConstructorChain(@NotNull PsiMethod entry, @NotNull ConstructorVisitorInfo info) {
        PsiMethod constructor = entry;
        PsiMethodCallExpression methodCall;
        while (JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)(methodCall = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor)))) {
            PsiMethod method = methodCall.resolveMethod();
            if (method == null) {
                return;
            }
            if (info.visitedConstructors != null && info.visitedConstructors.contains(method)) {
                info.recursivelyCalledConstructor = method;
                return;
            }
            if (info.visitedConstructors == null) {
                info.visitedConstructors = new ArrayList<PsiMethod>(5);
            }
            info.visitedConstructors.add(method);
            constructor = method;
        }
        return;
    }

    @Nullable
    public static String checkPsiTypeUseInContext(@NotNull PsiType type2, @NotNull PsiElement context) {
        if (type2 instanceof PsiPrimitiveType) {
            return null;
        }
        if (type2 instanceof PsiArrayType) {
            return JavaHighlightUtil.checkPsiTypeUseInContext(((PsiArrayType)type2).getComponentType(), context);
        }
        if (PsiUtil.resolveClassInType((PsiType)type2) != null) {
            return null;
        }
        if (type2 instanceof PsiClassType) {
            return JavaHighlightUtil.checkClassType((PsiClassType)type2, context);
        }
        return JavaHighlightUtil.invalidJavaTypeMessage();
    }

    @NotNull
    @Nls
    public static String invalidJavaTypeMessage() {
        return JavaAnalysisBundle.message((String)"error.message.invalid.java.type", (Object[])new Object[0]);
    }

    @NotNull
    private static String checkClassType(@NotNull PsiClassType type2, @NotNull PsiElement context) {
        String className2 = PsiNameHelper.getQualifiedClassName((String)type2.getCanonicalText(false), (boolean)true);
        if (JavaHighlightUtil.classExists(context, className2)) {
            return JavaHighlightUtil.getClassInaccessibleMessage(context, className2);
        }
        return JavaHighlightUtil.invalidJavaTypeMessage();
    }

    private static boolean classExists(@NotNull PsiElement context, @NotNull String className2) {
        return JavaPsiFacade.getInstance((Project)context.getProject()).findClass(className2, GlobalSearchScope.allScope((Project)context.getProject())) != null;
    }

    @NotNull
    @Nls
    private static String getClassInaccessibleMessage(@NotNull PsiElement context, @NotNull String className2) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return JavaAnalysisBundle.message((String)"message.class.inaccessible", (Object[])new Object[]{className2});
        }
        return JavaAnalysisBundle.message((String)"message.class.inaccessible.from.module", (Object[])new Object[]{className2, module.getName()});
    }

    static class ConstructorVisitorInfo {
        List<PsiMethod> visitedConstructors;
        PsiMethod recursivelyCalledConstructor;

        ConstructorVisitorInfo() {
        }
    }
}

