/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class JavaFutureKeywordUseFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    public void registerFixes(@NotNull PsiJavaCodeReferenceElement ref, @NotNull QuickFixActionRegistrar registrar) {
        PsiTypeElement typeElement = (PsiTypeElement)ObjectUtils.tryCast((Object)ref.getParent(), PsiTypeElement.class);
        if (typeElement == null || typeElement.getFirstChild() != typeElement.getLastChild()) {
            return;
        }
        PsiElement parent = typeElement.getParent();
        if ("var".equals(ref.getReferenceName())) {
            JavaFutureKeywordUseFixProvider.registerVarLanguageLevelFix(ref, parent, registrar);
        }
        if ("record".equals(ref.getReferenceName())) {
            JavaFutureKeywordUseFixProvider.registerRecordLanguageLevelFix(ref, parent, registrar);
        }
    }

    private static void registerRecordLanguageLevelFix(@NotNull PsiJavaCodeReferenceElement ref, PsiElement parent, @NotNull QuickFixActionRegistrar registrar) {
        if ((parent instanceof PsiMethod || parent instanceof PsiField) && parent.getParent() instanceof PsiClass) {
            HighlightUtil.registerIncreaseLanguageLevelFixes(registrar, (PsiElement)ref, HighlightingFeature.RECORDS);
        }
        if (parent instanceof PsiLocalVariable && parent.getParent() instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)parent.getParent()).getDeclaredElements().length == 1) {
            HighlightUtil.registerIncreaseLanguageLevelFixes(registrar, (PsiElement)ref, HighlightingFeature.RECORDS);
        }
    }

    private static void registerVarLanguageLevelFix(@NotNull PsiJavaCodeReferenceElement ref, PsiElement parent, @NotNull QuickFixActionRegistrar registrar) {
        HighlightingFeature feature = parent instanceof PsiParameter && ((PsiParameter)parent).getDeclarationScope() instanceof PsiLambdaExpression ? HighlightingFeature.VAR_LAMBDA_PARAMETER : HighlightingFeature.LVTI;
        HighlightUtil.registerIncreaseLanguageLevelFixes(registrar, (PsiElement)ref, feature);
    }

    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        return PsiJavaCodeReferenceElement.class;
    }
}

