/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.AcceptedLanguageLevelsSettings;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncreaseLanguageLevelFix
implements IntentionAction,
LocalQuickFix,
HighPriorityAction {
    private final LanguageLevel myLevel;

    public IncreaseLanguageLevelFix(@NotNull LanguageLevel targetLevel) {
        this.myLevel = targetLevel;
    }

    @NotNull
    public String getText() {
        return JavaBundle.message((String)"set.language.level.to.0", (Object[])new Object[]{this.myLevel.getPresentableText()});
    }

    @Nls
    @NotNull
    public String getName() {
        return this.getText();
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"set.language.level", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (!this.isAvailable(project, null, element.getContainingFile())) {
            return;
        }
        this.invoke(project, null, element.getContainingFile());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        return module != null && JavaSdkUtil.isLanguageLevelAcceptable(project, module, this.myLevel) && (editor != null || AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(this.myLevel));
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (!AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(this.myLevel)) {
            assert (editor != null);
            if (AcceptedLanguageLevelsSettings.checkAccepted(editor.getComponent(), this.myLevel) == null) {
                return;
            }
        }
        WriteAction.run(() -> {
            final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            final LanguageLevel oldLevel = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
            if (module != null) {
                JavaProjectModelModificationService.getInstance(project).changeLanguageLevel(module, this.myLevel);
                VirtualFile vFile = file.getVirtualFile();
                if (oldLevel != null) {
                    UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{vFile}){

                        public void undo() {
                            JavaProjectModelModificationService.getInstance(project).changeLanguageLevel(module, oldLevel);
                        }

                        public void redo() {
                            JavaProjectModelModificationService.getInstance(project).changeLanguageLevel(module, IncreaseLanguageLevelFix.this.myLevel);
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

