/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.JavaModuleSystemEx;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsConditionalFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeNewOperatorTypeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteRepeatedInterfaceFix;
import com.intellij.codeInsight.daemon.impl.quickfix.FlipIntersectionSidesFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifySuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyWithThisFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableArrayTypeFix;
import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFixOnPsiElementAsIntentionAdapter;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.JavaLanguageLevelPusher;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaModuleSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PatternResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.VariablesNotProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import gnu.trove.THashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class HighlightUtil {
    private static final Logger LOG = Logger.getInstance(HighlightUtil.class);
    private static final Map<String, Set<String>> ourInterfaceIncompatibleModifiers = new THashMap(7);
    private static final Map<String, Set<String>> ourMethodIncompatibleModifiers = new THashMap(11);
    private static final Map<String, Set<String>> ourFieldIncompatibleModifiers = new THashMap(8);
    private static final Map<String, Set<String>> ourClassIncompatibleModifiers = new THashMap(8);
    private static final Map<String, Set<String>> ourClassInitializerIncompatibleModifiers = new THashMap(1);
    private static final Map<String, Set<String>> ourModuleIncompatibleModifiers = new THashMap(1);
    private static final Map<String, Set<String>> ourRequiresIncompatibleModifiers = new THashMap(2);
    private static final Set<String> ourConstructorNotAllowedModifiers = ContainerUtil.newTroveSet((Object[])new String[]{"abstract", "static", "native", "final", "strictfp", "synchronized"});
    private static final String SERIAL_PERSISTENT_FIELDS_FIELD_NAME = "serialPersistentFields";
    private static final Set<String> RESTRICTED_RECORD_COMPONENT_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"clone", "finalize", "getClass", "hashCode", "notify", "notifyAll", "toString", "wait"});
    private static final Pattern FP_LITERAL_PARTS;

    private HighlightUtil() {
    }

    @NotNull
    private static QuickFixFactory getFixFactory() {
        return QuickFixFactory.getInstance();
    }

    private static String getIncompatibleModifier(@NotNull String modifier, @NotNull PsiModifierList modifierList, @NotNull Map<String, Set<String>> incompatibleModifiersHash) {
        PsiElement[] modifiers = modifierList.getChildren();
        int modifierCount = 0;
        for (PsiElement otherModifier : modifiers) {
            if (!Comparing.equal((String)modifier, (String)otherModifier.getText(), (boolean)true)) continue;
            ++modifierCount;
        }
        if (modifierCount > 1) {
            return modifier;
        }
        Set<String> incompatibles = incompatibleModifiersHash.get(modifier);
        if (incompatibles == null) {
            return null;
        }
        PsiElement parent = modifierList.getParent();
        boolean level8OrHigher = PsiUtil.isLanguageLevel8OrHigher((PsiElement)modifierList);
        boolean level9OrHigher = PsiUtil.isLanguageLevel9OrHigher((PsiElement)modifierList);
        for (String incompatible : incompatibles) {
            PsiClass containingClass;
            if (level8OrHigher && modifier.equals("static") && incompatible.equals("abstract") || parent instanceof PsiMethod && (level9OrHigher && modifier.equals("private") && incompatible.equals("public") || modifier.equals("static") && incompatible.equals("final") && ((containingClass = ((PsiMethod)parent).getContainingClass()) == null || !containingClass.isInterface()))) continue;
            if (modifierList.hasModifierProperty(incompatible)) {
                return incompatible;
            }
            if (!"abstract".equals(incompatible) || !modifierList.hasExplicitModifier(incompatible)) continue;
            return incompatible;
        }
        return null;
    }

    static HighlightInfo checkInstanceOfApplicable(@NotNull PsiInstanceOfExpression expression2) {
        PsiExpression operand2 = expression2.getOperand();
        PsiTypeElement typeElement = expression2.getCheckType();
        if (typeElement == null) {
            return null;
        }
        PsiType checkType = typeElement.getType();
        PsiType operandType = operand2.getType();
        if (operandType == null) {
            return null;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)operandType) || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)checkType) || !TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)checkType)) {
            String message2 = JavaErrorBundle.message("inconvertible.type.cast", JavaHighlightUtil.formatType(operandType), JavaHighlightUtil.formatType(checkType));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkIntersectionInTypeCast(@NotNull PsiTypeCastExpression expression2, @NotNull LanguageLevel languageLevel, @NotNull PsiFile file) {
        PsiTypeElement castTypeElement = expression2.getCastType();
        if (castTypeElement != null && HighlightUtil.isIntersection(castTypeElement, castTypeElement.getType())) {
            HighlightInfo info = HighlightUtil.checkFeature((PsiElement)expression2, HighlightingFeature.INTERSECTION_CASTS, languageLevel, file);
            if (info != null) {
                return info;
            }
            PsiTypeElement[] conjuncts = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)castTypeElement, PsiTypeElement.class);
            if (conjuncts != null) {
                Ref differentArgumentsMessage;
                HashSet<PsiType> erasures = new HashSet<PsiType>(conjuncts.length);
                erasures.add(TypeConversionUtil.erasure((PsiType)conjuncts[0].getType()));
                ArrayList<PsiTypeElement> conjList = new ArrayList<PsiTypeElement>(Arrays.asList(conjuncts));
                for (int i = 1; i < conjuncts.length; ++i) {
                    PsiTypeElement conjunct = conjuncts[i];
                    PsiType conjType = conjunct.getType();
                    if (conjType instanceof PsiClassType) {
                        PsiClass aClass = ((PsiClassType)conjType).resolve();
                        if (aClass != null && !aClass.isInterface()) {
                            HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)conjunct).descriptionAndTooltip(JavaErrorBundle.message("interface.expected", new Object[0])).create();
                            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)new FlipIntersectionSidesFix(aClass.getName(), conjList, conjunct, castTypeElement), null);
                            return errorResult;
                        }
                    } else {
                        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)conjunct).descriptionAndTooltip(JavaErrorBundle.message("unexpected.type.class.expected", new Object[0])).create();
                    }
                    if (erasures.add(TypeConversionUtil.erasure((PsiType)conjType))) continue;
                    HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)conjunct).descriptionAndTooltip(JavaErrorBundle.message("repeated.interface", new Object[0])).create();
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)new DeleteRepeatedInterfaceFix(conjunct, conjList), null);
                    return highlightInfo;
                }
                List typeList = ContainerUtil.map(conjList, PsiTypeElement::getType);
                PsiClass sameGenericParameterization = InferenceSession.findParameterizationOfTheSameGenericClass(typeList, (Processor<? super Pair<PsiType, PsiType>>)((Processor)arg_0 -> HighlightUtil.lambda$checkIntersectionInTypeCast$0(differentArgumentsMessage = new Ref(), arg_0)));
                if (sameGenericParameterization != null) {
                    String message2 = JavaErrorBundle.message("class.cannot.be.inherited.with.different.arguments", HighlightUtil.formatClass(sameGenericParameterization), differentArgumentsMessage.get());
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message2).create();
                }
            }
        }
        return null;
    }

    private static boolean isIntersection(@NotNull PsiTypeElement castTypeElement, @NotNull PsiType castType) {
        if (castType instanceof PsiIntersectionType) {
            return true;
        }
        return castType instanceof PsiClassType && PsiTreeUtil.getChildrenOfType((PsiElement)castTypeElement, PsiTypeElement.class) != null;
    }

    static HighlightInfo checkInconvertibleTypeCast(@NotNull PsiTypeCastExpression expression2) {
        PsiTypeElement castTypeElement = expression2.getCastType();
        if (castTypeElement == null) {
            return null;
        }
        PsiType castType = castTypeElement.getType();
        PsiExpression operand2 = expression2.getOperand();
        if (operand2 == null) {
            return null;
        }
        PsiType operandType = operand2.getType();
        if (operandType != null && !TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)castType, (LanguageLevel)PsiUtil.getLanguageLevel((PsiElement)expression2)) && !RedundantCastUtil.isInPolymorphicCall(expression2)) {
            String message2 = JavaErrorBundle.message("inconvertible.type.cast", JavaHighlightUtil.formatType(operandType), JavaHighlightUtil.formatType(castType));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkVariableExpected(@NotNull PsiExpression expression2) {
        PsiExpression lValue;
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
            lValue = assignment.getLExpression();
        } else {
            lValue = PsiUtil.isIncrementDecrementOperation((PsiElement)expression2) ? ((PsiUnaryExpression)expression2).getOperand() : null;
        }
        HighlightInfo errorResult = null;
        if (lValue != null && !TypeConversionUtil.isLValue((PsiExpression)lValue)) {
            String description = JavaErrorBundle.message("variable.expected", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)lValue).descriptionAndTooltip(description).create();
        }
        return errorResult;
    }

    static HighlightInfo checkAssignmentOperatorApplicable(@NotNull PsiAssignmentExpression assignment) {
        PsiJavaToken operationSign = assignment.getOperationSign();
        IElementType eqOpSign = operationSign.getTokenType();
        IElementType opSign = TypeConversionUtil.convertEQtoOperation((IElementType)eqOpSign);
        if (opSign == null) {
            return null;
        }
        PsiType lType = assignment.getLExpression().getType();
        PsiExpression rExpression = assignment.getRExpression();
        if (rExpression == null) {
            return null;
        }
        PsiType rType = rExpression.getType();
        HighlightInfo errorResult = null;
        if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)opSign, (PsiType)lType, (PsiType)rType, (boolean)true)) {
            String operatorText = operationSign.getText().substring(0, operationSign.getText().length() - 1);
            String message2 = JavaErrorBundle.message("binary.operator.not.applicable", operatorText, JavaHighlightUtil.formatType(lType), JavaHighlightUtil.formatType(rType));
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)operationSign).descriptionAndTooltip(message2).create();
        }
        return errorResult;
    }

    static HighlightInfo checkAssignmentCompatibleTypes(@NotNull PsiAssignmentExpression assignment) {
        HighlightInfo highlightInfo;
        PsiExpression lExpr = assignment.getLExpression();
        PsiExpression rExpr = assignment.getRExpression();
        if (rExpr == null) {
            return null;
        }
        PsiType lType = lExpr.getType();
        PsiType rType = rExpr.getType();
        if (rType == null) {
            return null;
        }
        IElementType sign = assignment.getOperationTokenType();
        if (JavaTokenType.EQ.equals(sign)) {
            highlightInfo = HighlightUtil.checkAssignability(lType, rType, rExpr, (PsiElement)assignment);
        } else {
            IElementType opSign = TypeConversionUtil.convertEQtoOperation((IElementType)sign);
            PsiType type2 = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)opSign, (boolean)true);
            if (type2 == null || lType == null || TypeConversionUtil.areTypesConvertible((PsiType)type2, (PsiType)lType)) {
                return null;
            }
            highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo(lType, type2, assignment.getTextRange(), 0);
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createChangeToAppendFix(sign, lType, assignment));
        }
        if (highlightInfo == null) {
            return null;
        }
        HighlightFixUtil.registerChangeVariableTypeFixes(lExpr, rType, rExpr, highlightInfo);
        if (lType != null) {
            HighlightFixUtil.registerChangeVariableTypeFixes(rExpr, lType, lExpr, highlightInfo);
        }
        return highlightInfo;
    }

    private static boolean isCastIntentionApplicable(@NotNull PsiExpression expression2, @Nullable PsiType toType) {
        while (expression2 instanceof PsiTypeCastExpression || expression2 instanceof PsiParenthesizedExpression) {
            if (expression2 instanceof PsiTypeCastExpression) {
                expression2 = ((PsiTypeCastExpression)expression2).getOperand();
            }
            if (!(expression2 instanceof PsiParenthesizedExpression)) continue;
            expression2 = ((PsiParenthesizedExpression)expression2).getExpression();
        }
        if (expression2 == null) {
            return false;
        }
        PsiType rType = expression2.getType();
        PsiType castType = GenericsUtil.getVariableTypeByExpressionType((PsiType)toType);
        return rType != null && toType != null && TypeConversionUtil.areTypesConvertible((PsiType)rType, (PsiType)toType) && toType.isAssignableFrom(castType);
    }

    static HighlightInfo checkVariableInitializerType(@NotNull PsiVariable variable) {
        int end;
        PsiTypeElement typeElement;
        int start;
        PsiType rType;
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null || initializer instanceof PsiArrayInitializerExpression) {
            return null;
        }
        PsiType lType = variable.getType();
        HighlightInfo highlightInfo = HighlightUtil.checkAssignability(lType, rType = initializer.getType(), initializer, new TextRange(start = (typeElement = variable.getTypeElement()) != null ? typeElement.getTextRange().getStartOffset() : variable.getTextRange().getStartOffset(), end = variable.getTextRange().getEndOffset()), 0);
        if (highlightInfo != null) {
            HighlightFixUtil.registerChangeVariableTypeFixes(variable, rType, variable.getInitializer(), highlightInfo);
            HighlightFixUtil.registerChangeVariableTypeFixes(initializer, lType, null, highlightInfo);
        }
        return highlightInfo;
    }

    static HighlightInfo checkRestrictedIdentifierReference(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiClass resolved, @NotNull LanguageLevel languageLevel) {
        String name2 = resolved.getName();
        if (HighlightClassUtil.isRestrictedIdentifier(name2, languageLevel)) {
            String message2 = JavaErrorBundle.message("restricted.identifier.reference", name2);
            PsiElement range = (PsiElement)ObjectUtils.notNull((Object)ref.getReferenceNameElement(), (Object)ref);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message2).range(range).create();
        }
        return null;
    }

    static HighlightInfo checkVarTypeApplicability(@NotNull PsiVariable variable) {
        PsiTypeElement typeElement = variable.getTypeElement();
        if (typeElement != null && typeElement.isInferredType()) {
            if (variable instanceof PsiLocalVariable) {
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) {
                    String message2 = JavaErrorBundle.message("lvti.no.initializer", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message2).range((PsiElement)typeElement).create();
                }
                if (initializer instanceof PsiFunctionalExpression) {
                    boolean lambda2 = initializer instanceof PsiLambdaExpression;
                    String message3 = JavaErrorBundle.message(lambda2 ? "lvti.lambda" : "lvti.method.ref", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message3).range((PsiElement)typeElement).create();
                }
                PsiElement parent = variable.getParent();
                if (parent instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)parent).getDeclaredElements().length > 1) {
                    String message4 = JavaErrorBundle.message("lvti.compound", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message4).range((PsiElement)variable).create();
                }
                if (HighlightUtil.isArray(variable)) {
                    String message5 = JavaErrorBundle.message("lvti.array", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message5).range((PsiElement)typeElement).create();
                }
                PsiType lType = variable.getType();
                if (PsiType.NULL.equals((Object)lType)) {
                    boolean isSelfReferencing = ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope((PsiElement)initializer)).findFirst() != null;
                    String message6 = JavaErrorBundle.message(isSelfReferencing ? "lvti.selfReferenced" : "lvti.null", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message6).range((PsiElement)typeElement).create();
                }
                if (PsiType.VOID.equals((Object)lType)) {
                    String message7 = JavaErrorBundle.message("lvti.void", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message7).range((PsiElement)typeElement).create();
                }
            } else if (variable instanceof PsiParameter && variable.getParent() instanceof PsiParameterList && HighlightUtil.isArray(variable)) {
                String message8 = JavaErrorBundle.message("lvti.array", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message8).range((PsiElement)typeElement).create();
            }
        }
        return null;
    }

    private static boolean isArray(@NotNull PsiVariable variable) {
        return Stream.of(variable.getChildren()).anyMatch(e -> PsiUtil.isJavaToken((PsiElement)e, (IElementType)JavaTokenType.LBRACKET));
    }

    static HighlightInfo checkAssignability(@Nullable PsiType lType, @Nullable PsiType rType, @Nullable PsiExpression expression2, @NotNull PsiElement elementToHighlight) {
        TextRange textRange = elementToHighlight.getTextRange();
        return HighlightUtil.checkAssignability(lType, rType, expression2, textRange, 0);
    }

    private static HighlightInfo checkAssignability(@Nullable PsiType lType, @Nullable PsiType rType, @Nullable PsiExpression expression2, @NotNull TextRange textRange, int navigationShift) {
        if (lType == rType) {
            return null;
        }
        if (expression2 == null ? rType == null || lType == null || TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType) : TypeConversionUtil.areTypesAssignmentCompatible((PsiType)lType, (PsiExpression)expression2)) {
            return null;
        }
        if (rType == null) {
            rType = expression2.getType();
        }
        if (lType == PsiType.NULL) {
            return null;
        }
        HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo(lType, rType, textRange, navigationShift);
        if (rType != null && expression2 != null && HighlightUtil.isCastIntentionApplicable(expression2, lType)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createAddTypeCastFix(lType, expression2));
        }
        if (expression2 != null) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createWrapWithOptionalFix(lType, expression2));
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createWrapExpressionFix(lType, expression2));
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createWrapWithAdapterFix(lType, expression2));
            AddTypeArgumentsConditionalFix.register(highlightInfo, expression2, lType);
            HighlightFixUtil.registerCollectionToArrayFixAction(highlightInfo, rType, lType, expression2);
            HighlightFixUtil.registerChangeReturnTypeFix(highlightInfo, expression2, lType);
        }
        ChangeNewOperatorTypeFix.register(highlightInfo, expression2, lType);
        return highlightInfo;
    }

    static HighlightInfo checkReturnFromSwitchExpr(@NotNull PsiStatement statement) {
        if (PsiImplUtil.findEnclosingSwitchExpression((PsiElement)statement) != null) {
            String message2 = JavaErrorBundle.message("return.outside.switch.expr", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkReturnStatementType(@NotNull PsiReturnStatement statement, @NotNull PsiElement parent) {
        if (parent instanceof PsiCodeFragment || parent instanceof PsiLambdaExpression) {
            return null;
        }
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)parent, PsiMethod.class);
        HighlightInfo errorResult = null;
        if (method == null && !(parent instanceof ServerPageFile)) {
            String description = JavaErrorBundle.message("return.outside.method", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
        } else {
            PsiType returnType = method != null ? method.getReturnType() : null;
            boolean isMethodVoid = returnType == null || PsiType.VOID.equals((Object)returnType);
            PsiExpression returnValue = statement.getReturnValue();
            if (returnValue != null) {
                PsiType valueType = RefactoringChangeUtil.getTypeByExpression(returnValue);
                if (isMethodVoid) {
                    String description = JavaErrorBundle.message("return.from.void.method", new Object[0]);
                    errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
                    if (method != null && valueType != null && method.getBody() != null) {
                        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)HighlightUtil.getFixFactory().createDeleteReturnFix(method, statement));
                        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)HighlightUtil.getFixFactory().createMethodReturnFix(method, valueType, true));
                    }
                } else {
                    TextRange textRange = statement.getTextRange();
                    errorResult = HighlightUtil.checkAssignability(returnType, valueType, returnValue, textRange, returnValue.getStartOffsetInParent());
                    if (errorResult != null && valueType != null) {
                        PsiType erasedValueType;
                        if (!PsiType.VOID.equals((Object)valueType)) {
                            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)HighlightUtil.getFixFactory().createMethodReturnFix(method, valueType, true));
                        }
                        HighlightFixUtil.registerChangeParameterClassFix(returnType, valueType, errorResult);
                        if (returnType instanceof PsiArrayType && (erasedValueType = TypeConversionUtil.erasure((PsiType)valueType)) != null && TypeConversionUtil.isAssignable((PsiType)((PsiArrayType)returnType).getComponentType(), (PsiType)erasedValueType)) {
                            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)HighlightUtil.getFixFactory().createSurroundWithArrayFix(null, returnValue));
                        }
                        HighlightFixUtil.registerCollectionToArrayFixAction(errorResult, valueType, returnType, returnValue);
                    }
                }
            } else if (!isMethodVoid) {
                String description = JavaErrorBundle.message("missing.return.value", new Object[0]);
                errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).navigationShift("return".length()).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)HighlightUtil.getFixFactory().createMethodReturnFix(method, (PsiType)PsiType.VOID, true));
            }
        }
        return errorResult;
    }

    static void registerReturnTypeFixes(@NotNull HighlightInfo info, @NotNull PsiMethod method, @NotNull PsiType expectedReturnType) {
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createMethodReturnFix(method, expectedReturnType, true, true));
    }

    @NotNull
    public static String getUnhandledExceptionsDescriptor(@NotNull Collection<? extends PsiClassType> unhandled) {
        return HighlightUtil.getUnhandledExceptionsDescriptor(unhandled, null);
    }

    @NotNull
    private static String getUnhandledExceptionsDescriptor(@NotNull Collection<? extends PsiClassType> unhandled, @Nullable String source) {
        String exceptions = HighlightUtil.formatTypes(unhandled);
        return source == null ? JavaErrorBundle.message("unhandled.exceptions", exceptions, unhandled.size()) : JavaErrorBundle.message("unhandled.close.exceptions", exceptions, unhandled.size(), source);
    }

    @NotNull
    private static String formatTypes(@NotNull Collection<? extends PsiClassType> unhandled) {
        return StringUtil.join(unhandled, JavaHighlightUtil::formatType, (String)", ");
    }

    static HighlightInfo checkVariableAlreadyDefined(@NotNull PsiVariable variable) {
        if (variable instanceof ExternallyDefinedPsiElement) {
            return null;
        }
        Object oldVariable = null;
        PsiElement declarationScope = null;
        if (variable instanceof PsiLocalVariable || variable instanceof PsiPatternVariable || variable instanceof PsiParameter && ((declarationScope = ((PsiParameter)variable).getDeclarationScope()) instanceof PsiCatchSection || declarationScope instanceof PsiForeachStatement || declarationScope instanceof PsiLambdaExpression)) {
            PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiFile.class, PsiMethod.class, PsiClassInitializer.class, PsiResourceList.class});
            VariablesNotProcessor proc = new VariablesNotProcessor(variable, false){

                @Override
                protected boolean check(PsiVariable var, ResolveState state) {
                    return PsiUtil.isJvmLocalVariable((PsiElement)var) && super.check(var, state);
                }
            };
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            PsiScopesUtil.treeWalkUp(proc, (PsiElement)identifier, scope);
            if (scope instanceof PsiResourceList && proc.size() == 0) {
                scope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiFile.class, PsiMethod.class, PsiClassInitializer.class});
                PsiScopesUtil.treeWalkUp(proc, (PsiElement)identifier, scope);
            }
            if (proc.size() > 0) {
                oldVariable = proc.getResult(0);
            } else if (declarationScope instanceof PsiLambdaExpression) {
                oldVariable = HighlightUtil.findSameNameSibling(variable);
            } else if (variable instanceof PsiPatternVariable) {
                oldVariable = HighlightUtil.findSamePatternVariableInBranches((PsiPatternVariable)variable);
            }
        } else if (variable instanceof PsiField) {
            PsiField field = (PsiField)variable;
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiField fieldByName = aClass.findFieldByName(variable.getName(), false);
            oldVariable = fieldByName != null && fieldByName != field ? fieldByName : (PsiVariable)ContainerUtil.find((Object[])aClass.getRecordComponents(), c -> c.getName().equals(field.getName()));
        } else {
            oldVariable = HighlightUtil.findSameNameSibling(variable);
        }
        if (oldVariable != null) {
            String description = JavaErrorBundle.message("variable.already.defined", variable.getName());
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)identifier);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier);
            if (vFile != null) {
                String path = FileUtil.toSystemIndependentName((String)vFile.getPath());
                String linkText = "<a href=\"#navigation/" + path + ":" + oldVariable.getTextOffset() + "\">" + variable.getName() + "</a>";
                builder = builder.description(description).escapedToolTip("<html>" + JavaErrorBundle.message("variable.already.defined", linkText) + "</html>");
            } else {
                builder = builder.descriptionAndTooltip(description);
            }
            HighlightInfo highlightInfo = builder.create();
            if (variable instanceof PsiLocalVariable) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createReuseVariableDeclarationFix((PsiLocalVariable)variable));
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createNavigateToAlreadyDeclaredVariableFix(oldVariable));
            return highlightInfo;
        }
        return null;
    }

    private static PsiPatternVariable findSamePatternVariableInBranches(@NotNull PsiPatternVariable variable) {
        PsiPattern pattern = variable.getPattern();
        PatternResolveState hint = PatternResolveState.WHEN_TRUE;
        VariablesNotProcessor proc = new VariablesNotProcessor((PsiVariable)variable, false){

            @Override
            protected boolean check(PsiVariable var, ResolveState state) {
                return var instanceof PsiPatternVariable && super.check(var, state);
            }
        };
        PsiPattern lastParent = pattern;
        for (PsiElement parent = lastParent.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PsiInstanceOfExpression) && !(parent instanceof PsiParenthesizedExpression)) {
                IElementType tokenType;
                if (parent instanceof PsiPrefixExpression && ((PsiPrefixExpression)parent).getOperationTokenType().equals(JavaTokenType.EXCL)) {
                    hint = hint.invert();
                } else if (parent instanceof PsiPolyadicExpression && ((tokenType = ((PsiPolyadicExpression)parent).getOperationTokenType()).equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR))) {
                    PatternResolveState targetHint = PatternResolveState.fromBoolean(tokenType.equals(JavaTokenType.OROR));
                    if (hint == targetHint) {
                        for (PsiExpression operand2 : ((PsiPolyadicExpression)parent).getOperands()) {
                            if (operand2 == lastParent) break;
                            operand2.processDeclarations((PsiScopeProcessor)proc, hint.putInto(ResolveState.initial()), null, (PsiElement)pattern);
                        }
                    }
                } else {
                    if (!(parent instanceof PsiConditionalExpression)) break;
                    PsiConditionalExpression conditional = (PsiConditionalExpression)parent;
                    PsiExpression thenExpression2 = conditional.getThenExpression();
                    if (lastParent == thenExpression2) {
                        conditional.getCondition().processDeclarations((PsiScopeProcessor)proc, PatternResolveState.WHEN_FALSE.putInto(ResolveState.initial()), null, (PsiElement)pattern);
                        break;
                    }
                    if (lastParent != conditional.getElseExpression()) break;
                    conditional.getCondition().processDeclarations((PsiScopeProcessor)proc, PatternResolveState.WHEN_TRUE.putInto(ResolveState.initial()), null, (PsiElement)pattern);
                    if (thenExpression2 == null) break;
                    thenExpression2.processDeclarations((PsiScopeProcessor)proc, hint.putInto(ResolveState.initial()), null, (PsiElement)pattern);
                    break;
                }
            }
            lastParent = parent;
        }
        return proc.size() > 0 ? (PsiPatternVariable)proc.getResult(0) : null;
    }

    private static PsiVariable findSameNameSibling(@NotNull PsiVariable variable) {
        PsiElement[] children;
        PsiElement scope = variable.getParent();
        for (PsiElement child : children = scope.getChildren()) {
            if (!(child instanceof PsiVariable) || child.equals(variable) || !Objects.equals(variable.getName(), ((PsiVariable)child).getName())) continue;
            return (PsiVariable)child;
        }
        return null;
    }

    static HighlightInfo checkUnderscore(@NotNull PsiIdentifier identifier, @NotNull LanguageLevel languageLevel) {
        if ("_".equals(identifier.getText())) {
            PsiElement parent;
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
                String text2 = JavaErrorBundle.message("underscore.identifier.error", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(text2).create();
            }
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (parent = identifier.getParent()) instanceof PsiParameter && ((PsiParameter)parent).getDeclarationScope() instanceof PsiLambdaExpression) {
                String text3 = JavaErrorBundle.message("underscore.lambda.identifier", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(text3).create();
            }
        }
        return null;
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass) {
        return HighlightUtil.formatClass(aClass, true);
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass, boolean fqn) {
        return PsiFormatUtil.formatClass((PsiClass)aClass, (int)(0x8001 | (fqn ? 2048 : 0)));
    }

    @NotNull
    private static String formatField(@NotNull PsiField field) {
        return PsiFormatUtil.formatVariable((PsiVariable)field, (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }

    static HighlightInfo checkUnhandledExceptions(@NotNull PsiElement element, @Nullable TextRange textRange) {
        List<PsiClassType> unhandled = ExceptionUtil.getOwnUnhandledExceptions(element);
        if (unhandled.isEmpty()) {
            return null;
        }
        HighlightInfoType highlightType = HighlightUtil.getUnhandledExceptionHighlightType(element);
        if (highlightType == null) {
            return null;
        }
        if (textRange == null) {
            textRange = element.getTextRange();
        }
        String description = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightType).range(textRange).descriptionAndTooltip(description).create();
        HighlightFixUtil.registerUnhandledExceptionFixes(element, errorResult);
        return errorResult;
    }

    static HighlightInfo checkUnhandledCloserExceptions(@NotNull PsiResourceListElement resource) {
        List<PsiClassType> unhandled = ExceptionUtil.getUnhandledCloserExceptions(resource, null);
        if (unhandled.isEmpty()) {
            return null;
        }
        HighlightInfoType highlightType = HighlightUtil.getUnhandledExceptionHighlightType((PsiElement)resource);
        if (highlightType == null) {
            return null;
        }
        String description = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled, "auto-closeable resource");
        HighlightInfo highlight = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightType).range((PsiElement)resource).descriptionAndTooltip(description).create();
        HighlightFixUtil.registerUnhandledExceptionFixes((PsiElement)resource, highlight);
        return highlight;
    }

    @Nullable
    private static HighlightInfoType getUnhandledExceptionHighlightType(@NotNull PsiElement element) {
        PsiMethod targetMethod;
        if (FileTypeUtils.isInServerPageFile((PsiElement)element) && (targetMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class})) instanceof SyntheticElement) {
            return null;
        }
        return HighlightInfoType.UNHANDLED_EXCEPTION;
    }

    static HighlightInfo checkBreakTarget(@NotNull PsiBreakStatement statement, @NotNull LanguageLevel languageLevel) {
        return HighlightUtil.checkBreakOrContinueTarget((PsiStatement)statement, statement.getLabelIdentifier(), statement.findExitedStatement(), languageLevel, "break.outside.switch.or.loop", "break.outside.switch.expr");
    }

    static HighlightInfo checkYieldOutsideSwitchExpression(@NotNull PsiYieldStatement statement) {
        if (statement.findEnclosingExpression() == null) {
            String message2 = JavaErrorBundle.message("yield.unexpected", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkYieldExpressionType(@NotNull PsiYieldStatement statement) {
        PsiExpression expression2 = statement.getExpression();
        if (expression2 != null && PsiType.VOID.equals((Object)expression2.getType())) {
            String message2 = JavaErrorBundle.message("yield.void", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkContinueTarget(@NotNull PsiContinueStatement statement, @NotNull LanguageLevel languageLevel) {
        PsiStatement continuedStatement = statement.findContinuedStatement();
        PsiIdentifier label = statement.getLabelIdentifier();
        if (label != null && continuedStatement != null && !(continuedStatement instanceof PsiLoopStatement)) {
            String message2 = JavaErrorBundle.message("not.loop.label", label.getText());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
        }
        return HighlightUtil.checkBreakOrContinueTarget((PsiStatement)statement, label, continuedStatement, languageLevel, "continue.outside.loop", "continue.outside.switch.expr");
    }

    private static HighlightInfo checkBreakOrContinueTarget(@NotNull PsiStatement statement, @Nullable PsiIdentifier label, @Nullable PsiStatement target, @NotNull LanguageLevel level, @NotNull @PropertyKey(resourceBundle="messages.JavaErrorBundle") String misplacedKey, @NotNull @PropertyKey(resourceBundle="messages.JavaErrorBundle") String crossingKey) {
        PsiSwitchExpression expression2;
        if (target == null && label != null) {
            String message2 = JavaErrorBundle.message("unresolved.label", label.getText());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)label).descriptionAndTooltip(message2).create();
        }
        if (HighlightingFeature.ENHANCED_SWITCH.isSufficient(level) && (expression2 = PsiImplUtil.findEnclosingSwitchExpression((PsiElement)statement)) != null && (target == null || PsiTreeUtil.isAncestor((PsiElement)target, (PsiElement)expression2, (boolean)true))) {
            String message3 = JavaErrorBundle.message(crossingKey, new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message3).create();
        }
        if (target == null) {
            String message4 = JavaErrorBundle.message(misplacedKey, new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message4).create();
        }
        return null;
    }

    static HighlightInfo checkIllegalModifierCombination(@NotNull PsiKeyword keyword, @NotNull PsiModifierList modifierList) {
        String modifier = keyword.getText();
        String incompatible = HighlightUtil.getIncompatibleModifier(modifier, modifierList);
        if (incompatible != null) {
            String message2 = JavaErrorBundle.message("incompatible.modifiers", modifier, incompatible);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createModifierListFix(modifierList, modifier, false, false));
            return highlightInfo;
        }
        return null;
    }

    public static boolean isIllegalModifierCombination(@NotNull PsiModifierList modifierList) {
        for (PsiElement child = modifierList.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiKeyword) || HighlightUtil.getIncompatibleModifier(child.getText(), modifierList) == null) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Set<String>> getIncompatibleModifierMap(@NotNull PsiElement modifierListOwner) {
        if (PsiUtilCore.hasErrorElementChild((PsiElement)modifierListOwner)) {
            return null;
        }
        if (modifierListOwner instanceof PsiClass) {
            return ((PsiClass)modifierListOwner).isInterface() ? ourInterfaceIncompatibleModifiers : ourClassIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiMethod) {
            return ourMethodIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiVariable) {
            return ourFieldIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiClassInitializer) {
            return ourClassInitializerIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiJavaModule) {
            return ourModuleIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiRequiresStatement) {
            return ourRequiresIncompatibleModifiers;
        }
        return null;
    }

    @Nullable
    static String getIncompatibleModifier(@NotNull String modifier, @NotNull PsiModifierList modifierList) {
        PsiElement parent = modifierList.getParent();
        if (parent == null) {
            return null;
        }
        Map<String, Set<String>> incompatibleModifierMap = HighlightUtil.getIncompatibleModifierMap(parent);
        return incompatibleModifierMap == null ? null : HighlightUtil.getIncompatibleModifier(modifier, modifierList, incompatibleModifierMap);
    }

    static HighlightInfo checkNotAllowedModifier(@NotNull PsiKeyword keyword, @NotNull PsiModifierList modifierList) {
        PsiElement modifierOwnerParent;
        PsiElement modifierOwner = modifierList.getParent();
        if (modifierOwner == null) {
            return null;
        }
        Map<String, Set<String>> incompatibleModifierMap = HighlightUtil.getIncompatibleModifierMap(modifierOwner);
        if (incompatibleModifierMap == null) {
            return null;
        }
        String modifier = keyword.getText();
        Set<String> incompatibles = incompatibleModifierMap.get(modifier);
        Object object = modifierOwnerParent = modifierOwner instanceof PsiMember ? ((PsiMember)modifierOwner).getContainingClass() : modifierOwner.getParent();
        if (modifierOwnerParent == null) {
            modifierOwnerParent = modifierOwner.getParent();
        }
        boolean isAllowed = true;
        IntentionAction fix = null;
        if (modifierOwner instanceof PsiClass) {
            boolean privateOrProtected;
            PsiClass aClass = (PsiClass)modifierOwner;
            boolean bl = privateOrProtected = "private".equals(modifier) || "protected".equals(modifier);
            if (aClass.isInterface()) {
                if ("static".equals(modifier) || privateOrProtected || "packageLocal".equals(modifier)) {
                    isAllowed = modifierOwnerParent instanceof PsiClass;
                }
                if ("public".equals(modifier)) {
                    isAllowed = !(modifierOwnerParent instanceof PsiDeclarationStatement);
                }
            } else {
                if ("public".equals(modifier)) {
                    isAllowed = modifierOwnerParent instanceof PsiImportHolder || modifierOwnerParent instanceof PsiClass && (modifierOwnerParent instanceof PsiSyntheticClass || ((PsiClass)modifierOwnerParent).getQualifiedName() != null || !modifierOwnerParent.isPhysical());
                } else {
                    if ("static".equals(modifier) || privateOrProtected || "packageLocal".equals(modifier)) {
                        boolean bl2 = isAllowed = modifierOwnerParent instanceof PsiClass && ((PsiClass)modifierOwnerParent).getQualifiedName() != null || FileTypeUtils.isInServerPageFile((PsiElement)modifierOwnerParent) || !modifierOwnerParent.isPhysical();
                    }
                    if (privateOrProtected && !isAllowed) {
                        fix = HighlightUtil.getFixFactory().createChangeModifierFix();
                    }
                }
                if (aClass.isEnum()) {
                    isAllowed &= !"final".equals(modifier) && !"abstract".equals(modifier);
                }
                if (aClass.isRecord()) {
                    isAllowed &= !"abstract".equals(modifier);
                }
                if (aClass.getContainingClass() instanceof PsiAnonymousClass) {
                    isAllowed &= !privateOrProtected;
                }
            }
            if ("non-sealed".equals(modifier) && !aClass.hasModifierProperty("sealed")) {
                isAllowed = Arrays.stream(aClass.getSuperTypes()).map(PsiClassType::resolve).anyMatch(superClass -> superClass != null && superClass.hasModifierProperty("sealed"));
            }
        } else if (modifierOwner instanceof PsiMethod) {
            boolean isInterface;
            PsiMethod method = (PsiMethod)modifierOwner;
            isAllowed = !method.isConstructor() || !ourConstructorNotAllowedModifiers.contains(modifier);
            PsiClass containingClass = method.getContainingClass();
            if ((method.hasModifierProperty("public") || method.hasModifierProperty("protected")) && method.isConstructor() && containingClass != null && containingClass.isEnum()) {
                isAllowed = false;
            }
            boolean bl = isInterface = modifierOwnerParent instanceof PsiClass && ((PsiClass)modifierOwnerParent).isInterface();
            if ("private".equals(modifier) && modifierOwnerParent instanceof PsiClass) {
                isAllowed &= !isInterface || PsiUtil.isLanguageLevel9OrHigher((PsiElement)modifierOwner) && !((PsiClass)modifierOwnerParent).isAnnotationType();
            } else if ("strictfp".equals(modifier)) {
                isAllowed &= !isInterface || PsiUtil.isLanguageLevel8OrHigher((PsiElement)modifierOwner);
            } else if ("protected".equals(modifier) || "transient".equals(modifier) || "synchronized".equals(modifier)) {
                isAllowed &= !isInterface;
            }
            if (containingClass != null && (containingClass.isInterface() || containingClass.isRecord())) {
                isAllowed &= !"native".equals(modifier);
            }
            if (containingClass != null && containingClass.isAnnotationType()) {
                isAllowed &= !"static".equals(modifier);
                isAllowed &= !"default".equals(modifier);
            }
            if (JavaPsiRecordUtil.getRecordComponentForAccessor(method) != null) {
                isAllowed &= !"static".equals(modifier);
            }
        } else if (modifierOwner instanceof PsiField) {
            if ("private".equals(modifier) || "protected".equals(modifier) || "transient".equals(modifier) || "strictfp".equals(modifier) || "synchronized".equals(modifier)) {
                isAllowed = modifierOwnerParent instanceof PsiClass && !((PsiClass)modifierOwnerParent).isInterface();
            }
        } else if (modifierOwner instanceof PsiClassInitializer) {
            isAllowed = "static".equals(modifier);
        } else if (modifierOwner instanceof PsiLocalVariable || modifierOwner instanceof PsiParameter) {
            isAllowed = "final".equals(modifier);
        } else if (modifierOwner instanceof PsiReceiverParameter || modifierOwner instanceof PsiRecordComponent) {
            isAllowed = false;
        }
        if (!(isAllowed &= incompatibles != null)) {
            String message2 = JavaErrorBundle.message("modifier.not.allowed", modifier);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)(fix != null ? fix : HighlightUtil.getFixFactory().createModifierListFix(modifierList, modifier, false, false)));
            return highlightInfo;
        }
        return null;
    }

    public static HighlightInfo checkLiteralExpressionParsingError(@NotNull PsiLiteralExpression expression2, @NotNull LanguageLevel level, @Nullable PsiFile file) {
        Number number;
        boolean success;
        StringBuilder chars;
        String cleanText;
        PsiElement literal = expression2.getFirstChild();
        assert (literal instanceof PsiJavaToken) : literal;
        IElementType type2 = ((PsiJavaToken)literal).getTokenType();
        if (type2 == JavaTokenType.TRUE_KEYWORD || type2 == JavaTokenType.FALSE_KEYWORD || type2 == JavaTokenType.NULL_KEYWORD) {
            return null;
        }
        boolean isInt = ElementType.INTEGER_LITERALS.contains(type2);
        boolean isFP = ElementType.REAL_LITERALS.contains(type2);
        String text2 = isInt || isFP ? StringUtil.toLowerCase((String)literal.getText()) : literal.getText();
        Object value2 = expression2.getValue();
        if (file != null) {
            HighlightInfo info;
            if (isFP && text2.startsWith("0x") && (info = HighlightUtil.checkFeature((PsiElement)expression2, HighlightingFeature.HEX_FP_LITERALS, level, file)) != null) {
                return info;
            }
            if (isInt && text2.startsWith("0b") && (info = HighlightUtil.checkFeature((PsiElement)expression2, HighlightingFeature.BIN_LITERALS, level, file)) != null) {
                return info;
            }
            if ((isInt || isFP) && text2.contains("_")) {
                info = HighlightUtil.checkFeature((PsiElement)expression2, HighlightingFeature.UNDERSCORES, level, file);
                if (info != null) {
                    return info;
                }
                info = HighlightUtil.checkUnderscores((PsiElement)expression2, text2, isInt);
                if (info != null) {
                    return info;
                }
            }
        }
        PsiElement parent = expression2.getParent();
        if (type2 == JavaTokenType.INTEGER_LITERAL) {
            cleanText = StringUtil.replace((String)text2, (String)"_", (String)"");
            if (!cleanText.equals(PsiLiteralUtil._2_IN_31) || !(parent instanceof PsiPrefixExpression) || ((PsiPrefixExpression)parent).getOperationTokenType() != JavaTokenType.MINUS) {
                if (cleanText.equals("0x")) {
                    String message2 = JavaErrorBundle.message("hexadecimal.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message2).create();
                }
                if (cleanText.equals("0b")) {
                    String message3 = JavaErrorBundle.message("binary.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message3).create();
                }
                if (value2 == null || cleanText.equals(PsiLiteralUtil._2_IN_31)) {
                    String message4 = JavaErrorBundle.message("integer.number.too.large", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message4).create();
                }
            }
        } else if (type2 == JavaTokenType.LONG_LITERAL) {
            cleanText = StringUtil.replace((String)StringUtil.trimEnd((String)text2, (char)'l'), (String)"_", (String)"");
            if (!cleanText.equals(PsiLiteralUtil._2_IN_63) || !(parent instanceof PsiPrefixExpression) || ((PsiPrefixExpression)parent).getOperationTokenType() != JavaTokenType.MINUS) {
                if (cleanText.equals("0x")) {
                    String message5 = JavaErrorBundle.message("hexadecimal.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message5).create();
                }
                if (cleanText.equals("0b")) {
                    String message6 = JavaErrorBundle.message("binary.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message6).create();
                }
                if (value2 == null || cleanText.equals(PsiLiteralUtil._2_IN_63)) {
                    String message7 = JavaErrorBundle.message("long.number.too.large", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message7).create();
                }
            }
        } else if (isFP) {
            if (value2 == null) {
                String message8 = JavaErrorBundle.message("malformed.floating.point.literal", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message8).create();
            }
        } else if (type2 == JavaTokenType.CHARACTER_LITERAL) {
            if (value2 == null) {
                if (!StringUtil.startsWithChar((CharSequence)text2, (char)'\'')) {
                    return null;
                }
                if (!StringUtil.endsWithChar((CharSequence)text2, (char)'\'') || text2.length() == 1) {
                    String message9 = JavaErrorBundle.message("unclosed.char.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message9).create();
                }
                success = PsiLiteralExpressionImpl.parseStringCharacters(text2 = text2.substring(1, text2.length() - 1), chars = new StringBuilder(), null);
                if (!success) {
                    String message10 = JavaErrorBundle.message("illegal.escape.character.in.character.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message10).create();
                }
                int length = chars.length();
                if (length > 1) {
                    String message11 = JavaErrorBundle.message("too.many.characters.in.character.literal", new Object[0]);
                    HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message11).create();
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createConvertToStringLiteralAction());
                    return info;
                }
                if (length == 0) {
                    String message12 = JavaErrorBundle.message("empty.character.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message12).create();
                }
            }
        } else if (type2 == JavaTokenType.STRING_LITERAL || type2 == JavaTokenType.TEXT_BLOCK_LITERAL) {
            HighlightInfo info;
            if (type2 == JavaTokenType.STRING_LITERAL) {
                if (value2 == null) {
                    String message13;
                    for (PsiElement element = expression2.getFirstChild(); element != null; element = element.getNextSibling()) {
                        if (!(element instanceof OuterLanguageElement)) continue;
                        return null;
                    }
                    if (!StringUtil.startsWithChar((CharSequence)text2, (char)'\"')) {
                        return null;
                    }
                    if (StringUtil.endsWithChar((CharSequence)text2, (char)'\"')) {
                        if (text2.length() == 1) {
                            message13 = JavaErrorBundle.message("illegal.line.end.in.string.literal", new Object[0]);
                            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message13).create();
                        }
                    } else {
                        message13 = JavaErrorBundle.message("illegal.line.end.in.string.literal", new Object[0]);
                        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message13).create();
                    }
                    text2 = text2.substring(1, text2.length() - 1);
                    chars = new StringBuilder();
                    success = PsiLiteralExpressionImpl.parseStringCharacters(text2, chars, null);
                    if (!success) {
                        String message14 = JavaErrorBundle.message("illegal.escape.character.in.string.literal", new Object[0]);
                        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message14).create();
                    }
                }
            } else {
                if (value2 == null) {
                    if (!text2.endsWith("\"\"\"")) {
                        String message15 = JavaErrorBundle.message("text.block.unclosed", new Object[0]);
                        int p = expression2.getTextRange().getEndOffset();
                        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(p, p).endOfLine().descriptionAndTooltip(message15).create();
                    }
                    StringBuilder chars2 = new StringBuilder();
                    int[] offsets = new int[text2.length() + 1];
                    boolean success2 = CodeInsightUtilCore.parseStringCharacters((String)text2, (StringBuilder)chars2, (int[])offsets);
                    if (!success2) {
                        String message16 = JavaErrorBundle.message("illegal.escape.character.in.string.literal", new Object[0]);
                        TextRange textRange = chars2.length() < text2.length() - 1 ? new TextRange(offsets[chars2.length()], offsets[chars2.length() + 1]) : expression2.getTextRange();
                        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2, textRange).descriptionAndTooltip(message16).create();
                    }
                    String message17 = JavaErrorBundle.message("text.block.new.line", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message17).create();
                }
                if (file != null && HighlightUtil.containsUnescaped(text2, "\\\n") && (info = HighlightUtil.checkFeature((PsiElement)expression2, HighlightingFeature.TEXT_BLOCK_ESCAPES, level, file)) != null) {
                    return info;
                }
            }
            if (file != null && HighlightUtil.containsUnescaped(text2, "\\s") && (info = HighlightUtil.checkFeature((PsiElement)expression2, HighlightingFeature.TEXT_BLOCK_ESCAPES, level, file)) != null) {
                return info;
            }
        }
        if (value2 instanceof Float) {
            number = (Float)value2;
            if (((Float)number).isInfinite()) {
                String message18 = JavaErrorBundle.message("floating.point.number.too.large", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message18).create();
            }
            if (((Float)number).floatValue() == 0.0f && !TypeConversionUtil.isFPZero((String)text2)) {
                String message19 = JavaErrorBundle.message("floating.point.number.too.small", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message19).create();
            }
        } else if (value2 instanceof Double) {
            number = (Double)value2;
            if (((Double)number).isInfinite()) {
                String message20 = JavaErrorBundle.message("floating.point.number.too.large", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message20).create();
            }
            if ((Double)number == 0.0 && !TypeConversionUtil.isFPZero((String)text2)) {
                String message21 = JavaErrorBundle.message("floating.point.number.too.small", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message21).create();
            }
        }
        return null;
    }

    private static boolean containsUnescaped(@NotNull String text2, @NotNull String subText) {
        int start = 0;
        while ((start = StringUtil.indexOf((CharSequence)text2, (CharSequence)subText, (int)start)) != -1) {
            int nSlashes = 0;
            for (int pos = start - 1; pos >= 0 && text2.charAt(pos) == '\\'; --pos) {
                ++nSlashes;
            }
            if (nSlashes % 2 == 0) {
                return true;
            }
            start += subText.length();
        }
        return false;
    }

    private static HighlightInfo checkUnderscores(@NotNull PsiElement expression2, @NotNull String text2, boolean isInt) {
        String[] parts = ArrayUtilRt.EMPTY_STRING_ARRAY;
        if (isInt) {
            int start = 0;
            if (text2.startsWith("0x") || text2.startsWith("0b")) {
                start += 2;
            }
            int end = text2.length();
            if (StringUtil.endsWithChar((CharSequence)text2, (char)'l')) {
                --end;
            }
            parts = new String[]{text2.substring(start, end)};
        } else {
            Matcher matcher = FP_LITERAL_PARTS.matcher(text2);
            if (matcher.matches()) {
                parts = new String[matcher.groupCount()];
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    parts[i] = matcher.group(i + 1);
                }
            }
        }
        for (String part : parts) {
            if (part == null || !StringUtil.startsWithChar((CharSequence)part, (char)'_') && !StringUtil.endsWithChar((CharSequence)part, (char)'_')) continue;
            String message2 = JavaErrorBundle.message("illegal.underscore", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkMustBeBoolean(@NotNull PsiExpression expr2, @Nullable PsiType type2) {
        PsiElement parent = expr2.getParent();
        if (parent instanceof PsiIfStatement || parent instanceof PsiConditionalLoopStatement && expr2.equals(((PsiConditionalLoopStatement)parent).getCondition())) {
            if (expr2.getNextSibling() instanceof PsiErrorElement) {
                return null;
            }
            if (!TypeConversionUtil.isBooleanType((PsiType)type2)) {
                return HighlightUtil.createMustBeBooleanInfo(expr2, type2);
            }
        }
        return null;
    }

    private static HighlightInfo createMustBeBooleanInfo(@NotNull PsiExpression expr2, @Nullable PsiType type2) {
        HighlightInfo info = HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)PsiType.BOOLEAN, type2, expr2.getTextRange(), 0);
        if (expr2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expr2;
            PsiMethod method = methodCall.resolveMethod();
            if (method != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createMethodReturnFix(method, (PsiType)PsiType.BOOLEAN, true));
            }
        } else if (expr2 instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)expr2).getOperationTokenType() == JavaTokenType.EQ) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createAssignmentToComparisonFix((PsiAssignmentExpression)expr2));
        }
        return info;
    }

    @NotNull
    static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiTryStatement statement) {
        PsiResourceList resources;
        HashSet<PsiClassType> thrownTypes = new HashSet<PsiClassType>();
        PsiCodeBlock tryBlock = statement.getTryBlock();
        if (tryBlock != null) {
            thrownTypes.addAll(ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock));
        }
        if ((resources = statement.getResourceList()) != null) {
            thrownTypes.addAll(ExceptionUtil.collectUnhandledExceptions((PsiElement)resources, (PsiElement)resources));
        }
        return thrownTypes;
    }

    @NotNull
    static List<HighlightInfo> checkExceptionThrownInTry(@NotNull PsiParameter parameter2, @NotNull Set<? extends PsiClassType> thrownTypes) {
        PsiElement declarationScope = parameter2.getDeclarationScope();
        if (!(declarationScope instanceof PsiCatchSection)) {
            return Collections.emptyList();
        }
        PsiType caughtType = parameter2.getType();
        if (caughtType instanceof PsiClassType) {
            HighlightInfo info = HighlightUtil.checkSimpleCatchParameter(parameter2, thrownTypes, (PsiClassType)caughtType);
            return info == null ? Collections.emptyList() : Collections.singletonList(info);
        }
        if (caughtType instanceof PsiDisjunctionType) {
            return HighlightUtil.checkMultiCatchParameter(parameter2, thrownTypes);
        }
        return Collections.emptyList();
    }

    private static HighlightInfo checkSimpleCatchParameter(@NotNull PsiParameter parameter2, @NotNull Collection<? extends PsiClassType> thrownTypes, @NotNull PsiClassType caughtType) {
        if (ExceptionUtil.isUncheckedExceptionOrSuperclass(caughtType)) {
            return null;
        }
        for (PsiClassType psiClassType : thrownTypes) {
            if (!psiClassType.isAssignableFrom((PsiType)caughtType) && !caughtType.isAssignableFrom((PsiType)psiClassType)) continue;
            return null;
        }
        String description = JavaErrorBundle.message("exception.never.thrown.try", JavaHighlightUtil.formatType((PsiType)caughtType));
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)parameter2).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createDeleteCatchFix(parameter2));
        return highlightInfo;
    }

    @NotNull
    private static List<HighlightInfo> checkMultiCatchParameter(@NotNull PsiParameter parameter2, @NotNull Collection<? extends PsiClassType> thrownTypes) {
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter2);
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>(typeElements.size());
        for (PsiTypeElement typeElement : typeElements) {
            PsiType catchType = typeElement.getType();
            if (catchType instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)catchType)) continue;
            boolean used = false;
            for (PsiClassType psiClassType : thrownTypes) {
                if (!psiClassType.isAssignableFrom(catchType) && !catchType.isAssignableFrom((PsiType)psiClassType)) continue;
                used = true;
                break;
            }
            if (used) continue;
            String description = JavaErrorBundle.message("exception.never.thrown.try", JavaHighlightUtil.formatType(catchType));
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createDeleteMultiCatchFix(typeElement));
            highlights.add(highlightInfo);
        }
        return highlights;
    }

    @NotNull
    static Collection<HighlightInfo> checkWithImprovedCatchAnalysis(@NotNull PsiParameter parameter2, @NotNull Collection<? extends PsiClassType> thrownInTryStatement, @NotNull PsiFile containingFile) {
        PsiElement scope = parameter2.getDeclarationScope();
        if (!(scope instanceof PsiCatchSection)) {
            return Collections.emptyList();
        }
        PsiCatchSection catchSection = (PsiCatchSection)scope;
        Object[] allCatchSections = catchSection.getTryStatement().getCatchSections();
        int idx = ArrayUtilRt.find((Object[])allCatchSections, (Object)catchSection);
        if (idx <= 0) {
            return Collections.emptyList();
        }
        HashSet<? extends PsiClassType> thrownTypes = new HashSet<PsiClassType>(thrownInTryStatement);
        PsiManager manager = containingFile.getManager();
        GlobalSearchScope parameterResolveScope = parameter2.getResolveScope();
        thrownTypes.add((PsiClassType)PsiType.getJavaLangError((PsiManager)manager, (GlobalSearchScope)parameterResolveScope));
        thrownTypes.add((PsiClassType)PsiType.getJavaLangRuntimeException((PsiManager)manager, (GlobalSearchScope)parameterResolveScope));
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        List parameterTypeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter2);
        boolean isMultiCatch = parameterTypeElements.size() > 1;
        for (PsiTypeElement catchTypeElement : parameterTypeElements) {
            List caught;
            PsiType catchType = catchTypeElement.getType();
            if (ExceptionUtil.isGeneralExceptionType(catchType) || (caught = ContainerUtil.findAll(thrownTypes, type2 -> catchType.isAssignableFrom((PsiType)type2) || type2.isAssignableFrom(catchType))).isEmpty()) continue;
            HashSet caughtCopy = new HashSet(caught);
            block1: for (int i = 0; i < idx; ++i) {
                PsiParameter prevCatchParameter = allCatchSections[i].getParameter();
                if (prevCatchParameter == null) continue;
                for (PsiTypeElement prevCatchTypeElement : PsiUtil.getParameterTypeElements((PsiParameter)prevCatchParameter)) {
                    PsiType prevCatchType = prevCatchTypeElement.getType();
                    caught.removeIf(arg_0 -> ((PsiType)prevCatchType).isAssignableFrom(arg_0));
                    if (!caught.isEmpty()) continue;
                    continue block1;
                }
            }
            if (!caught.isEmpty()) continue;
            String message2 = JavaErrorBundle.message("exception.already.caught.warn", HighlightUtil.formatTypes(caughtCopy), caughtCopy.size());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range((PsiElement)catchSection).descriptionAndTooltip(message2).create();
            if (isMultiCatch) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createDeleteMultiCatchFix(catchTypeElement));
            } else {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createDeleteCatchFix(parameter2));
            }
            result.add(highlightInfo);
        }
        return result;
    }

    static HighlightInfo checkNotAStatement(@NotNull PsiStatement statement) {
        if (!PsiUtil.isStatement((PsiElement)statement) && !PsiUtilCore.hasErrorElementChild((PsiElement)statement)) {
            boolean isDeclarationNotAllowed = false;
            if (statement instanceof PsiDeclarationStatement) {
                PsiElement parent = statement.getParent();
                isDeclarationNotAllowed = parent instanceof PsiIfStatement || parent instanceof PsiLoopStatement;
            }
            String description = JavaErrorBundle.message(isDeclarationNotAllowed ? "declaration.not.allowed" : "not.a.statement", new Object[0]);
            HighlightInfo error = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
            if (statement instanceof PsiExpressionStatement) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)error, (IntentionAction)HighlightUtil.getFixFactory().createDeleteSideEffectAwareFix((PsiExpressionStatement)statement));
            }
            return error;
        }
        return null;
    }

    static HighlightInfo checkSwitchSelectorType(@NotNull PsiSwitchBlock switchBlock, @NotNull LanguageLevel level) {
        PsiExpression expression2 = switchBlock.getExpression();
        if (expression2 == null) {
            return null;
        }
        PsiType type2 = expression2.getType();
        if (type2 == null) {
            return null;
        }
        SelectorKind kind2 = HighlightUtil.getSwitchSelectorKind(type2);
        if (kind2 == SelectorKind.INT) {
            return null;
        }
        LanguageLevel requiredLevel = null;
        if (kind2 == SelectorKind.ENUM) {
            requiredLevel = LanguageLevel.JDK_1_5;
        }
        if (kind2 == SelectorKind.STRING) {
            requiredLevel = LanguageLevel.JDK_1_7;
        }
        if (kind2 == null || requiredLevel != null && !level.isAtLeast(requiredLevel)) {
            boolean is7 = level.isAtLeast(LanguageLevel.JDK_1_7);
            String expected = JavaErrorBundle.message(is7 ? "valid.switch.17.selector.types" : "valid.switch.selector.types", new Object[0]);
            String message2 = JavaErrorBundle.message("incompatible.types", expected, JavaHighlightUtil.formatType(type2));
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message2).create();
            if (switchBlock instanceof PsiSwitchStatement) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createConvertSwitchToIfIntention((PsiSwitchStatement)switchBlock));
            }
            if (PsiType.LONG.equals((Object)type2) || PsiType.FLOAT.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createAddTypeCastFix((PsiType)PsiType.INT, expression2));
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createWrapWithAdapterFix((PsiType)PsiType.INT, expression2));
            }
            if (requiredLevel != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createIncreaseLanguageLevelFix(requiredLevel));
            }
            return info;
        }
        PsiClass member = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        if (member != null && !PsiUtil.isAccessible((Project)member.getProject(), (PsiMember)member, (PsiElement)expression2, null)) {
            String className2 = PsiFormatUtil.formatClass((PsiClass)member, (int)2049);
            String message3 = JavaErrorBundle.message("inaccessible.type", className2);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message3).create();
        }
        return null;
    }

    @NotNull
    static Collection<HighlightInfo> checkSwitchExpressionReturnTypeCompatible(@NotNull PsiSwitchExpression switchExpression) {
        if (!PsiPolyExpressionUtil.isPolyExpression((PsiExpression)switchExpression)) {
            return Collections.emptyList();
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        PsiType switchExpressionType = switchExpression.getType();
        if (switchExpressionType != null) {
            for (PsiExpression expression2 : PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)switchExpression)) {
                PsiType expressionType = (PsiType)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)expression2, true, () -> ((PsiExpression)expression2).getType());
                if (expressionType == null || switchExpressionType.isAssignableFrom(expressionType)) continue;
                String text2 = JavaErrorBundle.message("bad.type.in.switch.expression", expressionType.getCanonicalText(), switchExpressionType.getCanonicalText());
                infos.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(text2).create());
            }
            if (PsiType.VOID.equals((Object)switchExpressionType)) {
                String text3 = JavaErrorBundle.message("switch.expression.cannot.be.void", new Object[0]);
                infos.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(switchExpression.getFirstChild()).descriptionAndTooltip(text3).create());
            }
        }
        return infos;
    }

    static HighlightInfo checkRecordComponentName(@NotNull PsiRecordComponent component) {
        String name2;
        PsiIdentifier identifier = component.getNameIdentifier();
        if (identifier != null && RESTRICTED_RECORD_COMPONENT_NAMES.contains(name2 = identifier.getText())) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(JavaErrorBundle.message("record.component.restricted.name", name2)).create();
        }
        return null;
    }

    static HighlightInfo checkRecordComponentVarArg(@NotNull PsiRecordComponent recordComponent) {
        if (recordComponent.isVarArgs() && PsiTreeUtil.getNextSiblingOfType((PsiElement)recordComponent, PsiRecordComponent.class) != null) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)recordComponent).descriptionAndTooltip(JavaErrorBundle.message("record.component.vararg.not.last", new Object[0])).create();
        }
        return null;
    }

    private static SelectorKind getSwitchSelectorKind(@NotNull PsiType type2) {
        if (TypeConversionUtil.getTypeRank((PsiType)type2) <= 4) {
            return SelectorKind.INT;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        if (psiClass != null) {
            if (psiClass.isEnum()) {
                return SelectorKind.ENUM;
            }
            if (Comparing.strEqual((String)psiClass.getQualifiedName(), (String)"java.lang.String")) {
                return SelectorKind.STRING;
            }
        }
        return null;
    }

    static HighlightInfo checkPolyadicOperatorApplicable(@NotNull PsiPolyadicExpression expression2) {
        PsiExpression[] operands2 = expression2.getOperands();
        PsiType lType = operands2[0].getType();
        IElementType operationSign = expression2.getOperationTokenType();
        for (int i = 1; i < operands2.length; ++i) {
            PsiExpression operand2 = operands2[i];
            PsiType rType = operand2.getType();
            if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)operationSign, (PsiType)lType, (PsiType)rType, (boolean)false)) {
                PsiJavaToken token = expression2.getTokenBeforeOperand(operand2);
                assert (token != null) : expression2;
                String message2 = JavaErrorBundle.message("binary.operator.not.applicable", token.getText(), JavaHighlightUtil.formatType(lType), JavaHighlightUtil.formatType(rType));
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message2).create();
            }
            lType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)operationSign, (boolean)true);
        }
        return null;
    }

    static HighlightInfo checkUnaryOperatorApplicable(@NotNull PsiJavaToken token, @Nullable PsiExpression expression2) {
        if (expression2 != null && !TypeConversionUtil.isUnaryOperatorApplicable((PsiJavaToken)token, (PsiExpression)expression2)) {
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return null;
            }
            String message2 = JavaErrorBundle.message("unary.operator.not.applicable", token.getText(), JavaHighlightUtil.formatType(type2));
            PsiElement parentExpr = token.getParent();
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(parentExpr).descriptionAndTooltip(message2).create();
            if (parentExpr instanceof PsiPrefixExpression && token.getTokenType() == JavaTokenType.EXCL) {
                PsiMethod method;
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createNegationBroadScopeFix((PsiPrefixExpression)parentExpr));
                if (expression2 instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)expression2).resolveMethod()) != null) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createMethodReturnFix(method, (PsiType)PsiType.BOOLEAN, true));
                }
            }
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkThisOrSuperExpressionInIllegalContext(@NotNull PsiExpression expr2, @Nullable PsiJavaCodeReferenceElement qualifier, @NotNull LanguageLevel languageLevel) {
        PsiClass classT;
        PsiClass aClass;
        PsiElement resolved;
        PsiElement parent;
        if (expr2 instanceof PsiSuperExpression && !((parent = expr2.getParent()) instanceof PsiReferenceExpression)) {
            int o = expr2.getTextRange().getEndOffset();
            String description = JavaErrorBundle.message("dot.expected.after.super.or.this", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(o, o + 1).descriptionAndTooltip(description).create();
        }
        if (qualifier != null) {
            resolved = qualifier.advancedResolve(true).getElement();
            if (resolved != null && !(resolved instanceof PsiClass)) {
                String description = JavaErrorBundle.message("class.expected", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(description).create();
            }
            aClass = (PsiClass)resolved;
        } else {
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr2, PsiClass.class);
            if (aClass instanceof PsiAnonymousClass && PsiTreeUtil.isAncestor((PsiElement)((PsiAnonymousClass)aClass).getArgumentList(), (PsiElement)expr2, (boolean)false)) {
                aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
            }
        }
        if (aClass == null) {
            return null;
        }
        if (!InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)aClass, (PsiElement)expr2, (boolean)false, (boolean)false)) {
            if (!HighlightUtil.resolvesToImmediateSuperInterface(expr2, qualifier, aClass, languageLevel)) {
                return HighlightClassUtil.reportIllegalEnclosingUsage((PsiElement)expr2, null, aClass, (PsiElement)expr2);
            }
            if (expr2 instanceof PsiSuperExpression && (resolved = ((PsiReferenceExpression)expr2.getParent()).resolve()) instanceof PsiField) {
                String description = JavaErrorBundle.message("is.not.an.enclosing.class", HighlightUtil.formatClass(aClass));
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expr2).descriptionAndTooltip(description).create();
            }
        }
        if (qualifier != null && aClass.isInterface() && expr2 instanceof PsiSuperExpression && languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (classT = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr2, PsiClass.class)) != null) {
            PsiElement parent2 = expr2.getParent();
            PsiElement resolved2 = parent2 instanceof PsiReferenceExpression ? ((PsiReferenceExpression)parent2).resolve() : null;
            PsiClass containingClass = (PsiClass)ObjectUtils.notNull((Object)(resolved2 instanceof PsiMethod ? ((PsiMethod)resolved2).getContainingClass() : null), (Object)aClass);
            for (PsiClass superClass : classT.getSupers()) {
                if (!superClass.isInheritor(containingClass, true)) continue;
                String cause = null;
                if (superClass.isInheritor(aClass, true) && superClass.isInterface()) {
                    cause = "redundant interface " + HighlightUtil.format((PsiElement)containingClass) + " is extended by ";
                } else if (resolved2 instanceof PsiMethod && MethodSignatureUtil.findMethodBySuperMethod((PsiClass)superClass, (PsiMethod)((PsiMethod)resolved2), (boolean)true) != resolved2) {
                    cause = "method " + ((PsiMethod)resolved2).getName() + " is overridden in ";
                }
                if (cause == null) continue;
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(JavaErrorBundle.message("bad.qualifier.in.super.method.reference", cause + HighlightUtil.formatClass(superClass))).create();
            }
            if (!classT.isInheritor(aClass, false)) {
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(JavaErrorBundle.message("no.enclosing.instance.in.scope", HighlightUtil.format((PsiElement)aClass))).create();
            }
        }
        return null;
    }

    static HighlightInfo checkUnqualifiedSuperInDefaultMethod(@NotNull LanguageLevel languageLevel, @NotNull PsiReferenceExpression expr2, @Nullable PsiExpression qualifier) {
        PsiMethod method;
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && qualifier instanceof PsiSuperExpression && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expr2, PsiMethod.class)) != null && method.hasModifierProperty("default") && ((PsiSuperExpression)qualifier).getQualifier() == null) {
            String description = JavaErrorBundle.message("unqualified.super.disallowed", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expr2).descriptionAndTooltip(description).create();
            QualifySuperArgumentFix.registerQuickFixAction((PsiSuperExpression)qualifier, info);
            return info;
        }
        return null;
    }

    private static boolean resolvesToImmediateSuperInterface(@NotNull PsiExpression expr2, @Nullable PsiJavaCodeReferenceElement qualifier, @NotNull PsiClass aClass, @NotNull LanguageLevel languageLevel) {
        if (!(expr2 instanceof PsiSuperExpression) || qualifier == null || !languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return false;
        }
        PsiType superType = expr2.getType();
        if (!(superType instanceof PsiClassType)) {
            return false;
        }
        PsiClass superClass = ((PsiClassType)superType).resolve();
        return aClass.equals(superClass) && PsiUtil.getEnclosingStaticElement((PsiElement)expr2, (PsiClass)((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr2, PsiClass.class))) == null;
    }

    @NotNull
    static String staticContextProblemDescription(@NotNull PsiElement refElement) {
        String type2 = LanguageFindUsages.getType((PsiElement)refElement);
        String name2 = HighlightMessageUtil.getSymbolName(refElement, PsiSubstitutor.EMPTY);
        return JavaErrorBundle.message("non.static.symbol.referenced.from.static.context", type2, name2);
    }

    @NotNull
    static String accessProblemDescription(@NotNull PsiElement ref, @NotNull PsiElement resolved, @NotNull JavaResolveResult result) {
        return (String)HighlightUtil.accessProblemDescriptionAndFixes((PsiElement)ref, (PsiElement)resolved, (JavaResolveResult)result).first;
    }

    @NotNull
    static Pair<String, List<IntentionAction>> accessProblemDescriptionAndFixes(@NotNull PsiElement ref, @NotNull PsiElement resolved, @NotNull JavaResolveResult result) {
        assert (resolved instanceof PsiModifierListOwner) : resolved;
        PsiModifierListOwner refElement = (PsiModifierListOwner)resolved;
        String symbolName = HighlightMessageUtil.getSymbolName((PsiElement)refElement, result.getSubstitutor());
        if (refElement.hasModifierProperty("private")) {
            String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
            return Pair.pair((Object)JavaErrorBundle.message("private.symbol", symbolName, containerName), null);
        }
        if (refElement.hasModifierProperty("protected")) {
            String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
            return Pair.pair((Object)JavaErrorBundle.message("protected.symbol", symbolName, containerName), null);
        }
        PsiClass packageLocalClass = HighlightFixUtil.getPackageLocalClassInTheMiddle(ref);
        if (packageLocalClass != null) {
            refElement = packageLocalClass;
            symbolName = HighlightMessageUtil.getSymbolName((PsiElement)refElement, result.getSubstitutor());
        }
        if (refElement.hasModifierProperty("packageLocal") || packageLocalClass != null) {
            String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
            return Pair.pair((Object)JavaErrorBundle.message("package.local.symbol", symbolName, containerName), null);
        }
        String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
        JavaModuleSystemEx.ErrorWithFixes problem = HighlightUtil.checkModuleAccess(resolved, ref, symbolName, containerName);
        if (problem != null) {
            return Pair.pair((Object)problem.message, (Object)problem.fixes);
        }
        return Pair.pair((Object)JavaErrorBundle.message("visibility.access.problem", symbolName, containerName), null);
    }

    private static JavaModuleSystemEx.ErrorWithFixes checkModuleAccess(@NotNull PsiElement target, @NotNull PsiElement place, @Nullable String symbolName, @Nullable String containerName) {
        JavaModuleSystemEx.ErrorWithFixes error = null;
        for (JavaModuleSystem moduleSystem : (JavaModuleSystem[])JavaModuleSystem.EP_NAME.getExtensions()) {
            if (moduleSystem instanceof JavaModuleSystemEx) {
                error = HighlightUtil.checkAccess((JavaModuleSystemEx)moduleSystem, target, place);
            } else if (!HighlightUtil.isAccessible(moduleSystem, target, place)) {
                String message2 = JavaErrorBundle.message("visibility.module.access.problem", symbolName, containerName, moduleSystem.getName());
                error = new JavaModuleSystemEx.ErrorWithFixes(message2);
            }
            if (error == null) continue;
            return error;
        }
        return null;
    }

    private static JavaModuleSystemEx.ErrorWithFixes checkAccess(@NotNull JavaModuleSystemEx system, @NotNull PsiElement target, @NotNull PsiElement place) {
        if (target instanceof PsiClass) {
            return system.checkAccess((PsiClass)target, place);
        }
        if (target instanceof PsiPackage) {
            return system.checkAccess(((PsiPackage)target).getQualifiedName(), null, place);
        }
        return null;
    }

    private static boolean isAccessible(@NotNull JavaModuleSystem system, @NotNull PsiElement target, @NotNull PsiElement place) {
        if (target instanceof PsiClass) {
            return system.isAccessible((PsiClass)target, place);
        }
        if (target instanceof PsiPackage) {
            return system.isAccessible(((PsiPackage)target).getQualifiedName(), null, place);
        }
        return true;
    }

    private static PsiElement getContainer(@NotNull PsiModifierListOwner refElement) {
        for (ContainerProvider provider : (ContainerProvider[])ContainerProvider.EP_NAME.getExtensions()) {
            PsiElement container = provider.getContainer((PsiElement)refElement);
            if (container == null) continue;
            return container;
        }
        return refElement.getParent();
    }

    private static String getContainerName(@NotNull PsiModifierListOwner refElement, @NotNull PsiSubstitutor substitutor) {
        PsiElement container = HighlightUtil.getContainer(refElement);
        return container == null ? "?" : HighlightMessageUtil.getSymbolName(container, substitutor);
    }

    static HighlightInfo checkValidArrayAccessExpression(@NotNull PsiArrayAccessExpression arrayAccessExpression) {
        PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        PsiType arrayExpressionType = arrayExpression.getType();
        if (arrayExpressionType != null && !(arrayExpressionType instanceof PsiArrayType)) {
            String description = JavaErrorBundle.message("array.type.expected", JavaHighlightUtil.formatType(arrayExpressionType));
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)arrayExpression).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createReplaceWithListAccessFix(arrayAccessExpression));
            return info;
        }
        PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
        return indexExpression != null ? HighlightUtil.checkAssignability((PsiType)PsiType.INT, indexExpression.getType(), indexExpression, (PsiElement)indexExpression) : null;
    }

    static HighlightInfo checkCatchParameterIsThrowable(@NotNull PsiParameter parameter2) {
        if (parameter2.getDeclarationScope() instanceof PsiCatchSection) {
            PsiType type2 = parameter2.getType();
            return HighlightUtil.checkMustBeThrowable(type2, (PsiElement)parameter2, true);
        }
        return null;
    }

    static HighlightInfo checkTryResourceIsAutoCloseable(@NotNull PsiResourceListElement resource) {
        PsiType type2 = resource.getType();
        if (type2 == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)resource.getProject());
        PsiClassType autoCloseable = factory.createTypeByFQClassName("java.lang.AutoCloseable", resource.getResolveScope());
        if (TypeConversionUtil.isAssignable((PsiType)autoCloseable, (PsiType)type2)) {
            return null;
        }
        return HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)autoCloseable, type2, resource.getTextRange(), 0);
    }

    static HighlightInfo checkResourceVariableIsFinal(@NotNull PsiResourceExpression resource) {
        PsiExpression expression2 = resource.getExpression();
        if (expression2 instanceof PsiThisExpression) {
            return null;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiElement target = ((PsiReferenceExpression)expression2).resolve();
            if (target == null) {
                return null;
            }
            if (target instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)target;
                PsiModifierList modifierList = variable.getModifierList();
                if (modifierList != null && modifierList.hasModifierProperty("final")) {
                    return null;
                }
                if (!(variable instanceof PsiField) && HighlightControlFlowUtil.isEffectivelyFinal(variable, (PsiElement)resource, (PsiJavaCodeReferenceElement)expression2)) {
                    return null;
                }
            }
            String text2 = JavaErrorBundle.message("resource.variable.must.be.final", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(text2).create();
        }
        String text3 = JavaErrorBundle.message("declaration.or.variable.expected", new Object[0]);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(text3).create();
    }

    @NotNull
    static Collection<HighlightInfo> checkArrayInitializer(@NotNull PsiExpression initializer, @Nullable PsiType type2) {
        if (!(initializer instanceof PsiArrayInitializerExpression)) {
            return Collections.emptyList();
        }
        if (!(type2 instanceof PsiArrayType)) {
            return Collections.emptyList();
        }
        PsiType componentType = ((PsiArrayType)type2).getComponentType();
        PsiArrayInitializerExpression arrayInitializer = (PsiArrayInitializerExpression)initializer;
        boolean arrayTypeFixChecked = false;
        VariableArrayTypeFix fix = null;
        PsiExpression[] initializers = arrayInitializer.getInitializers();
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(initializers.length);
        for (PsiExpression expression2 : initializers) {
            HighlightInfo info = HighlightUtil.checkArrayInitializerCompatibleTypes(expression2, componentType);
            if (info == null) continue;
            result.add(info);
            if (!arrayTypeFixChecked) {
                PsiType checkResult = JavaHighlightUtil.sameType(initializers);
                fix = checkResult != null ? VariableArrayTypeFix.createFix(arrayInitializer, checkResult) : null;
                arrayTypeFixChecked = true;
            }
            if (fix == null) continue;
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter(fix));
        }
        return result;
    }

    private static HighlightInfo checkArrayInitializerCompatibleTypes(@NotNull PsiExpression initializer, @NotNull PsiType componentType) {
        PsiType initializerType = initializer.getType();
        if (initializerType == null) {
            String description = JavaErrorBundle.message("illegal.initializer", JavaHighlightUtil.formatType(componentType));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)initializer).descriptionAndTooltip(description).create();
        }
        PsiExpression expression2 = initializer instanceof PsiArrayInitializerExpression ? null : initializer;
        return HighlightUtil.checkAssignability(componentType, initializerType, expression2, (PsiElement)initializer);
    }

    static HighlightInfo checkExpressionRequired(@NotNull PsiReferenceExpression expression2, @NotNull JavaResolveResult resultForIncompleteCode) {
        if (expression2.getNextSibling() instanceof PsiErrorElement) {
            return null;
        }
        PsiElement resolved = resultForIncompleteCode.getElement();
        if (resolved == null || resolved instanceof PsiVariable) {
            return null;
        }
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiReferenceExpression || parent instanceof PsiMethodCallExpression || parent instanceof PsiBreakStatement) {
            return null;
        }
        String description = JavaErrorBundle.message("expression.expected", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
        UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)expression2, (QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info));
        return info;
    }

    static HighlightInfo checkArrayInitializerApplicable(@NotNull PsiArrayInitializerExpression expression2) {
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiVariable) {
            boolean isInferredType;
            PsiVariable variable = (PsiVariable)parent;
            PsiTypeElement typeElement = variable.getTypeElement();
            boolean bl = isInferredType = typeElement != null && typeElement.isInferredType();
            if (!isInferredType && variable.getType() instanceof PsiArrayType) {
                return null;
            }
        } else if (parent instanceof PsiNewExpression || parent instanceof PsiArrayInitializerExpression) {
            return null;
        }
        String description = JavaErrorBundle.message("array.initializer.not.allowed", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createAddNewArrayExpressionFix(expression2));
        return info;
    }

    static HighlightInfo checkCaseStatement(@NotNull PsiSwitchLabelStatementBase statement) {
        PsiSwitchBlock switchBlock = statement.getEnclosingSwitchBlock();
        if (switchBlock == null) {
            String description = JavaErrorBundle.message("case.statement.outside.switch", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @NotNull
    static Collection<HighlightInfo> checkSwitchLabelValues(@NotNull PsiSwitchBlock switchBlock) {
        PsiCodeBlock body2 = switchBlock.getBody();
        if (body2 == null) {
            return Collections.emptyList();
        }
        PsiExpression selectorExpression = switchBlock.getExpression();
        PsiPrimitiveType selectorType = selectorExpression == null ? PsiType.INT : selectorExpression.getType();
        MultiMap values = new MultiMap();
        Object defaultValue = new Object();
        ArrayList<HighlightInfo> results = new ArrayList<HighlightInfo>();
        boolean hasDefaultCase = false;
        for (PsiStatement st : body2.getStatements()) {
            if (!(st instanceof PsiSwitchLabelStatementBase)) continue;
            PsiSwitchLabelStatementBase labelStatement = (PsiSwitchLabelStatementBase)st;
            boolean defaultCase = labelStatement.isDefaultCase();
            if (defaultCase) {
                values.putValue(defaultValue, ObjectUtils.notNull((Object)labelStatement.getFirstChild(), (Object)labelStatement));
                hasDefaultCase = true;
                continue;
            }
            PsiExpressionList expressionList = labelStatement.getCaseValues();
            if (expressionList == null) continue;
            for (PsiExpression expr2 : expressionList.getExpressions()) {
                PsiElement element;
                HighlightInfo result;
                if (selectorExpression != null && (result = HighlightUtil.checkAssignability((PsiType)selectorType, expr2.getType(), expr2, (PsiElement)expr2)) != null) {
                    results.add(result);
                    continue;
                }
                Object value2 = null;
                if (expr2 instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)expr2).resolve()) instanceof PsiEnumConstant) {
                    value2 = ((PsiEnumConstant)element).getName();
                    if (((PsiReferenceExpression)expr2).getQualifier() != null) {
                        String message2 = JavaErrorBundle.message("qualified.enum.constant.in.switch", new Object[0]);
                        results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expr2).descriptionAndTooltip(message2).create());
                        continue;
                    }
                }
                if (value2 == null) {
                    value2 = ConstantExpressionUtil.computeCastTo((PsiExpression)expr2, (PsiType)selectorType);
                }
                if (value2 == null) {
                    String description = JavaErrorBundle.message("constant.expression.required", new Object[0]);
                    results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expr2).descriptionAndTooltip(description).create());
                    continue;
                }
                values.putValue(value2, (Object)expr2);
            }
        }
        for (Map.Entry entry : values.entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            Object value3 = entry.getKey();
            PsiField[] description = value3 == defaultValue ? JavaErrorBundle.message("duplicate.default.switch.label", new Object[0]) : JavaErrorBundle.message("duplicate.switch.label", value3);
            for (PsiElement element : (Collection)entry.getValue()) {
                results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip((String)description).create());
            }
        }
        if (results.isEmpty() && switchBlock instanceof PsiSwitchExpression) {
            PsiClass type2;
            HashSet<String> missingConstants = new HashSet<String>();
            boolean exhaustive = hasDefaultCase;
            if (!exhaustive && !values.isEmpty() && selectorType instanceof PsiClassType && (type2 = ((PsiClassType)selectorType).resolve()) != null && type2.isEnum()) {
                for (PsiField field : type2.getFields()) {
                    if (!(field instanceof PsiEnumConstant) || values.containsKey((Object)field.getName())) continue;
                    missingConstants.add(field.getName());
                }
                exhaustive = missingConstants.isEmpty();
            }
            if (!exhaustive) {
                PsiElement range = (PsiElement)ObjectUtils.notNull((Object)selectorExpression, (Object)switchBlock);
                String message3 = JavaErrorBundle.message(values.isEmpty() ? "switch.expr.empty" : "switch.expr.incomplete", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message3).create();
                if (!missingConstants.isEmpty()) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createAddMissingEnumBranchesFix(switchBlock, missingConstants));
                }
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createAddSwitchDefaultFix(switchBlock, null));
                results.add(info);
            }
        }
        return results;
    }

    @NotNull
    static Collection<HighlightInfo> checkSwitchExpressionHasResult(@NotNull PsiSwitchExpression switchExpression) {
        PsiCodeBlock switchBody = switchExpression.getBody();
        if (switchBody != null) {
            PsiStatement lastStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)switchBody.getRBrace(), PsiStatement.class);
            boolean hasResult = false;
            if (lastStatement instanceof PsiSwitchLabeledRuleStatement) {
                ArrayList<HighlightInfo> results = new ArrayList<HighlightInfo>();
                PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)lastStatement;
                while (rule != null) {
                    PsiStatement ruleBody = rule.getBody();
                    if (ruleBody instanceof PsiExpressionStatement) {
                        hasResult = true;
                    }
                    if (ruleBody instanceof PsiBlockStatement) {
                        if (ControlFlowUtils.statementMayCompleteNormally(ruleBody)) {
                            PsiElement target = (PsiElement)ObjectUtils.notNull((Object)ObjectUtils.tryCast((Object)rule.getFirstChild(), PsiKeyword.class), (Object)rule);
                            String message2 = JavaErrorBundle.message("switch.expr.rule.should.produce.result", new Object[0]);
                            results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(target).descriptionAndTooltip(message2).create());
                        } else if (!hasResult && HighlightUtil.hasYield(switchExpression, (PsiElement)ruleBody)) {
                            hasResult = true;
                        }
                    }
                    rule = (PsiSwitchLabeledRuleStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)rule, PsiSwitchLabeledRuleStatement.class);
                }
                if (!results.isEmpty()) {
                    return results;
                }
            } else {
                if (lastStatement != null && ControlFlowUtils.statementMayCompleteNormally(lastStatement)) {
                    PsiElement target = (PsiElement)ObjectUtils.notNull((Object)ObjectUtils.tryCast((Object)switchExpression.getFirstChild(), PsiKeyword.class), (Object)switchExpression);
                    String message3 = JavaErrorBundle.message("switch.expr.should.produce.result", new Object[0]);
                    return Collections.singletonList(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(target).descriptionAndTooltip(message3).create());
                }
                hasResult = HighlightUtil.hasYield(switchExpression, (PsiElement)switchBody);
            }
            if (!hasResult) {
                PsiElement target = (PsiElement)ObjectUtils.notNull((Object)ObjectUtils.tryCast((Object)switchExpression.getFirstChild(), PsiKeyword.class), (Object)switchExpression);
                return Collections.singletonList(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(target).descriptionAndTooltip(JavaErrorBundle.message("switch.expr.no.result", new Object[0])).create());
            }
        }
        return Collections.emptyList();
    }

    private static boolean hasYield(@NotNull PsiSwitchExpression switchExpression, PsiElement scope) {
        class YieldFinder
        extends JavaRecursiveElementWalkingVisitor {
            boolean hasYield = false;
            final /* synthetic */ PsiSwitchExpression val$switchExpression;

            YieldFinder(PsiSwitchExpression psiSwitchExpression) {
                this.val$switchExpression = psiSwitchExpression;
            }

            public void visitYieldStatement(PsiYieldStatement statement) {
                if (statement.findEnclosingExpression() == this.val$switchExpression) {
                    this.hasYield = true;
                    this.stopWalking();
                }
            }

            public void visitDeclarationStatement(PsiDeclarationStatement statement) {
            }

            public void visitExpression(PsiExpression expression2) {
            }
        }
        YieldFinder finder = new YieldFinder(switchExpression);
        scope.accept((PsiElementVisitor)finder);
        return finder.hasYield;
    }

    static HighlightInfo checkIllegalForwardReferenceToField(@NotNull PsiReferenceExpression expression2, @NotNull PsiField referencedField) {
        Boolean isIllegalForwardReference = HighlightUtil.isIllegalForwardReferenceToField(expression2, referencedField, false);
        if (isIllegalForwardReference == null) {
            return null;
        }
        String description = JavaErrorBundle.message(isIllegalForwardReference != false ? "illegal.forward.reference" : "illegal.self.reference", new Object[0]);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
    }

    public static Boolean isIllegalForwardReferenceToField(@NotNull PsiReferenceExpression expression2, @NotNull PsiField referencedField, boolean acceptQualified) {
        boolean inStaticContext;
        PsiClass containingClass = referencedField.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        if (expression2.getContainingFile() != referencedField.getContainingFile()) {
            return null;
        }
        TextRange fieldRange = referencedField.getTextRange();
        if (fieldRange == null || expression2.getTextRange().getStartOffset() >= fieldRange.getEndOffset()) {
            return null;
        }
        if (!acceptQualified && expression2.getQualifierExpression() != null) {
            return null;
        }
        PsiField initField = HighlightUtil.findEnclosingFieldInitializer((PsiElement)expression2);
        PsiClassInitializer classInitializer = HighlightUtil.findParentClassInitializer((PsiElement)expression2);
        if (initField == null && classInitializer == null) {
            return null;
        }
        boolean isStaticClassInitializer = classInitializer != null && classInitializer.hasModifierProperty("static");
        boolean isStaticInitField = initField != null && initField.hasModifierProperty("static");
        boolean bl = inStaticContext = isStaticInitField || isStaticClassInitializer;
        if (!inStaticContext && referencedField.hasModifierProperty("static")) {
            return null;
        }
        if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression2) && !PsiUtil.isAccessedForReading((PsiExpression)expression2)) {
            return null;
        }
        if (!containingClass.getManager().areElementsEquivalent((PsiElement)containingClass, PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class))) {
            return null;
        }
        return initField != referencedField;
    }

    static PsiField findEnclosingFieldInitializer(@NotNull PsiElement entry) {
        PsiElement element = entry;
        while (element != null) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiField) {
                PsiField field = (PsiField)parent;
                if (element == field.getInitializer()) {
                    return field;
                }
                if (field instanceof PsiEnumConstant && element == ((PsiEnumConstant)field).getArgumentList()) {
                    return field;
                }
            }
            if (element instanceof PsiClass || element instanceof PsiMethod) {
                return null;
            }
            element = parent;
        }
        return null;
    }

    private static PsiClassInitializer findParentClassInitializer(@NotNull PsiElement root) {
        for (PsiElement element = root; element != null; element = element.getParent()) {
            if (element instanceof PsiClassInitializer) {
                return (PsiClassInitializer)element;
            }
            if (!(element instanceof PsiClass) && !(element instanceof PsiMethod)) continue;
            return null;
        }
        return null;
    }

    static HighlightInfo checkIllegalType(@NotNull PsiTypeElement typeElement) {
        PsiClass aClass;
        if (typeElement.getParent() instanceof PsiTypeElement) {
            return null;
        }
        if (PsiUtil.isInsideJavadocComment((PsiElement)typeElement)) {
            return null;
        }
        PsiType type2 = typeElement.getType();
        PsiType componentType = type2.getDeepComponentType();
        if (componentType instanceof PsiClassType && (aClass = PsiUtil.resolveClassInType((PsiType)componentType)) == null) {
            String canonicalText = type2.getCanonicalText();
            String description = JavaErrorBundle.message("unknown.class", canonicalText);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
            PsiJavaCodeReferenceElement referenceElement = typeElement.getInnermostComponentReferenceElement();
            if (referenceElement != null) {
                UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)referenceElement, (QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info));
            }
            return info;
        }
        return null;
    }

    static HighlightInfo checkIllegalVoidType(@NotNull PsiKeyword type2) {
        if (!"void".equals(type2.getText())) {
            return null;
        }
        PsiElement parent = type2.getParent();
        if (parent instanceof PsiTypeElement) {
            PsiMethod method;
            PsiElement typeOwner = parent.getParent();
            if (typeOwner != null && PsiUtilCore.hasErrorElementChild((PsiElement)typeOwner)) {
                return null;
            }
            if (typeOwner instanceof PsiMethod ? (method = (PsiMethod)typeOwner).getReturnTypeElement() == parent && PsiType.VOID.equals((Object)method.getReturnType()) : (typeOwner instanceof PsiClassObjectAccessExpression ? TypeConversionUtil.isVoidType((PsiType)((PsiClassObjectAccessExpression)typeOwner).getOperand().getType()) : typeOwner instanceof JavaCodeFragment && typeOwner.getUserData(PsiUtil.VALID_VOID_TYPE_IN_CODE_FRAGMENT) != null)) {
                return null;
            }
        }
        String description = JavaErrorBundle.message("illegal.type.void", new Object[0]);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)type2).descriptionAndTooltip(description).create();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static HighlightInfo checkMemberReferencedBeforeConstructorCalled(@NotNull PsiElement expression2, @Nullable PsiElement resolved, @NotNull PsiFile containingFile, @NotNull Function<? super PsiElement, ? extends PsiClass> insideConstructorOfClass) {
        String resolvedName;
        PsiClass referencedClass;
        PsiType type2;
        if (insideConstructorOfClass.apply((PsiElement)expression2) == null) {
            return null;
        }
        if (expression2 instanceof PsiJavaCodeReferenceElement) {
            if ("this".equals(((PsiJavaCodeReferenceElement)expression2).getReferenceName()) && resolved instanceof PsiMethod && ((PsiMethod)resolved).isConstructor()) {
                return null;
            }
            PsiElement qualifier = ((PsiJavaCodeReferenceElement)expression2).getQualifier();
            type2 = qualifier instanceof PsiExpression ? ((PsiExpression)qualifier).getType() : null;
            referencedClass = PsiUtil.resolveClassInType((PsiType)type2);
            boolean isSuperCall = JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)expression2.getParent());
            if (resolved == null && isSuperCall) {
                if (qualifier instanceof PsiReferenceExpression) {
                    resolved = ((PsiReferenceExpression)qualifier).resolve();
                    expression2 = qualifier;
                    type2 = ((PsiReferenceExpression)qualifier).getType();
                    referencedClass = PsiUtil.resolveClassInType((PsiType)type2);
                } else if (qualifier == null) {
                    resolved = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
                    if (resolved != null) {
                        referencedClass = ((PsiMethod)resolved).getContainingClass();
                    }
                } else if (qualifier instanceof PsiThisExpression) {
                    referencedClass = PsiUtil.resolveClassInType((PsiType)((PsiThisExpression)qualifier).getType());
                }
            }
            if (resolved instanceof PsiField) {
                PsiField referencedField = (PsiField)resolved;
                if (referencedField.hasModifierProperty("static")) {
                    return null;
                }
                resolvedName = PsiFormatUtil.formatVariable((PsiVariable)referencedField, (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                referencedClass = referencedField.getContainingClass();
            } else if (resolved instanceof PsiMethod) {
                String name2;
                PsiMethod method = (PsiMethod)resolved;
                if (method.hasModifierProperty("static")) {
                    return null;
                }
                PsiElement nameElement = expression2 instanceof PsiThisExpression ? expression2 : ((PsiJavaCodeReferenceElement)expression2).getReferenceNameElement();
                String string = name2 = nameElement == null ? null : nameElement.getText();
                if (isSuperCall) {
                    if (referencedClass == null) {
                        return null;
                    }
                    if (qualifier == null) {
                        PsiClass superClass = referencedClass.getSuperClass();
                        if (superClass == null || !PsiUtil.isInnerClass((PsiClass)superClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)referencedClass, (PsiClass)superClass.getContainingClass(), (boolean)true)) return null;
                        resolvedName = "this";
                    } else {
                        resolvedName = qualifier.getText();
                    }
                } else if ("this".equals(name2)) {
                    resolvedName = "this";
                } else {
                    resolvedName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
                    if (referencedClass == null) {
                        referencedClass = method.getContainingClass();
                    }
                }
            } else {
                if (!(resolved instanceof PsiClass)) return null;
                PsiClass aClass = (PsiClass)resolved;
                if (aClass.hasModifierProperty("static")) {
                    return null;
                }
                referencedClass = aClass.getContainingClass();
                if (referencedClass == null) {
                    return null;
                }
                resolvedName = PsiFormatUtil.formatClass((PsiClass)aClass, (int)1);
            }
        } else {
            if (!(expression2 instanceof PsiThisExpression)) return null;
            PsiThisExpression thisExpression = (PsiThisExpression)expression2;
            type2 = thisExpression.getType();
            referencedClass = PsiUtil.resolveClassInType((PsiType)type2);
            resolvedName = thisExpression.getQualifier() != null ? (referencedClass == null ? null : PsiFormatUtil.formatClass((PsiClass)referencedClass, (int)1) + ".this") : "this";
        }
        if (referencedClass == null || PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiReferenceParameterList.class, (boolean)true, (Class[])new Class[]{PsiExpression.class}) != null) {
            return null;
        }
        PsiElement element = expression2.getParent();
        while (element != null) {
            PsiReferenceExpressionImpl referenceExpression;
            JavaResolveResult[] results;
            PsiElement resolve2;
            if (JavaPsiConstructorUtil.isConstructorCall((PsiElement)element)) {
                PsiClass parentClass = insideConstructorOfClass.apply((PsiElement)element);
                if (parentClass == null) {
                    return null;
                }
                if (PsiUtil.isInnerClass((PsiClass)parentClass) && referencedClass == parentClass.getContainingClass()) {
                    return null;
                }
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)referencedClass, (boolean)true)) {
                    return null;
                }
                if (expression2 instanceof PsiReferenceExpression && !HighlightUtil.isThisOrSuperReference(((PsiReferenceExpression)expression2).getQualifierExpression(), parentClass)) {
                    return null;
                }
                if (expression2 instanceof PsiJavaCodeReferenceElement && !parentClass.equals(PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class)) && PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiTypeElement.class) != null) {
                    return null;
                }
                if (expression2 instanceof PsiJavaCodeReferenceElement && PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClassObjectAccessExpression.class) != null) {
                    return null;
                }
                HighlightInfo highlightInfo = HighlightUtil.createMemberReferencedError(resolvedName, expression2.getTextRange());
                if (!(expression2 instanceof PsiReferenceExpression) || !PsiUtil.isInnerClass((PsiClass)parentClass)) return highlightInfo;
                String referenceName = ((PsiReferenceExpression)expression2).getReferenceName();
                PsiClass containingClass = parentClass.getContainingClass();
                LOG.assertTrue(containingClass != null);
                PsiField fieldInContainingClass = containingClass.findFieldByName(referenceName, true);
                if (fieldInContainingClass == null || ((PsiReferenceExpression)expression2).getQualifierExpression() != null) return highlightInfo;
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)new QualifyWithThisFix(containingClass, expression2));
                return highlightInfo;
            }
            if (element instanceof PsiReferenceExpression && (resolve2 = element instanceof PsiReferenceExpressionImpl ? ((results = JavaResolveUtil.resolveWithContainingFile(referenceExpression = (PsiReferenceExpressionImpl)element, PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE, true, false, containingFile)).length == 1 ? results[0].getElement() : null) : ((PsiReferenceExpression)element).resolve()) instanceof PsiField && ((PsiField)resolve2).hasModifierProperty("static")) {
                return null;
            }
            if (!((element = element.getParent()) instanceof PsiClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)element), (PsiClass)referencedClass, (boolean)true)) continue;
            return null;
        }
        return null;
    }

    private static HighlightInfo createMemberReferencedError(@NotNull String resolvedName, @NotNull TextRange textRange) {
        String description = JavaErrorBundle.message("member.referenced.before.constructor.called", resolvedName);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
    }

    static HighlightInfo checkImplicitThisReferenceBeforeSuper(@NotNull PsiClass aClass, @NotNull JavaSdkVersion javaSdkVersion) {
        if (javaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7)) {
            return null;
        }
        if (aClass instanceof PsiAnonymousClass || aClass instanceof PsiTypeParameter) {
            return null;
        }
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null || !PsiUtil.isInnerClass((PsiClass)superClass)) {
            return null;
        }
        PsiClass outerClass = superClass.getContainingClass();
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)outerClass, (boolean)true)) {
            return null;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightUtil.createMemberReferencedError(aClass.getName() + ".this", range);
        }
        for (PsiMethod constructor : constructors) {
            PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor);
            if (JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)call)) continue;
            return HighlightUtil.createMemberReferencedError(aClass.getName() + ".this", HighlightNamesUtil.getMethodDeclarationTextRange(constructor));
        }
        return null;
    }

    private static boolean isThisOrSuperReference(@Nullable PsiExpression qualifierExpression2, @NotNull PsiClass aClass) {
        PsiJavaCodeReferenceElement qualifier;
        if (qualifierExpression2 == null) {
            return true;
        }
        if (qualifierExpression2 instanceof PsiThisExpression) {
            qualifier = ((PsiThisExpression)qualifierExpression2).getQualifier();
        } else if (qualifierExpression2 instanceof PsiSuperExpression) {
            qualifier = ((PsiSuperExpression)qualifierExpression2).getQualifier();
        } else {
            return false;
        }
        if (qualifier == null) {
            return true;
        }
        PsiElement resolved = qualifier.resolve();
        return resolved instanceof PsiClass && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)((PsiClass)resolved), (boolean)true);
    }

    static HighlightInfo checkLabelWithoutStatement(@NotNull PsiLabeledStatement statement) {
        if (statement.getStatement() == null) {
            String description = JavaErrorBundle.message("label.without.statement", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkLabelAlreadyInUse(@NotNull PsiLabeledStatement statement) {
        PsiIdentifier identifier = statement.getLabelIdentifier();
        String text2 = identifier.getText();
        for (PsiLabeledStatement element = statement; element != null && !(element instanceof PsiMethod) && !(element instanceof PsiClass); element = element.getParent()) {
            if (!(element instanceof PsiLabeledStatement) || element == statement || !Objects.equals(element.getLabelIdentifier().getText(), text2)) continue;
            String description = JavaErrorBundle.message("duplicate.label", text2);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkUnclosedComment(@NotNull PsiComment comment) {
        if (!(comment instanceof PsiDocComment) && comment.getTokenType() != JavaTokenType.C_STYLE_COMMENT) {
            return null;
        }
        if (!comment.getText().endsWith("*/")) {
            int start = comment.getTextRange().getEndOffset() - 1;
            int end = start + 1;
            String description = JavaErrorBundle.message("unclosed.comment", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(start, end).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @NotNull
    static Collection<HighlightInfo> checkCatchTypeIsDisjoint(@NotNull PsiParameter parameter2) {
        if (!(parameter2.getType() instanceof PsiDisjunctionType)) {
            return Collections.emptyList();
        }
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter2);
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(typeElements.size());
        int size = typeElements.size();
        block0: for (int i = 0; i < size; ++i) {
            PsiClass class1 = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiTypeElement)typeElements.get(i)).getType());
            if (class1 == null) continue;
            for (int j = i + 1; j < size; ++j) {
                PsiClass class2 = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiTypeElement)typeElements.get(j)).getType());
                if (class2 == null) continue;
                boolean sub = InheritanceUtil.isInheritorOrSelf((PsiClass)class1, (PsiClass)class2, (boolean)true);
                boolean sup = InheritanceUtil.isInheritorOrSelf((PsiClass)class2, (PsiClass)class1, (boolean)true);
                if (!sub && !sup) continue;
                String name1 = PsiFormatUtil.formatClass((PsiClass)class1, (int)2049);
                String name2 = PsiFormatUtil.formatClass((PsiClass)class2, (int)2049);
                String message2 = JavaErrorBundle.message("exception.must.be.disjoint", sub ? name1 : name2, sub ? name2 : name1);
                PsiTypeElement element = (PsiTypeElement)typeElements.get(sub ? i : j);
                HighlightInfo highlight = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(message2).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlight, (IntentionAction)HighlightUtil.getFixFactory().createDeleteMultiCatchFix(element));
                result.add(highlight);
                continue block0;
            }
        }
        return result;
    }

    @NotNull
    static Collection<HighlightInfo> checkExceptionAlreadyCaught(@NotNull PsiParameter parameter2) {
        PsiElement scope = parameter2.getDeclarationScope();
        if (!(scope instanceof PsiCatchSection)) {
            return Collections.emptyList();
        }
        PsiCatchSection catchSection = (PsiCatchSection)scope;
        Object[] allCatchSections = catchSection.getTryStatement().getCatchSections();
        int startFrom = ArrayUtilRt.find((Object[])allCatchSections, (Object)catchSection) - 1;
        if (startFrom < 0) {
            return Collections.emptyList();
        }
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter2);
        boolean isInMultiCatch = typeElements.size() > 1;
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        for (PsiTypeElement typeElement : typeElements) {
            PsiClass catchClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)typeElement.getType());
            if (catchClass == null) continue;
            for (int i = startFrom; i >= 0; --i) {
                boolean highlight;
                Object upperCatchSection = allCatchSections[i];
                PsiType upperCatchType = upperCatchSection.getCatchType();
                boolean bl = highlight = upperCatchType instanceof PsiDisjunctionType ? HighlightUtil.checkMultipleTypes(catchClass, ((PsiDisjunctionType)upperCatchType).getDisjunctions()) : HighlightUtil.checkSingleType(catchClass, upperCatchType);
                if (!highlight) continue;
                String className2 = PsiFormatUtil.formatClass((PsiClass)catchClass, (int)2049);
                String description = JavaErrorBundle.message("exception.already.caught", className2);
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
                result.add(highlightInfo);
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createMoveCatchUpFix(catchSection, (PsiCatchSection)upperCatchSection));
                if (isInMultiCatch) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createDeleteMultiCatchFix(typeElement));
                    continue;
                }
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createDeleteCatchFix(parameter2));
            }
        }
        return result;
    }

    private static boolean checkMultipleTypes(@NotNull PsiClass catchClass, @NotNull List<? extends PsiType> upperCatchTypes) {
        for (int i = upperCatchTypes.size() - 1; i >= 0; --i) {
            if (!HighlightUtil.checkSingleType(catchClass, upperCatchTypes.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkSingleType(@NotNull PsiClass catchClass, @Nullable PsiType upperCatchType) {
        PsiClass upperCatchClass = PsiUtil.resolveClassInType((PsiType)upperCatchType);
        return upperCatchClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)catchClass, (PsiClass)upperCatchClass, (boolean)true);
    }

    static HighlightInfo checkTernaryOperatorConditionIsBoolean(@NotNull PsiExpression expression2, @Nullable PsiType type2) {
        if (expression2.getParent() instanceof PsiConditionalExpression && ((PsiConditionalExpression)expression2.getParent()).getCondition() == expression2 && !TypeConversionUtil.isBooleanType((PsiType)type2)) {
            return HighlightUtil.createMustBeBooleanInfo(expression2, type2);
        }
        return null;
    }

    static HighlightInfo checkSwitchBlockStatements(@NotNull PsiSwitchBlock switchBlock, @NotNull LanguageLevel languageLevel, @NotNull PsiFile file) {
        PsiCodeBlock body2 = switchBlock.getBody();
        if (body2 != null) {
            PsiElement first = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)body2.getLBrace());
            if (first != null && !(first instanceof PsiSwitchLabelStatementBase) && !PsiUtil.isJavaToken((PsiElement)first, (IElementType)JavaTokenType.RBRACE)) {
                String description = JavaErrorBundle.message("statement.must.be.prepended.with.case.label", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(first).descriptionAndTooltip(description).create();
            }
            PsiElement element = first;
            PsiStatement alien = null;
            boolean classicLabels = false;
            boolean enhancedLabels = false;
            boolean levelChecked = false;
            while (element != null && !PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.RBRACE)) {
                PsiExpressionList values;
                if (element instanceof PsiSwitchLabeledRuleStatement) {
                    if (!levelChecked) {
                        HighlightInfo info = HighlightUtil.checkFeature(element, HighlightingFeature.ENHANCED_SWITCH, languageLevel, file);
                        if (info != null) {
                            return info;
                        }
                        levelChecked = true;
                    }
                    if (classicLabels) {
                        alien = (PsiStatement)element;
                        break;
                    }
                    enhancedLabels = true;
                } else if (element instanceof PsiStatement) {
                    if (enhancedLabels) {
                        alien = (PsiStatement)element;
                        break;
                    }
                    classicLabels = true;
                }
                if (!levelChecked && element instanceof PsiSwitchLabelStatementBase && (values = ((PsiSwitchLabelStatementBase)element).getCaseValues()) != null && values.getExpressionCount() > 1) {
                    HighlightInfo info = HighlightUtil.checkFeature((PsiElement)values, HighlightingFeature.ENHANCED_SWITCH, languageLevel, file);
                    if (info != null) {
                        return info;
                    }
                    levelChecked = true;
                }
                element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
            }
            if (alien != null) {
                if (enhancedLabels && !(alien instanceof PsiSwitchLabelStatementBase)) {
                    PsiSwitchLabeledRuleStatement previousRule = (PsiSwitchLabeledRuleStatement)PsiTreeUtil.getPrevSiblingOfType(alien, PsiSwitchLabeledRuleStatement.class);
                    String description = JavaErrorBundle.message("statement.must.be.prepended.with.case.label", new Object[0]);
                    HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)alien).descriptionAndTooltip(description).create();
                    if (previousRule != null) {
                        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createWrapSwitchRuleStatementsIntoBlockFix(previousRule));
                    }
                    return info;
                }
                String description = JavaErrorBundle.message("different.case.kinds.in.switch", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(alien).descriptionAndTooltip(description).create();
            }
        }
        return null;
    }

    static HighlightInfo checkAssertOperatorTypes(@NotNull PsiExpression expression2, @Nullable PsiType type2) {
        if (type2 == null) {
            return null;
        }
        if (!(expression2.getParent() instanceof PsiAssertStatement)) {
            return null;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)expression2.getParent();
        if (expression2 == assertStatement.getAssertCondition() && !TypeConversionUtil.isBooleanType((PsiType)type2)) {
            HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)PsiType.BOOLEAN, type2, expression2.getTextRange(), 0);
            if (expression2 instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)expression2).getOperationTokenType() == JavaTokenType.EQ) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createAssignmentToComparisonFix((PsiAssignmentExpression)expression2));
            }
            return highlightInfo;
        }
        if (expression2 == assertStatement.getAssertDescription() && TypeConversionUtil.isVoidType((PsiType)type2)) {
            String description = JavaErrorBundle.message("void.type.is.not.allowed", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkSynchronizedExpressionType(@NotNull PsiExpression expression2, @Nullable PsiType type2, @NotNull PsiFile containingFile) {
        PsiSynchronizedStatement synchronizedStatement;
        if (type2 == null) {
            return null;
        }
        if (expression2.getParent() instanceof PsiSynchronizedStatement && expression2 == (synchronizedStatement = (PsiSynchronizedStatement)expression2.getParent()).getLockExpression() && (type2 instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)type2))) {
            PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)containingFile.getManager(), (GlobalSearchScope)expression2.getResolveScope());
            return HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)objectType, type2, expression2.getTextRange(), 0);
        }
        return null;
    }

    static HighlightInfo checkConditionalExpressionBranchTypesMatch(@NotNull PsiExpression expression2, @Nullable PsiType type2) {
        PsiElement parent = expression2.getParent();
        if (!(parent instanceof PsiConditionalExpression)) {
            return null;
        }
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
        if (conditionalExpression.getElseExpression() != expression2) {
            return null;
        }
        PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
        assert (thenExpression2 != null);
        PsiType thenType = thenExpression2.getType();
        if (thenType == null || type2 == null) {
            return null;
        }
        if (conditionalExpression.getType() == null) {
            if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)conditionalExpression) && PsiPolyExpressionUtil.isPolyExpression((PsiExpression)conditionalExpression)) {
                return null;
            }
            return HighlightUtil.createIncompatibleTypeHighlightInfo(thenType, type2, expression2.getTextRange(), 0);
        }
        return null;
    }

    static HighlightInfo createIncompatibleTypeHighlightInfo(@NotNull PsiType lType, @Nullable PsiType rType, @NotNull TextRange textRange, int navigationShift) {
        return HighlightUtil.createIncompatibleTypeHighlightInfo(lType, rType, textRange, navigationShift, HighlightUtil.getReasonForIncompatibleTypes(rType));
    }

    static HighlightInfo createIncompatibleTypeHighlightInfo(@NotNull PsiType lType, @Nullable PsiType rType, @NotNull TextRange textRange, int navigationShift, @NotNull String reason) {
        lType = PsiUtil.convertAnonymousToBaseType((PsiType)lType);
        rType = rType == null ? null : PsiUtil.convertAnonymousToBaseType((PsiType)rType);
        String styledReason = reason.isEmpty() ? "" : String.format("<table><tr><td style=''padding-top: 10px; padding-left: 4px;''>%s</td></tr></table>", reason);
        String toolTip = HighlightUtil.createIncompatibleTypesTooltip(lType, rType, (lRawType, lTypeArguments, rRawType, rTypeArguments) -> JavaErrorBundle.message("incompatible.types.html.tooltip", lRawType, lTypeArguments, rRawType, rTypeArguments, styledReason, "#" + ColorUtil.toHex((Color)UIUtil.getContextHelpForeground())));
        String description = JavaErrorBundle.message("incompatible.types", JavaHighlightUtil.formatType(lType), JavaHighlightUtil.formatType(rType));
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).description(description).escapedToolTip(toolTip).navigationShift(navigationShift).create();
    }

    @NotNull
    static String createIncompatibleTypesTooltip(PsiType lType, PsiType rType, @NotNull IncompatibleTypesTooltipComposer consumer) {
        Trinity<PsiType, PsiTypeParameter[], PsiSubstitutor> lTypeData = HighlightUtil.typeData(lType);
        Trinity<PsiType, PsiTypeParameter[], PsiSubstitutor> rTypeData = HighlightUtil.typeData(rType);
        PsiTypeParameter[] lTypeParams = (PsiTypeParameter[])lTypeData.second;
        PsiTypeParameter[] rTypeParams = (PsiTypeParameter[])rTypeData.second;
        int typeParamColumns = Math.max(lTypeParams.length, rTypeParams.length);
        boolean skipColumns = consumer.skipTypeArgsColumns();
        StringBuilder requiredRow = new StringBuilder();
        StringBuilder foundRow = new StringBuilder();
        for (int i = 0; i < typeParamColumns; ++i) {
            PsiTypeParameter lTypeParameter = i >= lTypeParams.length ? null : lTypeParams[i];
            PsiTypeParameter rTypeParameter = i >= rTypeParams.length ? null : rTypeParams[i];
            PsiType lSubstitutedType = lTypeParameter == null ? null : ((PsiSubstitutor)lTypeData.third).substitute(lTypeParameter);
            PsiType rSubstitutedType = rTypeParameter == null ? null : ((PsiSubstitutor)rTypeData.third).substitute(rTypeParameter);
            boolean matches = lSubstitutedType == rSubstitutedType || lSubstitutedType != null && rSubstitutedType != null && TypeConversionUtil.typesAgree((PsiType)lSubstitutedType, (PsiType)rSubstitutedType, (boolean)true);
            String openBrace = i == 0 ? "&lt;" : "";
            String closeBrace = i == typeParamColumns - 1 ? "&gt;" : ",";
            boolean showShortType = HighlightUtil.showShortType(lSubstitutedType, rSubstitutedType);
            requiredRow.append(skipColumns ? "" : "<td style='padding: 0px 0px 8px 0px;'>").append(lTypeParams.length == 0 ? "" : openBrace).append(HighlightUtil.redIfNotMatch(lSubstitutedType, true, showShortType)).append(i < lTypeParams.length ? closeBrace : "").append(skipColumns ? "" : "</td>");
            foundRow.append(skipColumns ? "" : "<td style='padding: 0px 0px 0px 0px;'>").append(rTypeParams.length == 0 ? "" : openBrace).append(HighlightUtil.redIfNotMatch(rSubstitutedType, matches, showShortType)).append(i < rTypeParams.length ? closeBrace : "").append(skipColumns ? "" : "</td>");
        }
        PsiType lRawType = lType instanceof PsiClassType ? ((PsiClassType)lType).rawType() : lType;
        PsiType rRawType = rType instanceof PsiClassType ? ((PsiClassType)rType).rawType() : rType;
        boolean assignable = lRawType == null || rRawType == null || TypeConversionUtil.isAssignable((PsiType)lRawType, (PsiType)rRawType);
        boolean shortType = HighlightUtil.showShortType(lRawType, rRawType);
        return consumer.consume(HighlightUtil.redIfNotMatch(lRawType, true, shortType), requiredRow.toString(), HighlightUtil.redIfNotMatch(rRawType, assignable, shortType), foundRow.toString());
    }

    static boolean showShortType(@Nullable PsiType lType, @Nullable PsiType rType) {
        if (Comparing.equal((Object)lType, (Object)rType)) {
            return true;
        }
        return lType != null && rType != null && !Comparing.strEqual((String)lType.getPresentableText(), (String)rType.getPresentableText());
    }

    @NotNull
    private static String getReasonForIncompatibleTypes(PsiType rType) {
        JavaResolveResult[] results;
        if (rType instanceof PsiMethodReferenceType && (results = ((PsiMethodReferenceType)rType).getExpression().multiResolve(false)).length > 1) {
            PsiElement element1 = results[0].getElement();
            PsiElement element2 = results[1].getElement();
            if (element1 instanceof PsiMethod && element2 instanceof PsiMethod) {
                String candidate1 = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element1), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
                String candidate2 = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element2), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
                return JavaErrorBundle.message("incompatible.types.reason.ambiguous.method.reference", candidate1, candidate2);
            }
        }
        return "";
    }

    @NotNull
    private static Trinity<PsiType, PsiTypeParameter[], PsiSubstitutor> typeData(PsiType type2) {
        PsiTypeParameter[] parameters2 = PsiTypeParameter.EMPTY_ARRAY;
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (type2 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type2).resolveGenerics();
            substitutor = resolveResult.getSubstitutor();
            PsiClass psiClass = resolveResult.getElement();
            parameters2 = psiClass == null || ((PsiClassType)type2).isRaw() ? PsiTypeParameter.EMPTY_ARRAY : psiClass.getTypeParameters();
        }
        return Trinity.create((Object)type2, (Object)parameters2, (Object)substitutor);
    }

    @NotNull
    static String redIfNotMatch(@Nullable PsiType type2, boolean matches, boolean shortType) {
        if (type2 == null) {
            return "";
        }
        String color = ColorUtil.toHtmlColor((Color)(matches ? UIUtil.getToolTipForeground() : DialogWrapper.ERROR_FOREGROUND_COLOR));
        return "<font color='" + color + "'>" + XmlStringUtil.escapeString((String)(shortType || type2 instanceof PsiCapturedWildcardType ? type2.getPresentableText() : type2.getCanonicalText())) + "</font>";
    }

    static HighlightInfo checkSingleImportClassConflict(@NotNull PsiImportStatement statement, @NotNull Map<String, Pair<PsiImportStaticReferenceElement, PsiClass>> importedClasses, @NotNull PsiFile containingFile) {
        if (statement.isOnDemand()) {
            return null;
        }
        PsiElement element = statement.resolve();
        if (element instanceof PsiClass) {
            String name2 = ((PsiClass)element).getName();
            Pair<PsiImportStaticReferenceElement, PsiClass> imported = importedClasses.get(name2);
            PsiClass importedClass = (PsiClass)Pair.getSecond(imported);
            if (importedClass != null && !containingFile.getManager().areElementsEquivalent((PsiElement)importedClass, element)) {
                String description = JavaErrorBundle.message("single.import.class.conflict", HighlightUtil.formatClass(importedClass));
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
            }
            importedClasses.put(name2, (Pair<PsiImportStaticReferenceElement, PsiClass>)Pair.pair(null, (Object)((PsiClass)element)));
        }
        return null;
    }

    static HighlightInfo checkMustBeThrowable(@NotNull PsiType type2, @NotNull PsiElement context, boolean addCastIntention) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        PsiClassType throwable = factory.createTypeByFQClassName("java.lang.Throwable", context.getResolveScope());
        if (!TypeConversionUtil.isAssignable((PsiType)throwable, (PsiType)type2)) {
            PsiClass aClass;
            HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)throwable, type2, context.getTextRange(), 0);
            if (addCastIntention && TypeConversionUtil.areTypesConvertible((PsiType)type2, (PsiType)throwable) && context instanceof PsiExpression) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createAddTypeCastFix((PsiType)throwable, (PsiExpression)context));
            }
            if ((aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2)) != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createExtendsListFix(aClass, throwable, true));
            }
            return highlightInfo;
        }
        return null;
    }

    private static HighlightInfo checkMustBeThrowable(@NotNull PsiClass aClass, @NotNull PsiElement context) {
        PsiClassType type2 = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass);
        return HighlightUtil.checkMustBeThrowable((PsiType)type2, context, false);
    }

    static HighlightInfo checkReference(@NotNull PsiJavaCodeReferenceElement ref, @NotNull JavaResolveResult result, @NotNull PsiFile containingFile, @NotNull LanguageLevel languageLevel) {
        String description;
        boolean skipValidityChecks;
        PsiElement granny;
        PsiElement refName = ref.getReferenceNameElement();
        if (!(refName instanceof PsiIdentifier) && !(refName instanceof PsiKeyword)) {
            return null;
        }
        PsiElement resolved = result.getElement();
        PsiElement refParent = ref.getParent();
        if (refParent instanceof PsiReferenceExpression && (granny = refParent.getParent()) instanceof PsiMethodCallExpression) {
            PsiReferenceExpression referenceToMethod = ((PsiMethodCallExpression)granny).getMethodExpression();
            PsiExpression qualifierExpression2 = referenceToMethod.getQualifierExpression();
            if (qualifierExpression2 == ref && resolved != null && !(resolved instanceof PsiClass) && !(resolved instanceof PsiVariable)) {
                String message2 = JavaErrorBundle.message("qualifier.must.be.expression", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range((PsiElement)qualifierExpression2).descriptionAndTooltip(message2).create();
            }
        } else if (refParent instanceof PsiMethodCallExpression) {
            return null;
        }
        if (resolved == null) {
            String description2;
            PsiJavaCodeReferenceElement parent = HighlightUtil.getOuterReferenceParent(ref);
            PsiElement outerParent = parent.getParent();
            if (outerParent instanceof PsiPackageStatement || result.isPackagePrefixPackageReference() || PsiUtil.isInsideJavadocComment((PsiElement)ref) || parent.resolve() instanceof PsiMember || outerParent instanceof PsiPackageAccessibilityStatement) {
                return null;
            }
            JavaResolveResult[] results = ref.multiResolve(true);
            if (results.length > 1) {
                String t1 = HighlightUtil.format(Objects.requireNonNull(results[0].getElement()));
                String t2 = HighlightUtil.format(Objects.requireNonNull(results[1].getElement()));
                description2 = JavaErrorBundle.message("ambiguous.reference", refName.getText(), t1, t2);
            } else {
                description2 = JavaErrorBundle.message("cannot.resolve.symbol", refName.getText());
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(refName).descriptionAndTooltip(description2).create();
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)ref, (QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info));
            return info;
        }
        boolean bl = skipValidityChecks = PsiUtil.isInsideJavadocComment((PsiElement)ref) || PsiTreeUtil.getParentOfType((PsiElement)ref, PsiPackageStatement.class, (boolean)true) != null || resolved instanceof PsiPackage && ref.getParent() instanceof PsiJavaCodeReferenceElement;
        if (!skipValidityChecks && !result.isValidResult()) {
            if (!result.isAccessible()) {
                Pair<String, List<IntentionAction>> problem = HighlightUtil.accessProblemDescriptionAndFixes((PsiElement)ref, resolved, result);
                boolean moduleAccessProblem = problem.second != null;
                PsiElement range = moduleAccessProblem ? HighlightUtil.findPackagePrefix(ref) : refName;
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(range).descriptionAndTooltip((String)problem.first).create();
                if (moduleAccessProblem) {
                    ((List)problem.second).forEach(fix -> QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)fix));
                } else if (result.isStaticsScopeCorrect() && resolved instanceof PsiJvmMember) {
                    HighlightFixUtil.registerAccessQuickFixAction((PsiJvmMember)resolved, ref, info, result.getCurrentFileResolveScope());
                    if (ref instanceof PsiReferenceExpression) {
                        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createRenameWrongRefFix((PsiReferenceExpression)ref));
                    }
                }
                UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)ref, (QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info));
                return info;
            }
            if (!result.isStaticsScopeCorrect()) {
                description = HighlightUtil.staticContextProblemDescription(resolved);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(refName).descriptionAndTooltip(description).create();
                HighlightFixUtil.registerStaticProblemQuickFixAction(resolved, info, ref);
                if (ref instanceof PsiReferenceExpression) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createRenameWrongRefFix((PsiReferenceExpression)ref));
                }
                return info;
            }
        }
        if ((resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter) && !(resolved instanceof ImplicitVariable)) {
            return HighlightControlFlowUtil.checkVariableMustBeFinal((PsiVariable)resolved, ref, languageLevel);
        }
        if (resolved instanceof PsiClass && ((PsiClass)resolved).getContainingClass() == null && PsiUtil.isFromDefaultPackage((PsiElement)resolved) && (PsiTreeUtil.getParentOfType((PsiElement)ref, PsiImportStatementBase.class) != null || PsiUtil.isModuleFile((PsiFile)containingFile) || !PsiUtil.isFromDefaultPackage((PsiElement)containingFile))) {
            description = JavaErrorBundle.message("class.in.default.package", ((PsiClass)resolved).getName());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(refName).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @NotNull
    private static PsiElement findPackagePrefix(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiJavaCodeReferenceElement candidate = ref;
        while (candidate instanceof PsiJavaCodeReferenceElement) {
            if (candidate.resolve() instanceof PsiPackage) {
                return candidate;
            }
            candidate = candidate.getQualifier();
        }
        return ref;
    }

    @NotNull
    private static String format(@NotNull PsiElement element) {
        if (element instanceof PsiClass) {
            return HighlightUtil.formatClass((PsiClass)element);
        }
        if (element instanceof PsiMethod) {
            return JavaHighlightUtil.formatMethod((PsiMethod)element);
        }
        if (element instanceof PsiField) {
            return HighlightUtil.formatField((PsiField)element);
        }
        if (element instanceof PsiLabeledStatement) {
            return ((PsiLabeledStatement)element).getName() + ':';
        }
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)HighlightUsagesDescriptionLocation.INSTANCE);
    }

    @NotNull
    private static PsiJavaCodeReferenceElement getOuterReferenceParent(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement parent;
        PsiJavaCodeReferenceElement element = ref;
        while ((parent = element.getParent()) instanceof PsiJavaCodeReferenceElement) {
            element = (PsiJavaCodeReferenceElement)parent;
        }
        return element;
    }

    static HighlightInfo checkPackageAndClassConflict(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiFile containingFile) {
        Module module;
        if (ref.isQualified() && HighlightUtil.getOuterReferenceParent(ref).getParent() instanceof PsiPackageStatement && (module = ModuleUtilCore.findModuleForFile((PsiFile)containingFile)) != null) {
            GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
            PsiClass aClass = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass(ref.getCanonicalText(), scope);
            if (aClass != null) {
                String message2 = JavaErrorBundle.message("package.clashes.with.class", ref.getText());
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(message2).create();
            }
        }
        return null;
    }

    static HighlightInfo checkElementInReferenceList(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiReferenceList referenceList, @NotNull JavaResolveResult resolveResult) {
        PsiElement resolved = resolveResult.getElement();
        HighlightInfo highlightInfo = null;
        PsiElement refGrandParent = referenceList.getParent();
        if (resolved instanceof PsiClass) {
            PsiClass aClass = (PsiClass)resolved;
            if (refGrandParent instanceof PsiClass) {
                if (refGrandParent instanceof PsiTypeParameter) {
                    highlightInfo = GenericsHighlightUtil.checkElementInTypeParameterExtendsList(referenceList, (PsiClass)refGrandParent, resolveResult, (PsiElement)ref);
                } else if (referenceList.equals(((PsiClass)refGrandParent).getImplementsList()) || referenceList.equals(((PsiClass)refGrandParent).getExtendsList())) {
                    highlightInfo = HighlightClassUtil.checkExtendsClassAndImplementsInterface(referenceList, resolveResult, ref);
                    if (highlightInfo == null) {
                        highlightInfo = HighlightClassUtil.checkCannotInheritFromFinal(aClass, (PsiElement)ref);
                    }
                    if (highlightInfo == null) {
                        highlightInfo = HighlightClassUtil.checkExtendsProhibitedClass(aClass, (PsiElement)ref);
                    }
                    if (highlightInfo == null) {
                        highlightInfo = GenericsHighlightUtil.checkCannotInheritFromTypeParameter(aClass, ref);
                    }
                    if (highlightInfo == null) {
                        highlightInfo = HighlightClassUtil.checkExtendsSealedClass((PsiClass)refGrandParent, aClass, ref);
                    }
                }
            } else if (refGrandParent instanceof PsiMethod && ((PsiMethod)refGrandParent).getThrowsList() == referenceList) {
                highlightInfo = HighlightUtil.checkMustBeThrowable(aClass, (PsiElement)ref);
            }
        } else if (refGrandParent instanceof PsiMethod && referenceList == ((PsiMethod)refGrandParent).getThrowsList()) {
            String description = JavaErrorBundle.message("class.name.expected", new Object[0]);
            highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(description).create();
        }
        return highlightInfo;
    }

    public static boolean isSerializationImplicitlyUsedField(@NotNull PsiField field) {
        String name2 = field.getName();
        if (!"serialVersionUID".equals(name2) && !SERIAL_PERSISTENT_FIELDS_FIELD_NAME.equals(name2)) {
            return false;
        }
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        return aClass == null || JavaHighlightUtil.isSerializable(aClass);
    }

    static HighlightInfo checkClassReferenceAfterQualifier(@NotNull PsiReferenceExpression expression2, @Nullable PsiElement resolved) {
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiExpression qualifier = expression2.getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        if (qualifier instanceof PsiReferenceExpression) {
            PsiElement qualifierResolved = ((PsiReferenceExpression)qualifier).resolve();
            if (qualifierResolved instanceof PsiClass || qualifierResolved instanceof PsiPackage) {
                return null;
            }
            if (qualifierResolved == null) {
                PsiElement qResolve;
                PsiReferenceExpression qExpression = (PsiReferenceExpression)qualifier;
                while ((qResolve = qExpression.resolve()) == null || qResolve instanceof PsiClass || qResolve instanceof PsiPackage) {
                    PsiExpression qualifierExpression2 = qExpression.getQualifierExpression();
                    if (qualifierExpression2 == null) {
                        return null;
                    }
                    if (!(qualifierExpression2 instanceof PsiReferenceExpression)) break;
                    qExpression = (PsiReferenceExpression)qualifierExpression2;
                }
            }
        }
        String description = JavaErrorBundle.message("expected.class.or.package", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)HighlightUtil.getFixFactory().createRemoveQualifierFix(qualifier, expression2, (PsiClass)resolved));
        return info;
    }

    static HighlightInfo checkAnnotationMethodParameters(@NotNull PsiParameterList list) {
        PsiElement parent = list.getParent();
        if (PsiUtil.isAnnotationMethod((PsiElement)parent) && !list.isEmpty()) {
            String message2 = JavaErrorBundle.message("annotation.interface.members.may.not.have.parameters", new Object[0]);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)HighlightUtil.getFixFactory().createRemoveParameterListFix((PsiMethod)parent));
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkForStatement(@NotNull PsiForStatement statement) {
        PsiStatement init = statement.getInitialization();
        if (init == null || init instanceof PsiEmptyStatement || init instanceof PsiDeclarationStatement && ArrayUtil.getFirstElement((Object[])((PsiDeclarationStatement)init).getDeclaredElements()) instanceof PsiLocalVariable || init instanceof PsiExpressionStatement || init instanceof PsiExpressionListStatement) {
            return null;
        }
        String message2 = JavaErrorBundle.message("invalid.statement", new Object[0]);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)init).descriptionAndTooltip(message2).create();
    }

    @NotNull
    private static LanguageLevel getApplicableLevel(@NotNull PsiFile file, @NotNull HighlightingFeature feature) {
        JavaSdkVersion sdkVersion;
        LanguageLevel standardLevel = feature.getStandardLevel();
        if (feature.level.isPreview() && (sdkVersion = JavaSdkVersionUtil.getJavaSdkVersion((PsiElement)file)) != null) {
            if (standardLevel != null && sdkVersion.isAtLeast(JavaSdkVersion.fromLanguageLevel((LanguageLevel)standardLevel))) {
                return standardLevel;
            }
            LanguageLevel previewLevel = sdkVersion.getMaxLanguageLevel().getPreviewLevel();
            if (previewLevel != null && previewLevel.isAtLeast(feature.level)) {
                return previewLevel;
            }
        }
        return feature.level;
    }

    static HighlightInfo checkFeature(@NotNull PsiElement element, @NotNull HighlightingFeature feature, @NotNull LanguageLevel level, @NotNull PsiFile file) {
        if (file.getManager().isInProject((PsiElement)file) && !feature.isSufficient(level)) {
            String message2 = HighlightUtil.getUnsupportedFeatureMessage(element, feature, level, file);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(message2).create();
            HighlightUtil.registerIncreaseLanguageLevelFixes((QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info), element, feature);
            return info;
        }
        return null;
    }

    public static void registerIncreaseLanguageLevelFixes(@NotNull QuickFixActionRegistrar registrar, @NotNull PsiElement element, @NotNull HighlightingFeature feature) {
        if (feature.isAvailable(element)) {
            return;
        }
        registrar.register(HighlightUtil.getFixFactory().createIncreaseLanguageLevelFix(HighlightUtil.getApplicableLevel(element.getContainingFile(), feature)));
        registrar.register(HighlightUtil.getFixFactory().createShowModulePropertiesFix(element));
    }

    @NotNull
    private static String getUnsupportedFeatureMessage(@NotNull PsiElement element, @NotNull HighlightingFeature feature, @NotNull LanguageLevel level, @NotNull PsiFile file) {
        LanguageLevel moduleLanguageLevel;
        String name2 = JavaAnalysisBundle.message((String)feature.key, (Object[])new Object[0]);
        String version = JavaSdkVersion.fromLanguageLevel((LanguageLevel)level).getDescription();
        String message2 = JavaErrorBundle.message("insufficient.language.level", name2, version);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null && (moduleLanguageLevel = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module)).isAtLeast(feature.level)) {
            for (FilePropertyPusher pusher : (FilePropertyPusher[])FilePropertyPusher.EP_NAME.getExtensions()) {
                String newMessage;
                if (!(pusher instanceof JavaLanguageLevelPusher) || (newMessage = ((JavaLanguageLevelPusher)pusher).getInconsistencyLanguageLevelMessage(message2, element, level, file)) == null) continue;
                return newMessage;
            }
        }
        return message2;
    }

    private static /* synthetic */ boolean lambda$checkIntersectionInTypeCast$0(Ref differentArgumentsMessage, Pair pair2) {
        if (!TypesDistinctProver.provablyDistinct((PsiType)((PsiType)pair2.first), (PsiType)((PsiType)pair2.second))) {
            return true;
        }
        differentArgumentsMessage.set((Object)(((PsiType)pair2.first).getPresentableText() + " and " + ((PsiType)pair2.second).getPresentableText()));
        return false;
    }

    static {
        ourClassIncompatibleModifiers.put("abstract", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"final"}));
        ourClassIncompatibleModifiers.put("final", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract", "sealed", "non-sealed"}));
        ourClassIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"private", "public", "protected"}));
        ourClassIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "protected"}));
        ourClassIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "private", "protected"}));
        ourClassIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "private"}));
        ourClassIncompatibleModifiers.put("strictfp", Collections.emptySet());
        ourClassIncompatibleModifiers.put("static", Collections.emptySet());
        ourClassIncompatibleModifiers.put("sealed", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"final", "non-sealed"}));
        ourClassIncompatibleModifiers.put("non-sealed", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"final", "sealed"}));
        ourInterfaceIncompatibleModifiers.put("abstract", Collections.emptySet());
        ourInterfaceIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"private", "public", "protected"}));
        ourInterfaceIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "protected"}));
        ourInterfaceIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "private", "protected"}));
        ourInterfaceIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "private"}));
        ourInterfaceIncompatibleModifiers.put("strictfp", Collections.emptySet());
        ourInterfaceIncompatibleModifiers.put("static", Collections.emptySet());
        ourInterfaceIncompatibleModifiers.put("sealed", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"non-sealed"}));
        ourInterfaceIncompatibleModifiers.put("non-sealed", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"sealed"}));
        ourMethodIncompatibleModifiers.put("abstract", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"native", "static", "final", "private", "strictfp", "synchronized", "default"}));
        ourMethodIncompatibleModifiers.put("native", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract", "strictfp"}));
        ourMethodIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"private", "public", "protected"}));
        ourMethodIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "protected"}));
        ourMethodIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "private", "protected"}));
        ourMethodIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "private"}));
        ourMethodIncompatibleModifiers.put("static", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract", "default", "final"}));
        ourMethodIncompatibleModifiers.put("default", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract", "static", "final", "private"}));
        ourMethodIncompatibleModifiers.put("synchronized", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract"}));
        ourMethodIncompatibleModifiers.put("strictfp", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract"}));
        ourMethodIncompatibleModifiers.put("final", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract"}));
        ourFieldIncompatibleModifiers.put("final", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"volatile"}));
        ourFieldIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"private", "public", "protected"}));
        ourFieldIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "protected"}));
        ourFieldIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "private", "protected"}));
        ourFieldIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "private"}));
        ourFieldIncompatibleModifiers.put("static", Collections.emptySet());
        ourFieldIncompatibleModifiers.put("transient", Collections.emptySet());
        ourFieldIncompatibleModifiers.put("volatile", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"final"}));
        ourClassInitializerIncompatibleModifiers.put("static", Collections.emptySet());
        ourModuleIncompatibleModifiers.put("open", Collections.emptySet());
        ourRequiresIncompatibleModifiers.put("static", Collections.emptySet());
        ourRequiresIncompatibleModifiers.put("transitive", Collections.emptySet());
        FP_LITERAL_PARTS = Pattern.compile("(?:(?:0x([_\\p{XDigit}]*)\\.?([_\\p{XDigit}]*)p[+-]?([_\\d]*))|(?:([_\\d]*)\\.?([_\\d]*)e?[+-]?([_\\d]*)))[fd]?");
    }

    static interface IncompatibleTypesTooltipComposer {
        @NotNull
        public String consume(@NotNull String var1, @NotNull String var2, @NotNull String var3, @NotNull String var4);

        default public boolean skipTypeArgsColumns() {
            return false;
        }
    }

    private static enum SelectorKind {
        INT,
        ENUM,
        STRING;

    }
}

