/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.application.options.editor.AutoImportOptionsConfigurable;
import com.intellij.application.options.editor.JavaAutoImportOptions;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddImportAction
implements QuestionAction {
    private static final Logger LOG = Logger.getInstance(AddImportAction.class);
    private final Project myProject;
    private final PsiReference myReference;
    private final PsiClass[] myTargetClasses;
    private final Editor myEditor;

    public AddImportAction(@NotNull Project project, @NotNull PsiReference ref, @NotNull Editor editor, PsiClass ... targetClasses) {
        this.myProject = project;
        this.myReference = ref;
        this.myTargetClasses = targetClasses;
        this.myEditor = editor;
    }

    public boolean execute() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        if (!this.myReference.getElement().isValid()) {
            return false;
        }
        for (PsiClass myTargetClass : this.myTargetClasses) {
            if (myTargetClass.isValid()) continue;
            return false;
        }
        if (this.myTargetClasses.length == 1) {
            this.addImport(this.myReference, this.myTargetClasses[0]);
        } else {
            this.chooseClassAndImport();
        }
        return true;
    }

    private void chooseClassAndImport() {
        CodeInsightUtil.sortIdenticalShortNamedMembers((PsiMember[])this.myTargetClasses, (PsiReference)this.myReference);
        BaseListPopupStep<PsiClass> step2 = new BaseListPopupStep<PsiClass>(QuickFixBundle.message("class.to.import.chooser.title", new Object[0]), this.myTargetClasses){

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(PsiClass selectedValue, boolean finalChoice) {
                if (selectedValue == null) {
                    return FINAL_CHOICE;
                }
                if (finalChoice) {
                    return this.doFinalStep(() -> {
                        PsiDocumentManager.getInstance((Project)AddImportAction.this.myProject).commitAllDocuments();
                        AddImportAction.this.addImport(AddImportAction.this.myReference, selectedValue);
                    });
                }
                return AddImportAction.getExcludesStep(AddImportAction.this.myProject, selectedValue.getQualifiedName());
            }

            public boolean hasSubstep(PsiClass selectedValue) {
                return true;
            }

            @NotNull
            public String getTextFor(PsiClass value2) {
                return Objects.requireNonNull(value2.getQualifiedName());
            }

            public Icon getIconFor(PsiClass aValue) {
                return aValue.getIcon(0);
            }
        };
        ListPopupImpl popup = new ListPopupImpl(this.myProject, (ListPopupStep)step2){

            protected ListCellRenderer getListElementRenderer() {
                PopupListElementRenderer baseRenderer = (PopupListElementRenderer)super.getListElementRenderer();
                DefaultPsiElementCellRenderer psiRenderer = new DefaultPsiElementCellRenderer();
                return (arg_0, arg_1, arg_2, arg_3, arg_4) -> 2.lambda$getListElementRenderer$0(baseRenderer, (ListCellRenderer)psiRenderer, arg_0, arg_1, arg_2, arg_3, arg_4);
            }

            private static /* synthetic */ Component lambda$getListElementRenderer$0(PopupListElementRenderer baseRenderer, ListCellRenderer psiRenderer, JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel panel2 = new JPanel(new BorderLayout());
                baseRenderer.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus);
                panel2.add((Component)baseRenderer.getNextStepLabel(), "East");
                panel2.add(psiRenderer.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus));
                return panel2;
            }
        };
        NavigationUtil.hidePopupIfDumbModeStarts((JBPopup)popup, (Project)this.myProject);
        popup.showInBestPositionFor(this.myEditor);
    }

    @Nullable
    public static PopupStep getExcludesStep(final @NotNull Project project, @Nullable String qname) {
        if (qname == null) {
            return PopupStep.FINAL_CHOICE;
        }
        List<String> toExclude = AddImportAction.getAllExcludableStrings(qname);
        return new BaseListPopupStep<String>(null, toExclude){

            @NotNull
            public String getTextFor(String value2) {
                return "Exclude '" + value2 + "' from auto-import";
            }

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                if (finalChoice && selectedValue != null) {
                    AddImportAction.excludeFromImport(project, selectedValue);
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }
        };
    }

    public static void excludeFromImport(@NotNull Project project, @NotNull String prefix) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project.isDisposed()) {
                return;
            }
            AutoImportOptionsConfigurable configurable = new AutoImportOptionsConfigurable(project);
            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
                JavaAutoImportOptions options = (JavaAutoImportOptions)((Object)((Object)((Object)ContainerUtil.findInstance((Iterable)configurable.getConfigurables(), JavaAutoImportOptions.class))));
                options.addExcludePackage(prefix);
            });
        });
    }

    @NotNull
    public static List<String> getAllExcludableStrings(@NotNull String qname) {
        ArrayList<String> toExclude = new ArrayList<String>();
        while (true) {
            toExclude.add(qname);
            int i = qname.lastIndexOf(46);
            if (i < 0 || i == qname.indexOf(46)) break;
            qname = qname.substring(0, i);
        }
        return toExclude;
    }

    private void addImport(@NotNull PsiReference ref, @NotNull PsiClass targetClass) {
        DumbService.getInstance((Project)this.myProject).withAlternativeResolveEnabled(() -> {
            if (!ref.getElement().isValid() || !targetClass.isValid() || ref.resolve() == targetClass) {
                return;
            }
            StatisticsManager.getInstance().incUseCount(JavaStatisticsManager.createInfo(null, (PsiMember)targetClass));
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)QuickFixBundle.message("add.import", new Object[0]), null, () -> this.doAddImport(ref, targetClass), (PsiFile[])new PsiFile[]{ref.getElement().getContainingFile()});
        });
    }

    private void doAddImport(@NotNull PsiReference ref, @NotNull PsiClass targetClass) {
        try {
            this.bindReference(ref, targetClass);
            if (CodeInsightWorkspaceSettings.getInstance((Project)this.myProject).isOptimizeImportsOnTheFly()) {
                Document document = this.myEditor.getDocument();
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
                new OptimizeImportsProcessor(this.myProject, psiFile).runWithoutProgress();
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    protected void bindReference(@NotNull PsiReference ref, @NotNull PsiClass targetClass) {
        ref.bindToElement((PsiElement)targetClass);
    }
}

