/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInsight/daemon/impl/JavaSoftKeywordHighlightingVisitor;", "Lcom/intellij/psi/JavaRecursiveElementVisitor;", "results", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "level", "Lcom/intellij/pom/java/LanguageLevel;", "(Ljava/util/List;Lcom/intellij/pom/java/LanguageLevel;)V", "highlightAsKeyword", "", "keyword", "Lcom/intellij/psi/PsiKeyword;", "visitKeyword", "intellij.java.analysis.impl"})
final class JavaSoftKeywordHighlightingVisitor
extends JavaRecursiveElementVisitor {
    private final List<HighlightInfo> results;
    private final LanguageLevel level;

    public void visitKeyword(@NotNull PsiKeyword keyword) {
        if (JavaLexer.isSoftKeyword(keyword.getNode().getChars(), this.level)) {
            this.highlightAsKeyword(keyword);
        } else if (Intrinsics.areEqual((Object)JavaTokenType.NON_SEALED_KEYWORD, (Object)keyword.getTokenType())) {
            this.highlightAsKeyword(keyword);
        }
    }

    private final void highlightAsKeyword(PsiKeyword keyword) {
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)JavaHighlightInfoTypes.JAVA_KEYWORD).range((PsiElement)keyword).create();
        if (info != null) {
            Collection collection = this.results;
            boolean bl = false;
            collection.add(info);
        }
    }

    public JavaSoftKeywordHighlightingVisitor(@NotNull List<HighlightInfo> results, @NotNull LanguageLevel level) {
        this.results = results;
        this.level = level;
    }
}

