/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.impl.JavaLensConfigurable;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaLensSettings;
import com.intellij.codeInsight.daemon.impl.analysis.JavaTelescope;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.SequencePresentation;
import com.intellij.codeInsight.hints.settings.InlayHintsConfigurable;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.SmartList;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import kotlin.Unit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLensProvider
implements InlayHintsProvider<JavaLensSettings> {
    private static final String CODE_LENS_ID = "JavaLens";
    public static final String FUS_GROUP_ID = "java.lens";
    private static final String USAGES_CLICKED_EVENT_ID = "usages.clicked";
    private static final String IMPLEMENTATIONS_CLICKED_EVENT_ID = "implementations.clicked";
    private static final String SETTING_CLICKED_EVENT_ID = "setting.clicked";
    private static final SettingsKey<JavaLensSettings> KEY = new SettingsKey("JavaLens");

    @Nullable
    public InlayHintsCollector getCollectorFor(final @NotNull PsiFile file, @NotNull Editor editor, final @NotNull JavaLensSettings settings, @NotNull InlayHintsSink __) {
        return new FactoryInlayHintsCollector(editor){

            public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
                String usagesHint;
                if (!(element instanceof PsiMember) || element instanceof PsiTypeParameter) {
                    return true;
                }
                PsiElement prevSibling = element.getPrevSibling();
                if (!(prevSibling instanceof PsiWhiteSpace) || !prevSibling.textContains('\n')) {
                    return true;
                }
                PsiMember member = (PsiMember)element;
                if (member.getName() == null) {
                    return true;
                }
                SmartList hints = new SmartList();
                if (settings.isShowUsages() && (usagesHint = JavaTelescope.usagesHint(member, file)) != null) {
                    hints.add(new InlResult(){

                        @Override
                        public void onClick(@NotNull Editor editor, @NotNull PsiElement element, MouseEvent event) {
                            FUCounterUsageLogger.getInstance().logEvent(file.getProject(), JavaLensProvider.FUS_GROUP_ID, JavaLensProvider.USAGES_CLICKED_EVENT_ID);
                            GotoDeclarationAction.startFindUsages((Editor)editor, (Project)file.getProject(), (PsiElement)element, (RelativePoint)new RelativePoint(event));
                        }

                        @Override
                        @NotNull
                        public String getRegularText() {
                            return usagesHint;
                        }
                    });
                }
                if (settings.isShowImplementations()) {
                    int overridings;
                    int inheritors;
                    if (element instanceof PsiClass && (inheritors = JavaTelescope.collectInheritingClasses((PsiClass)element)) != 0) {
                        hints.add(new InlResult(){

                            @Override
                            public void onClick(@NotNull Editor editor, @NotNull PsiElement element, MouseEvent event) {
                                FeatureUsageData data = new FeatureUsageData().addData("location", "class");
                                FUCounterUsageLogger.getInstance().logEvent(file.getProject(), JavaLensProvider.FUS_GROUP_ID, JavaLensProvider.IMPLEMENTATIONS_CLICKED_EVENT_ID, data);
                                GutterIconNavigationHandler<PsiElement> navigationHandler = MarkerType.SUBCLASSED_CLASS.getNavigationHandler();
                                navigationHandler.navigate(event, (PsiElement)((PsiClass)element).getNameIdentifier());
                            }

                            @Override
                            @NotNull
                            public String getRegularText() {
                                String prop = "{0, choice, 1#1 implementation|2#{0,number} implementations}";
                                return MessageFormat.format(prop, inheritors);
                            }
                        });
                    }
                    if (element instanceof PsiMethod && (overridings = JavaTelescope.collectOverridingMethods((PsiMethod)element)) != 0) {
                        hints.add(new InlResult(){

                            @Override
                            public void onClick(@NotNull Editor editor, @NotNull PsiElement element, MouseEvent event) {
                                FeatureUsageData data = new FeatureUsageData().addData("location", "method");
                                FUCounterUsageLogger.getInstance().logEvent(file.getProject(), JavaLensProvider.FUS_GROUP_ID, JavaLensProvider.IMPLEMENTATIONS_CLICKED_EVENT_ID, data);
                                GutterIconNavigationHandler<PsiElement> navigationHandler = MarkerType.OVERRIDDEN_METHOD.getNavigationHandler();
                                navigationHandler.navigate(event, (PsiElement)((PsiMethod)element).getNameIdentifier());
                            }

                            @Override
                            @NotNull
                            public String getRegularText() {
                                String prop = "{0, choice, 1#1 implementation|2#{0,number} implementations}";
                                return MessageFormat.format(prop, overridings);
                            }
                        });
                    }
                }
                if (!hints.isEmpty()) {
                    PresentationFactory factory = this.getFactory();
                    Document document = editor.getDocument();
                    int offset = JavaLensProvider.getAnchorOffset(element);
                    int line = document.getLineNumber(offset);
                    int startOffset = document.getLineStartOffset(line);
                    int column = offset - startOffset;
                    SmartList presentations2 = new SmartList();
                    presentations2.add(factory.textSpacePlaceholder(column, true));
                    for (InlResult inlResult : hints) {
                        presentations2.add(JavaLensProvider.createPresentation(factory, element, editor, inlResult));
                        presentations2.add(factory.textSpacePlaceholder(1, true));
                    }
                    SequencePresentation shiftedPresentation = new SequencePresentation((List)presentations2);
                    InlayPresentation withSettings = JavaLensProvider.addSettings(element.getProject(), factory, (InlayPresentation)shiftedPresentation);
                    sink.addBlockElement(startOffset, true, true, 0, withSettings);
                }
                return true;
            }
        };
    }

    private static int getAnchorOffset(PsiElement element) {
        for (PsiElement child : element.getChildren()) {
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            return child.getTextRange().getStartOffset();
        }
        return element.getTextRange().getStartOffset();
    }

    @NotNull
    private static InlayPresentation createPresentation(@NotNull PresentationFactory factory, @NotNull PsiElement element, @NotNull Editor editor, @NotNull InlResult result) {
        InlayPresentation text2 = factory.smallText(result.getRegularText());
        return factory.referenceOnHover(text2, (event, translated) -> result.onClick(editor, element, event));
    }

    private static InlayPresentation addSettings(@NotNull Project project, @NotNull PresentationFactory factory, @NotNull InlayPresentation presentation) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem(JavaBundle.message((String)"button.text.settings", (Object[])new Object[0]));
        item.addActionListener(e -> {
            FUCounterUsageLogger.getInstance().logEvent(project, FUS_GROUP_ID, SETTING_CLICKED_EVENT_ID);
            JavaLensProvider.openSettings((Language)JavaLanguage.INSTANCE, project);
        });
        popupMenu.add(item);
        return factory.onClick(presentation, MouseButton.Right, (e, __) -> {
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
            return Unit.INSTANCE;
        });
    }

    public static void openSettings(@NotNull Language language, @NotNull Project project) {
        InlayHintsConfigurable.showSettingsDialogForLanguage((Project)project, (Language)language, model -> model.getId().equals(CODE_LENS_ID));
    }

    public static JavaLensSettings getSettings() {
        return (JavaLensSettings)InlayHintsSettings.instance().findSettings(KEY, (Language)JavaLanguage.INSTANCE, JavaLensSettings::new);
    }

    @NotNull
    public JavaLensSettings createSettings() {
        return new JavaLensSettings();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        return JavaBundle.message((String)"title.lenses", (Object[])new Object[0]);
    }

    @NotNull
    public SettingsKey<JavaLensSettings> getKey() {
        return KEY;
    }

    @Nullable
    public String getPreviewText() {
        return null;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull JavaLensSettings settings) {
        return new JavaLensConfigurable(settings);
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        return true;
    }

    public boolean isVisibleInSettings() {
        return false;
    }

    public static interface InlResult {
        public void onClick(@NotNull Editor var1, @NotNull PsiElement var2, MouseEvent var3);

        @NotNull
        public String getRegularText();
    }
}

