/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JavaProblemHighlightFilter
extends ProblemHighlightFilter {
    public boolean shouldHighlight(@NotNull PsiFile psiFile) {
        return psiFile.getFileType() != JavaFileType.INSTANCE || !JavaProjectRootsUtil.isOutsideJavaSourceRoot(psiFile) || ScratchUtil.isScratch((VirtualFile)psiFile.getVirtualFile());
    }

    public boolean shouldProcessInBatch(@NotNull PsiFile psiFile) {
        ProjectFileIndex fileIndex;
        VirtualFile virtualFile;
        boolean shouldHighlight = JavaProblemHighlightFilter.shouldHighlightFile((PsiFile)psiFile);
        if (shouldHighlight && psiFile.getFileType() == JavaFileType.INSTANCE && (virtualFile = psiFile.getVirtualFile()) != null && (fileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex()).isInLibrarySource(virtualFile)) {
            return fileIndex.isInSourceContent(virtualFile);
        }
        return shouldHighlight;
    }
}

