/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.scope;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionElement {
    private final Object myElement;
    private final PsiSubstitutor mySubstitutor;
    private final Object myEqualityObject;
    private final String myQualifierText;
    @Nullable
    private final PsiType myMethodRefType;

    public CompletionElement(Object element, PsiSubstitutor substitutor) {
        this(element, substitutor, "", null);
    }

    CompletionElement(Object element, PsiSubstitutor substitutor, @NotNull String qualifierText, @Nullable PsiType methodRefType) {
        this.myElement = element;
        this.mySubstitutor = substitutor;
        this.myQualifierText = qualifierText;
        this.myMethodRefType = methodRefType;
        this.myEqualityObject = this.getUniqueId();
    }

    @NotNull
    public String getQualifierText() {
        return this.myQualifierText;
    }

    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    public Object getElement() {
        return this.myElement;
    }

    @Nullable
    private Object getUniqueId() {
        if (this.myElement instanceof PsiClass) {
            String qName = ((PsiClass)this.myElement).getQualifiedName();
            return qName == null ? ((PsiClass)this.myElement).getName() : qName;
        }
        if (this.myElement instanceof PsiPackage) {
            return ((PsiPackage)this.myElement).getQualifiedName();
        }
        if (this.myElement instanceof PsiMethod) {
            if (this.myMethodRefType != null) {
                return ((PsiMethod)this.myElement).isConstructor() ? "new" : ((PsiMethod)this.myElement).getName();
            }
            return Trinity.create((Object)((PsiMethod)this.myElement).getName(), Arrays.asList(MethodSignatureUtil.calcErasedParameterTypes((MethodSignature)((PsiMethod)this.myElement).getSignature(this.mySubstitutor))), (Object)this.myQualifierText);
        }
        if (this.myElement instanceof PsiVariable) {
            return CompletionUtilCoreImpl.getOriginalOrSelf((PsiElement)((PsiElement)this.myElement));
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompletionElement)) {
            return false;
        }
        Object thatObj = ((CompletionElement)obj).myEqualityObject;
        if (this.myEqualityObject instanceof MethodSignature) {
            return thatObj instanceof MethodSignature && MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.equals((Object)((MethodSignature)this.myEqualityObject), (Object)((MethodSignature)thatObj));
        }
        return Comparing.equal((Object)this.myEqualityObject, (Object)thatObj);
    }

    public int hashCode() {
        if (this.myEqualityObject instanceof MethodSignature) {
            return MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.computeHashCode((Object)((MethodSignature)this.myEqualityObject));
        }
        return this.myEqualityObject != null ? this.myEqualityObject.hashCode() : 0;
    }

    @Nullable
    @ApiStatus.Internal
    public PsiType getMethodRefType() {
        return this.myMethodRefType;
    }

    public boolean isMoreSpecificThan(@NotNull CompletionElement another) {
        Object anotherElement = another.getElement();
        if (!(anotherElement instanceof PsiMethod) || !(this.myElement instanceof PsiMethod)) {
            return false;
        }
        if (another.myMethodRefType instanceof PsiMethodReferenceType && this.myMethodRefType instanceof PsiClassType) {
            return true;
        }
        if (anotherElement != this.myElement && ((PsiMethod)this.myElement).hasModifierProperty("abstract") && !((PsiMethod)anotherElement).hasModifierProperty("abstract")) {
            return false;
        }
        PsiType prevType = TypeConversionUtil.erasure((PsiType)another.getSubstitutor().substitute(((PsiMethod)anotherElement).getReturnType()));
        PsiType candidateType = this.mySubstitutor.substitute(((PsiMethod)this.myElement).getReturnType());
        return prevType != null && candidateType != null && !prevType.equals(candidateType) && prevType.isAssignableFrom(candidateType);
    }
}

