/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.simple.RParenthTailType;
import com.intellij.codeInsight.completion.util.CompletionStyleUtil;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.java.PsiEmptyExpressionImpl;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class SmartCastProvider {
    SmartCastProvider() {
    }

    static boolean shouldSuggestCast(CompletionParameters parameters2) {
        PsiElement position = parameters2.getPosition();
        PsiElement parent = SmartCastProvider.getParenthesisOwner(position);
        if (parent instanceof PsiTypeCastExpression) {
            return true;
        }
        if (parent instanceof PsiParenthesizedExpression) {
            return parameters2.getOffset() == position.getTextRange().getStartOffset();
        }
        return false;
    }

    private static PsiElement getParenthesisOwner(PsiElement position) {
        PsiElement lParen = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        return lParen == null || !lParen.textMatches((CharSequence)"(") ? null : lParen.getParent();
    }

    static void addCastVariants(@NotNull CompletionParameters parameters2, PrefixMatcher matcher, @NotNull Consumer<? super LookupElement> result, boolean quick) {
        PsiElement parent;
        if (!SmartCastProvider.shouldSuggestCast(parameters2)) {
            return;
        }
        PsiElement position = parameters2.getPosition();
        PsiElement parenthesisOwner = SmartCastProvider.getParenthesisOwner(position);
        boolean insideCast = parenthesisOwner instanceof PsiTypeCastExpression;
        if (insideCast && (parent = parenthesisOwner.getParent()) instanceof PsiParenthesizedExpression) {
            if (parent.getParent() instanceof PsiReferenceExpression) {
                for (ExpectedTypeInfo info : ExpectedTypesProvider.getExpectedTypes((PsiExpression)((PsiParenthesizedExpression)parent), false)) {
                    result.consume((Object)PsiTypeLookupItem.createLookupItem(info.getType(), parent));
                }
            }
            for (ExpectedTypeInfo info : SmartCastProvider.getParenthesizedCastExpectationByOperandType(position)) {
                SmartCastProvider.addHierarchyTypes(parameters2, matcher, info, (Consumer<? super PsiType>)((Consumer)type2 -> result.consume((Object)PsiTypeLookupItem.createLookupItem(type2, parent))), quick);
            }
            return;
        }
        for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters2)) {
            PsiClassType boxedType;
            PsiType castedType;
            PsiType type3 = info.getDefaultType();
            if (type3 instanceof PsiWildcardType) {
                type3 = ((PsiWildcardType)type3).getBound();
            }
            if (type3 == null || PsiType.VOID.equals((Object)type3)) continue;
            if (type3 instanceof PsiPrimitiveType && (castedType = SmartCastProvider.getCastedExpressionType(parenthesisOwner)) != null && !(castedType instanceof PsiPrimitiveType) && (boxedType = ((PsiPrimitiveType)type3).getBoxedType(position)) != null) {
                type3 = boxedType;
            }
            result.consume((Object)SmartCastProvider.createSmartCastElement(parameters2, insideCast, type3));
        }
    }

    @NotNull
    static List<ExpectedTypeInfo> getParenthesizedCastExpectationByOperandType(PsiElement position) {
        PsiElement parenthesisOwner = SmartCastProvider.getParenthesisOwner(position);
        PsiExpression operand2 = SmartCastProvider.getCastedExpression(parenthesisOwner);
        if (operand2 == null || !(parenthesisOwner.getParent() instanceof PsiParenthesizedExpression)) {
            return Collections.emptyList();
        }
        List<PsiType> dfaTypes = GuessManager.getInstance(operand2.getProject()).getControlFlowExpressionTypeConjuncts(operand2);
        if (!dfaTypes.isEmpty()) {
            return ContainerUtil.map(dfaTypes, dfaType -> new ExpectedTypeInfoImpl((PsiType)dfaType, 2, (PsiType)dfaType, TailType.NONE, null, (NullableComputable<String>)((NullableComputable)() -> null)));
        }
        PsiType type2 = operand2.getType();
        return type2 == null || type2.equalsToText("java.lang.Object") ? Collections.emptyList() : Collections.singletonList(new ExpectedTypeInfoImpl(type2, 1, type2, TailType.NONE, null, (NullableComputable<String>)((NullableComputable)() -> null)));
    }

    private static void addHierarchyTypes(CompletionParameters parameters2, PrefixMatcher matcher, ExpectedTypeInfo info, Consumer<? super PsiType> result, boolean quick) {
        PsiType infoType = info.getType();
        PsiClass infoClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)infoType);
        if (info.getKind() == 2) {
            InheritanceUtil.processSupers((PsiClass)infoClass, (boolean)true, superClass -> {
                if (!"java.lang.Object".equals(superClass.getQualifiedName())) {
                    result.consume((Object)JavaPsiFacade.getElementFactory((Project)superClass.getProject()).createType((PsiClass)CompletionUtil.getOriginalOrSelf((PsiElement)superClass)));
                }
                return true;
            });
        } else if (infoType instanceof PsiClassType && !quick) {
            JavaInheritorsGetter.processInheritors(parameters2, Collections.singleton((PsiClassType)infoType), matcher, (Consumer<? super PsiType>)((Consumer)type2 -> {
                if (!infoType.equals(type2)) {
                    result.consume(type2);
                }
            }));
        }
    }

    private static PsiType getCastedExpressionType(PsiElement parenthesisOwner) {
        PsiExpression operand2 = SmartCastProvider.getCastedExpression(parenthesisOwner);
        return operand2 == null ? null : operand2.getType();
    }

    private static PsiExpression getCastedExpression(PsiElement parenthesisOwner) {
        if (parenthesisOwner instanceof PsiTypeCastExpression) {
            return ((PsiTypeCastExpression)parenthesisOwner).getOperand();
        }
        if (parenthesisOwner instanceof PsiParenthesizedExpression) {
            PsiElement next = parenthesisOwner.getNextSibling();
            while (next instanceof PsiEmptyExpressionImpl || next instanceof PsiErrorElement || next instanceof PsiWhiteSpace) {
                next = next.getNextSibling();
            }
            if (next instanceof PsiExpression) {
                return (PsiExpression)next;
            }
        }
        return null;
    }

    private static LookupElement createSmartCastElement(final CompletionParameters parameters2, final boolean overwrite, PsiType type2) {
        return AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE.applyPolicy((LookupElement)new LookupElementDecorator<PsiTypeLookupItem>(PsiTypeLookupItem.createLookupItem(type2, parameters2.getPosition())){

            public void handleInsert(@NotNull InsertionContext context) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.casting");
                Editor editor = context.getEditor();
                Document document = editor.getDocument();
                if (overwrite) {
                    document.deleteString(context.getSelectionEndOffset(), context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET));
                }
                CommonCodeStyleSettings csSettings = CompletionStyleUtil.getCodeStyleSettings((InsertionContext)context);
                int oldTail = context.getTailOffset();
                context.setTailOffset(RParenthTailType.addRParenth(editor, oldTail, csSettings.SPACE_WITHIN_CAST_PARENTHESES));
                ((PsiTypeLookupItem)this.getDelegate()).handleInsert(CompletionUtil.newContext((InsertionContext)context, (LookupElement)this.getDelegate(), (int)context.getStartOffset(), (int)oldTail));
                PostprocessReformattingAspect.getInstance((Project)context.getProject()).doPostponedFormatting();
                if (csSettings.SPACE_AFTER_TYPE_CAST) {
                    context.setTailOffset(TailType.insertChar((Editor)editor, (int)context.getTailOffset(), (char)' '));
                }
                if (parameters2.getCompletionType() == CompletionType.SMART) {
                    editor.getCaretModel().moveToOffset(context.getTailOffset());
                }
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        });
    }
}

