/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionSorting;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.RecursionWeigher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementExtractorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.filters.types.AssignableFromFilter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceExpressionCompletionContributor {
    private static final Logger LOG = Logger.getInstance(ReferenceExpressionCompletionContributor.class);

    @NotNull
    static ElementFilter getReferenceFilter(PsiElement element, boolean allowRecursion) {
        ElementFilter filter;
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceExpression.class).withParent(PsiThrowStatement.class))).accepts((Object)element)) {
            return TrueFilter.INSTANCE;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiAnnotationParameterList.class), JavaCompletionContributor.IN_SWITCH_LABEL}))).accepts((Object)element)) {
            return new ElementExtractorFilter((ElementFilter)new AndFilter((ElementFilter)new ClassFilter(PsiField.class), (ElementFilter)new ModifierFilter("static", "final")));
        }
        final PsiForeachStatement foreach = (PsiForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiForeachStatement.class);
        if (foreach != null && !PsiTreeUtil.isAncestor((PsiElement)foreach.getBody(), (PsiElement)element, (boolean)false)) {
            return new ElementExtractorFilter(new ElementFilter(){

                public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                    return element != foreach.getIterationParameter();
                }

                public boolean isClassAcceptable(Class hintClass) {
                    return true;
                }
            });
        }
        if (!allowRecursion && (filter = RecursionWeigher.recursionFilter(element)) != null) {
            return new ElementExtractorFilter(filter);
        }
        return TrueFilter.INSTANCE;
    }

    static List<LookupElement> smartCompleteReference(List<LookupElement> allRefSuggestions, Set<ExpectedTypeInfo> infos) {
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        for (LookupElement item : allRefSuggestions) {
            if (!ReferenceExpressionCompletionContributor.matchesExpectedType(item, infos)) continue;
            if (item instanceof JavaMethodCallElement) {
                ReferenceExpressionCompletionContributor.checkTooGeneric((JavaMethodCallElement)item);
            }
            result.add((LookupElement)JavaSmartCompletionContributor.decorate(item, infos));
        }
        return result;
    }

    static boolean matchesExpectedType(LookupElement item, Set<ExpectedTypeInfo> infos) {
        return ContainerUtil.exists(infos, info -> ReferenceExpressionCompletionContributor.matchesExpectedType(item, info.getType()));
    }

    private static boolean matchesExpectedType(LookupElement item, PsiType type2) {
        Object object = item.getObject();
        if (object instanceof PsiClass) {
            return false;
        }
        if (PsiType.VOID.equals((Object)type2)) {
            return object instanceof PsiMethod;
        }
        PsiType itemType = JavaCompletionUtil.getLookupElementType(item);
        return itemType != null && type2.isAssignableFrom(itemType);
    }

    static Set<LookupElement> completeFinalReference(final PsiElement element, PsiJavaCodeReferenceElement reference, ElementFilter filter, final PsiType expectedType, CompletionParameters parameters2) {
        final Set<Object> used = parameters2.getInvocationCount() < 2 ? ReferenceExpressionCompletionContributor.findConstantsUsedInSwitch(element) : Collections.emptySet();
        Set<LookupElement> elements = JavaSmartCompletionContributor.completeReference(element, reference, (ElementFilter)new AndFilter(filter, new ElementFilter(){

            public boolean isAcceptable(Object o, PsiElement context) {
                if (o instanceof CandidateInfo) {
                    CandidateInfo info = (CandidateInfo)o;
                    PsiElement member = info.getElement();
                    if (expectedType.equals(PsiType.VOID)) {
                        return member instanceof PsiMethod;
                    }
                    if (member instanceof PsiEnumConstant && used.contains(CompletionUtil.getOriginalOrSelf((PsiElement)member))) {
                        return false;
                    }
                    return AssignableFromFilter.isAcceptable(member, element, expectedType, info.getSubstitutor());
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }), false, true, parameters2, PrefixMatcher.ALWAYS_TRUE);
        for (LookupElement lookupElement : elements) {
            JavaMethodCallElement item;
            if (!(lookupElement.getObject() instanceof PsiMethod) || (item = (JavaMethodCallElement)lookupElement.as(JavaMethodCallElement.CLASS_CONDITION_KEY)) == null) continue;
            item.setInferenceSubstitutorFromExpectedType(element, expectedType);
            ReferenceExpressionCompletionContributor.checkTooGeneric(item);
        }
        return elements;
    }

    private static void checkTooGeneric(JavaMethodCallElement item) {
        if (JavaCompletionSorting.isTooGeneric((LookupElement)item, (PsiMethod)item.getObject())) {
            item.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        }
    }

    @NotNull
    public static Set<PsiField> findConstantsUsedInSwitch(@Nullable PsiElement position) {
        return JavaCompletionContributor.IN_SWITCH_LABEL.accepts((Object)position) ? ReferenceExpressionCompletionContributor.findConstantsUsedInSwitch((PsiSwitchBlock)Objects.requireNonNull(PsiTreeUtil.getParentOfType((PsiElement)position, PsiSwitchBlock.class))) : Collections.emptySet();
    }

    @NotNull
    public static Set<PsiField> findConstantsUsedInSwitch(@NotNull PsiSwitchBlock sw) {
        PsiCodeBlock body2 = sw.getBody();
        if (body2 == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<PsiField> used = new LinkedHashSet<PsiField>();
        for (PsiStatement statement : body2.getStatements()) {
            PsiExpressionList values;
            if (!(statement instanceof PsiSwitchLabelStatementBase) || (values = ((PsiSwitchLabelStatementBase)statement).getCaseValues()) == null) continue;
            for (PsiExpression value2 : values.getExpressions()) {
                PsiElement target;
                if (!(value2 instanceof PsiReferenceExpression) || !((target = ((PsiReferenceExpression)value2).resolve()) instanceof PsiField)) continue;
                used.add((PsiField)CompletionUtil.getOriginalOrSelf((PsiElement)((PsiField)target)));
            }
        }
        return used;
    }

    static PsiExpression createExpression(String text2, PsiElement element) {
        return JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText(text2, element);
    }

    static String getQualifierText(@Nullable PsiElement qualifier) {
        return qualifier == null ? "" : qualifier.getText() + ".";
    }

    @Nullable
    static PsiReferenceExpression createMockReference(PsiElement place, @NotNull PsiType qualifierType, LookupElement qualifierItem) {
        return ReferenceExpressionCompletionContributor.createMockReference(place, qualifierType, qualifierItem, ".");
    }

    @Nullable
    static PsiReferenceExpression createMockReference(PsiElement place, @NotNull PsiType qualifierType, LookupElement qualifierItem, String separator) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getProject());
        if (qualifierItem.getObject() instanceof PsiClass) {
            String qname = ((PsiClass)qualifierItem.getObject()).getQualifiedName();
            if (qname == null) {
                return null;
            }
            String text2 = qname + separator + "xxx";
            try {
                PsiExpression expr2 = factory.createExpressionFromText(text2, place);
                if (expr2 instanceof PsiReferenceExpression) {
                    return (PsiReferenceExpression)expr2;
                }
                return null;
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        return (PsiReferenceExpression)factory.createExpressionFromText("xxx" + separator + "xxx", (PsiElement)JavaCompletionUtil.createContextWithXxxVariable(place, qualifierType));
    }

    static String getSpace(boolean needSpace) {
        return needSpace ? " " : "";
    }
}

