/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLookupElementBuilder {
    private JavaLookupElementBuilder() {
    }

    public static LookupElementBuilder forField(@NotNull PsiField field) {
        return JavaLookupElementBuilder.forField(field, field.getName(), null);
    }

    public static LookupElementBuilder forField(@NotNull PsiField field, String lookupString, @Nullable PsiClass qualifierClass) {
        LookupElementBuilder builder = LookupElementBuilder.create((Object)field, (String)lookupString).withIcon(field.getIcon(1));
        return JavaLookupElementBuilder.setBoldIfInClass((PsiMember)field, qualifierClass, builder);
    }

    public static LookupElementBuilder forMethod(@NotNull PsiMethod method, PsiSubstitutor substitutor) {
        return JavaLookupElementBuilder.forMethod(method, method.getName(), substitutor, null);
    }

    public static LookupElementBuilder forMethod(@NotNull PsiMethod method, @NotNull String lookupString, @NotNull PsiSubstitutor substitutor, @Nullable PsiClass qualifierClass) {
        LookupElementBuilder builder = LookupElementBuilder.create((Object)method, (String)lookupString).withIcon(method.getIcon(1)).withPresentableText(method.getName()).withTailText(PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)substitutor, (int)256, (int)3));
        PsiType returnType = method.getReturnType();
        if (returnType != null) {
            builder = builder.withTypeText(substitutor.substitute(returnType).getPresentableText());
        }
        builder = JavaLookupElementBuilder.setBoldIfInClass((PsiMember)method, qualifierClass, builder);
        return builder;
    }

    private static LookupElementBuilder setBoldIfInClass(@NotNull PsiMember member, @Nullable PsiClass psiClass, @NotNull LookupElementBuilder builder) {
        if (psiClass != null && member.getManager().areElementsEquivalent((PsiElement)member.getContainingClass(), (PsiElement)psiClass)) {
            return builder.bold();
        }
        return builder;
    }

    public static LookupElementBuilder forClass(@NotNull PsiClass psiClass) {
        return JavaLookupElementBuilder.forClass(psiClass, psiClass.getName());
    }

    public static LookupElementBuilder forClass(@NotNull PsiClass psiClass, String lookupString) {
        return JavaLookupElementBuilder.forClass(psiClass, lookupString, false);
    }

    public static LookupElementBuilder forClass(@NotNull PsiClass psiClass, String lookupString, boolean withLocation) {
        LookupElementBuilder builder = LookupElementBuilder.create((Object)psiClass, (String)lookupString).withIcon(psiClass.getIcon(1));
        String name2 = psiClass.getName();
        if (StringUtil.isNotEmpty((String)name2)) {
            builder = builder.withLookupString(name2);
        }
        if (withLocation) {
            return builder.withTailText(" (" + PsiFormatUtil.getPackageDisplayName((PsiClass)psiClass) + ")", true);
        }
        return builder;
    }
}

