/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionStatistician;
import com.intellij.codeInsight.completion.FunctionalExpressionCompletionProvider;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.PreferByKindWeigher;
import com.intellij.codeInsight.completion.RecursionWeigher;
import com.intellij.codeInsight.completion.StreamConversion;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionStatistician
extends CompletionStatistician {
    private static final ElementPattern<PsiElement> SUPER_CALL = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(".")).afterLeaf(new String[]{"super"}));

    public StatisticsInfo serialize(@NotNull LookupElement element, @NotNull CompletionLocation location) {
        Object o = element.getObject();
        if (o instanceof PsiLocalVariable || o instanceof PsiParameter || o instanceof PsiThisExpression || o instanceof PsiKeyword || element.getUserData(JavaCompletionUtil.SUPER_METHOD_PARAMETERS) != null || FunctionalExpressionCompletionProvider.isFunExprItem(element) || element.as(StreamConversion.StreamMethodInvocation.class) != null) {
            return StatisticsInfo.EMPTY;
        }
        if (!(o instanceof PsiMember)) {
            return null;
        }
        PsiElement position = location.getCompletionParameters().getPosition();
        if (SUPER_CALL.accepts((Object)position) || JavaCompletionContributor.IN_SWITCH_LABEL.accepts((Object)position) || PreferByKindWeigher.isComparisonRhs(position)) {
            return StatisticsInfo.EMPTY;
        }
        ExpectedTypeInfo firstInfo = JavaCompletionStatistician.getExpectedTypeInfo(location);
        if (firstInfo != null && JavaCompletionStatistician.isInEnumAnnotationParameter(position, firstInfo)) {
            return StatisticsInfo.EMPTY;
        }
        if (o instanceof PsiClass) {
            return JavaCompletionStatistician.getClassInfo((PsiClass)o, position, firstInfo);
        }
        return JavaCompletionStatistician.getFieldOrMethodInfo((PsiMember)o, element, firstInfo);
    }

    private static boolean isInEnumAnnotationParameter(PsiElement position, ExpectedTypeInfo firstInfo) {
        return PsiTreeUtil.getParentOfType((PsiElement)position, PsiNameValuePair.class) != null && PreferByKindWeigher.isEnumClass(firstInfo);
    }

    @Nullable
    private static ExpectedTypeInfo getExpectedTypeInfo(CompletionLocation location) {
        ExpectedTypeInfo[] infos = (ExpectedTypeInfo[])JavaCompletionUtil.EXPECTED_TYPES.getValue((UserDataHolder)location);
        return infos != null && infos.length > 0 ? infos[0] : null;
    }

    private static StatisticsInfo getClassInfo(PsiClass psiClass, PsiElement position, @Nullable ExpectedTypeInfo firstInfo) {
        PsiType expectedType;
        if (PreferByKindWeigher.isInMethodTypeArg(position)) {
            return StatisticsInfo.EMPTY;
        }
        PsiType psiType = expectedType = firstInfo != null ? firstInfo.getDefaultType() : null;
        String context = JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)position) ? JavaStatisticsManager.getAfterNewKey((PsiType)expectedType) : (PreferByKindWeigher.isExceptionPosition(position) ? "exception" : "");
        return new StatisticsInfo(context, JavaStatisticsManager.getMemberUseKey2((PsiMember)psiClass));
    }

    @Nullable
    private static StatisticsInfo getFieldOrMethodInfo(PsiMember member, LookupElement item, @Nullable ExpectedTypeInfo firstInfo) {
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String expectedName = firstInfo instanceof ExpectedTypeInfoImpl ? ((ExpectedTypeInfoImpl)firstInfo).getExpectedName() : null;
        PsiType qualifierType = JavaCompletionUtil.getQualifierType(item);
        String contextPrefix = (qualifierType == null ? "" : JavaStatisticsManager.getMemberUseKey1((PsiType)qualifierType) + "###") + (expectedName == null ? "" : "expectedName=" + expectedName + "###");
        if (member instanceof PsiMethod) {
            String memberValue = JavaStatisticsManager.getMemberUseKey2((PsiMember)RecursionWeigher.findDeepestSuper((PsiMethod)member));
            return new StatisticsInfo(contextPrefix, memberValue);
        }
        return new StatisticsInfo(contextPrefix, JavaStatisticsManager.getMemberUseKey2((PsiMember)member));
    }
}

