/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class ChainedCallCompletion {
    static final PsiMethodPattern OBJECT_METHOD_PATTERN = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"hashCode", "equals", "finalize", "wait", "notify", "notifyAll", "getClass", "clone", "toString"}))).definedInClass("java.lang.Object");

    ChainedCallCompletion() {
    }

    static void addChains(PsiElement place, LookupElement qualifierItem, Consumer<? super LookupElement> result, PsiType qualifierType, PsiType expectedType, JavaSmartCompletionParameters parameters2) throws IncorrectOperationException {
        Object object = qualifierItem.getObject();
        if (OBJECT_METHOD_PATTERN.accepts(object) && !ChainedCallCompletion.allowGetClass(object, parameters2)) {
            return;
        }
        if (parameters2.getParameters().getInvocationCount() < 3 && qualifierType.equalsToText("java.lang.String")) {
            return;
        }
        if (object instanceof PsiMethod && !((PsiMethod)object).getParameterList().isEmpty()) {
            return;
        }
        PsiReferenceExpression mockRef = ReferenceExpressionCompletionContributor.createMockReference(place, qualifierType, qualifierItem);
        if (mockRef == null) {
            return;
        }
        ElementFilter filter = ReferenceExpressionCompletionContributor.getReferenceFilter(place, true);
        for (LookupElement item : ReferenceExpressionCompletionContributor.completeFinalReference(place, (PsiJavaCodeReferenceElement)mockRef, filter, expectedType, parameters2.getParameters())) {
            if (!ChainedCallCompletion.shouldChain(place, qualifierType, expectedType, item)) continue;
            result.consume((Object)new JavaChainLookupElement(qualifierItem, item){

                @Override
                public void handleInsert(@NotNull InsertionContext context) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.smarttype.chain");
                    super.handleInsert(context);
                }
            });
        }
    }

    private static boolean shouldChain(PsiElement element, PsiType qualifierType, PsiType expectedType, LookupElement item) {
        Object object = item.getObject();
        if (object instanceof PsiModifierListOwner && ((PsiModifierListOwner)object).hasModifierProperty("static")) {
            return false;
        }
        if (object instanceof PsiMethod) {
            PsiClassType classType;
            PsiClass psiClass;
            PsiMethod method = (PsiMethod)object;
            if (((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("toArray")).withParameterCount(1).definedInClass("java.util.Collection").accepts((Object)method)) {
                return false;
            }
            PsiMethod parentMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (ChainedCallCompletion.isUselessObjectMethod(method, parentMethod, qualifierType)) {
                return false;
            }
            PsiType type2 = method.getReturnType();
            if (type2 instanceof PsiClassType && (psiClass = (classType = (PsiClassType)type2).resolve()) instanceof PsiTypeParameter && method.getTypeParameterList() == psiClass.getParent()) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)psiClass;
                if (typeParameter.getExtendsListTypes().length == 0) {
                    return false;
                }
                if (!expectedType.isAssignableFrom(TypeConversionUtil.typeParameterErasure((PsiTypeParameter)typeParameter))) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isUselessObjectMethod(PsiMethod method, PsiMethod parentMethod, PsiType qualifierType) {
        if (!OBJECT_METHOD_PATTERN.accepts((Object)method)) {
            return false;
        }
        if (OBJECT_METHOD_PATTERN.accepts((Object)parentMethod) && method.getName().equals(parentMethod.getName())) {
            return false;
        }
        return !"toString".equals(method.getName()) || !qualifierType.equalsToText("java.lang.StringBuffer") && !InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.lang.AbstractStringBuilder");
    }

    private static boolean allowGetClass(Object object, JavaSmartCompletionParameters parameters2) {
        if (!"getClass".equals(((PsiMethod)object).getName())) {
            return false;
        }
        PsiType type2 = parameters2.getDefaultType();
        String canonicalText = type2.getCanonicalText();
        if ("java.lang.ClassLoader".equals(canonicalText)) {
            return true;
        }
        return canonicalText.startsWith("java.lang.reflect.");
    }
}

