/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.annoPackages;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.annoPackages.AnnotationPackageSupport;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiAnnotation;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeAnalysisAnnotationSupport
implements AnnotationPackageSupport {
    private static final String PACKAGE_NAME = "codeanalysis.experimental.annotations";
    private static final String NULLABLE = "codeanalysis.experimental.annotations.Nullable";
    private static final String NOT_NULL = "codeanalysis.experimental.annotations.NotNull";
    private static final String NULLNESS_UNKNOWN = "codeanalysis.experimental.annotations.NullnessUnknown";
    private static final String DEFAULT_NULLABLE = "codeanalysis.experimental.annotations.DefaultNullable";
    private static final String DEFAULT_NOT_NULL = "codeanalysis.experimental.annotations.DefaultNotNull";
    private static final String DEFAULT_NULLNESS_UNKNOWN = "codeanalysis.experimental.annotations.DefaultNullnessUnknown";

    private static boolean isAvailable() {
        return Registry.is((String)"java.codeanalysis.annotations.available");
    }

    @Override
    @Nullable
    public NullabilityAnnotationInfo getNullabilityByContainerAnnotation(@NotNull PsiAnnotation anno, // Could not load outer class - annotation placement on inner may be incorrect
    PsiAnnotation.TargetType @NotNull [] types, boolean superPackage) {
        Nullability nullability;
        if (!CodeAnalysisAnnotationSupport.isAvailable()) {
            return null;
        }
        if (superPackage) {
            return null;
        }
        String name2 = anno.getQualifiedName();
        if (name2 == null) {
            return null;
        }
        if (ArrayUtil.contains((Object)PsiAnnotation.TargetType.LOCAL_VARIABLE, (Object[])types)) {
            return null;
        }
        switch (name2) {
            case "codeanalysis.experimental.annotations.DefaultNullable": {
                nullability = Nullability.NULLABLE;
                break;
            }
            case "codeanalysis.experimental.annotations.DefaultNotNull": {
                nullability = Nullability.NOT_NULL;
                break;
            }
            case "codeanalysis.experimental.annotations.DefaultNullnessUnknown": {
                nullability = Nullability.UNKNOWN;
                break;
            }
            default: {
                return null;
            }
        }
        return new NullabilityAnnotationInfo(anno, nullability, true);
    }

    @Override
    @NotNull
    public List<String> getNullabilityAnnotations(@NotNull Nullability nullability) {
        if (!CodeAnalysisAnnotationSupport.isAvailable()) {
            return Collections.emptyList();
        }
        switch (nullability) {
            case NOT_NULL: {
                return Collections.singletonList(NOT_NULL);
            }
            case NULLABLE: {
                return Collections.singletonList(NULLABLE);
            }
        }
        return Collections.singletonList(NULLNESS_UNKNOWN);
    }
}

