/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.DefaultInferredAnnotationProvider;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.inferNullity.InferNullityAnnotationsAction;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MakeInferredAnnotationExplicit
extends BaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.family.make.inferred.annotations.explicit", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        if (leaf == null) {
            return false;
        }
        PsiModifierListOwner owner2 = (PsiModifierListOwner)ObjectUtils.tryCast((Object)leaf.getParent(), PsiModifierListOwner.class);
        return this.isAvailable(project, file, owner2);
    }

    public boolean isAvailable(@NotNull Project project, PsiFile file, PsiModifierListOwner owner2) {
        String annotations;
        if (owner2 != null && owner2.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && MakeInferredAnnotationExplicit.isWritable(owner2) && ModuleUtilCore.findModuleForPsiElement((PsiElement)file) != null && PsiUtil.getLanguageLevel((PsiElement)file).isAtLeast(LanguageLevel.JDK_1_5) && !(annotations = ((StreamEx)StreamEx.of((Object[])InferredAnnotationsManager.getInstance((Project)project).findInferredAnnotations(owner2)).remove(DefaultInferredAnnotationProvider::isExperimentalInferredAnnotation)).map(MakeInferredAnnotationExplicit::getAnnotationPresentation).joining((CharSequence)" ")).isEmpty()) {
            this.setText(JavaBundle.message((String)"intention.text.insert.0.annotation", (Object[])new Object[]{annotations}));
            return true;
        }
        return false;
    }

    @NotNull
    private static String getAnnotationPresentation(PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement nameRef = MakeInferredAnnotationExplicit.correctAnnotation(annotation).getNameReferenceElement();
        String name2 = nameRef != null ? nameRef.getReferenceName() : annotation.getQualifiedName();
        return "@" + name2 + annotation.getParameterList().getText();
    }

    private static boolean isWritable(PsiModifierListOwner owner2) {
        if (owner2 instanceof PsiCompiledElement) {
            return false;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)owner2);
        return vFile != null && vFile.isInLocalFileSystem();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        assert (leaf != null);
        PsiModifierListOwner owner2 = (PsiModifierListOwner)ObjectUtils.tryCast((Object)leaf.getParent(), PsiModifierListOwner.class);
        assert (owner2 != null);
        this.makeAnnotationsExplicit(project, file, owner2);
    }

    public void makeAnnotationsExplicit(@NotNull Project project, PsiFile file, PsiModifierListOwner owner2) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)owner2)) {
            return;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        for (PsiAnnotation inferred : InferredAnnotationsManager.getInstance((Project)project).findInferredAnnotations(owner2)) {
            if (DefaultInferredAnnotationProvider.isExperimentalInferredAnnotation(inferred)) continue;
            PsiAnnotation toInsert = MakeInferredAnnotationExplicit.correctAnnotation(inferred);
            String qname = toInsert.getQualifiedName();
            assert (qname != null);
            if (facade.findClass(qname, file.getResolveScope()) == null && !InferNullityAnnotationsAction.addAnnotationsDependency(project, Collections.singleton(module), qname, this.getFamilyName())) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getFamilyName(), null, () -> DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
                PsiAnnotationOwner target = AnnotationTargetUtil.getTarget((PsiModifierListOwner)owner2, (String)qname);
                assert (target != null);
                PsiElement element = target.addAnnotation(qname).replace((PsiElement)toInsert);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(element);
            }), (PsiFile[])new PsiFile[]{file});
        }
    }

    @NotNull
    private static PsiAnnotation correctAnnotation(@NotNull PsiAnnotation annotation) {
        Project project = annotation.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        NullableNotNullManager nnnm = NullableNotNullManager.getInstance((Project)project);
        if ("org.jetbrains.annotations.Nullable".equals(annotation.getQualifiedName()) && facade.findClass(nnnm.getDefaultNullable(), allScope) != null) {
            return facade.getElementFactory().createAnnotationFromText("@" + nnnm.getDefaultNullable(), null);
        }
        if ("org.jetbrains.annotations.NotNull".equals(annotation.getQualifiedName()) && facade.findClass(nnnm.getDefaultNotNull(), allScope) != null) {
            return facade.getElementFactory().createAnnotationFromText("@" + nnnm.getDefaultNotNull(), null);
        }
        return annotation;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

