/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.NonCodeAnnotationsLineMarkerProvider;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MakeExternalAnnotationExplicit
extends BaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.family.make.external.annotations.explicit", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        Object[] annotations;
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner owner2 = NonCodeAnnotationsLineMarkerProvider.getAnnotationOwner(leaf);
        if (owner2 != null && owner2.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && MakeExternalAnnotationExplicit.isWritable(owner2) && ModuleUtilCore.findModuleForPsiElement((PsiElement)file) != null && PsiUtil.getLanguageLevel((PsiElement)file).isAtLeast(LanguageLevel.JDK_1_5) && (annotations = this.getAnnotations(project, owner2)).length > 0) {
            String annos = StringUtil.join((Object[])annotations, annotation -> {
                PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
                String name2 = nameRef != null ? nameRef.getReferenceName() : annotation.getQualifiedName();
                return "@" + name2 + annotation.getParameterList().getText();
            }, (String)" ");
            this.setText(JavaBundle.message((String)"intention.text.insert.0.annotation", (Object[])new Object[]{annos}));
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner owner2 = NonCodeAnnotationsLineMarkerProvider.getAnnotationOwner(leaf);
        assert (owner2 != null);
        PsiModifierList modifierList = owner2.getModifierList();
        assert (modifierList != null);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        ExternalAnnotationsManager externalAnnotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(MakeExternalAnnotationExplicit.getFilesToWrite(file, owner2, externalAnnotationsManager))) {
            return;
        }
        for (PsiAnnotation anno : this.getAnnotations(project, owner2)) {
            String qname = anno.getQualifiedName();
            assert (qname != null);
            externalAnnotationsManager.deannotate(owner2, qname);
            WriteCommandAction.runWriteCommandAction((Project)project, () -> DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(modifierList.addAfter((PsiElement)anno, null))));
        }
    }

    public static List<PsiFile> getFilesToWrite(PsiFile file, PsiModifierListOwner owner2, ExternalAnnotationsManager externalAnnotationsManager) {
        List files = externalAnnotationsManager.findExternalAnnotationsFiles(owner2);
        if (files != null) {
            ArrayList<PsiFile> elements = new ArrayList<PsiFile>(files);
            elements.add(file);
            return elements;
        }
        return Collections.singletonList(file);
    }

    private PsiAnnotation @NotNull [] getAnnotations(@NotNull Project project, PsiModifierListOwner owner2) {
        PsiAnnotation[] annotations = ExternalAnnotationsManager.getInstance((Project)project).findExternalAnnotations(owner2);
        if (annotations == null) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        return (PsiAnnotation[])Arrays.stream(annotations).filter(anno -> {
            String qualifiedName = anno.getQualifiedName();
            return qualifiedName != null && facade.findClass(qualifiedName, owner2.getResolveScope()) != null && !owner2.hasAnnotation(qualifiedName);
        }).toArray(PsiAnnotation[]::new);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static boolean isWritable(PsiModifierListOwner owner2) {
        if (owner2 instanceof PsiCompiledElement) {
            return false;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)owner2);
        return vFile != null && vFile.isInLocalFileSystem();
    }
}

