/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.codeInsight.ExternalAnnotation;
import com.intellij.codeInsight.ExternalAnnotationsListener;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.ReadableExternalAnnotationsManager;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.OptionsMessageDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalAnnotationsManagerImpl
extends ReadableExternalAnnotationsManager {
    private static final Logger LOG = Logger.getInstance(ExternalAnnotationsManagerImpl.class);
    private final MessageBus myBus;

    public ExternalAnnotationsManagerImpl(@NotNull Project project) {
        super(PsiManager.getInstance((Project)project));
        this.myBus = project.getMessageBus();
        MessageBusConnection connection = this.myBus.connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                ExternalAnnotationsManagerImpl.this.dropAnnotationsCache();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    String name2;
                    if (!vFileEvent.isFromRefresh()) continue;
                    if (vFileEvent instanceof VFileCreateEvent) {
                        String name22 = ((VFileCreateEvent)vFileEvent).getChildName();
                    } else {
                        VirtualFile file = vFileEvent.getFile();
                        if (file == null) continue;
                        name2 = file.getName();
                    }
                    if (!vFileEvent.isFromRefresh() || !"annotations.xml".equals(name2)) continue;
                    ExternalAnnotationsManagerImpl.this.dropAnnotationsCache();
                    ExternalAnnotationsManagerImpl.this.notifyChangedExternally();
                }
            }
        });
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                ExternalAnnotationsManagerImpl.this.dropAnnotationsCache();
            }
        });
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)project);
    }

    private void notifyAfterAnnotationChanging(@NotNull PsiModifierListOwner owner2, @NotNull String annotationFQName, boolean successful) {
        ((ExternalAnnotationsListener)this.myBus.syncPublisher(TOPIC)).afterExternalAnnotationChanging(owner2, annotationFQName, successful);
        this.myPsiManager.dropPsiCaches();
    }

    private void notifyChangedExternally() {
        ((ExternalAnnotationsListener)this.myBus.syncPublisher(TOPIC)).externalAnnotationsChangedExternally();
        this.myPsiManager.dropPsiCaches();
    }

    @Override
    public void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @NotNull PsiFile fromFile, PsiNameValuePair @Nullable [] value2) throws ExternalAnnotationsManager.CanceledConfigurationException {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        LOG.assertTrue(!application.isWriteAccessAllowed());
        Project project = this.myPsiManager.getProject();
        PsiFile containingFile = listOwner.getOriginalElement().getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
            return;
        }
        VirtualFile containingVirtualFile = containingFile.getVirtualFile();
        LOG.assertTrue(containingVirtualFile != null);
        List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(containingVirtualFile);
        if (entries.isEmpty()) {
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
            return;
        }
        ExternalAnnotation annotation = new ExternalAnnotation(listOwner, annotationFQName, value2);
        for (OrderEntry entry : entries) {
            if (entry instanceof ModuleOrderEntry) continue;
            VirtualFile[] roots = AnnotationOrderRootType.getFiles((OrderEntry)entry);
            if ((roots = ExternalAnnotationsManagerImpl.filterByReadOnliness(roots)).length > 0) {
                this.chooseRootAndAnnotateExternally(roots, annotation);
                break;
            }
            if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
                this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
                return;
            }
            DumbService.getInstance((Project)project).runWithAlternativeResolveEnabled(() -> {
                if (!this.setupRootAndAnnotateExternally(entry, project, annotation)) {
                    throw new ExternalAnnotationsManager.CanceledConfigurationException();
                }
            });
            break;
        }
    }

    private void annotateExternally(@NotNull VirtualFile root, @NotNull ExternalAnnotation annotation) {
        this.annotateExternally(root, Collections.singletonList(annotation));
    }

    private void annotateExternally(@NotNull VirtualFile root, @NotNull List<? extends ExternalAnnotation> annotations) {
        final Project project = this.myPsiManager.getProject();
        final Map<Optional, List<ExternalAnnotation>> annotationsByFiles = annotations.stream().collect(Collectors.groupingBy(annotation -> Optional.ofNullable(this.getFileForAnnotations(root, annotation.getOwner(), project))));
        List files = StreamEx.ofKeys(annotationsByFiles).flatMap(StreamEx::of).map(PsiFile::getVirtualFile).nonNull().toList();
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable((Collection)files);
        if (status.hasReadonlyFiles()) {
            VirtualFile[] readonlyFiles = status.getReadonlyFiles();
            annotationsByFiles.keySet().removeIf(opt -> opt.map(PsiFile::getVirtualFile).filter(f -> ArrayUtil.contains((Object)f, (Object[])readonlyFiles)).isPresent());
        }
        if (annotationsByFiles.isEmpty()) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project).run((ThrowableRunnable)new ThrowableRunnable<RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws RuntimeException {
                if (project.isDisposed()) {
                    return;
                }
                if (DumbService.isDumb((Project)project)) {
                    DumbService.getInstance((Project)project).runWhenSmart(() -> WriteCommandAction.writeCommandAction((Project)project).run((ThrowableRunnable)this));
                    return;
                }
                try {
                    for (Map.Entry entry : annotationsByFiles.entrySet()) {
                        XmlFile annotationsFile = ((Optional)entry.getKey()).orElse(null);
                        List fileAnnotations = (List)entry.getValue();
                        ExternalAnnotationsManagerImpl.this.annotateExternally(annotationsFile, fileAnnotations);
                    }
                    UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

                        public void undo() {
                            ExternalAnnotationsManagerImpl.this.dropAnnotationsCache();
                            ExternalAnnotationsManagerImpl.this.notifyChangedExternally();
                        }

                        public void redo() {
                            ExternalAnnotationsManagerImpl.this.dropAnnotationsCache();
                            ExternalAnnotationsManagerImpl.this.notifyChangedExternally();
                        }
                    });
                }
                finally {
                    ExternalAnnotationsManagerImpl.this.dropAnnotationsCache();
                }
            }
        });
    }

    private void dropAnnotationsCache() {
        this.dropCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotateExternally(@Nullable XmlFile annotationsFile, @NotNull List<ExternalAnnotation> annotations) {
        XmlTag rootTag = ExternalAnnotationsManagerImpl.extractRootTag(annotationsFile);
        TreeMap ownerToAnnotations = (TreeMap)((EntryStream)StreamEx.of(annotations).mapToEntry(annotation -> StringUtil.escapeXmlEntities((String)ExternalAnnotationsManagerImpl.getExternalName(annotation.getOwner())), Function.identity()).distinct()).grouping(() -> new TreeMap(Comparator.nullsFirst(Comparator.naturalOrder())));
        if (rootTag == null) {
            ownerToAnnotations.values().stream().flatMap(Collection::stream).forEach(annotation -> this.notifyAfterAnnotationChanging(annotation.getOwner(), annotation.getAnnotationFQName(), false));
            return;
        }
        ArrayList<ExternalAnnotation> savedAnnotations = new ArrayList<ExternalAnnotation>();
        XmlTag startTag = null;
        for (Map.Entry entry : ownerToAnnotations.entrySet()) {
            String ownerName = (String)entry.getKey();
            List annotationList = (List)entry.getValue();
            for (ExternalAnnotation annotation2 : annotationList) {
                if (ownerName == null) {
                    this.notifyAfterAnnotationChanging(annotation2.getOwner(), annotation2.getAnnotationFQName(), false);
                    continue;
                }
                try {
                    startTag = this.addAnnotation(rootTag, ownerName, annotation2, startTag);
                    savedAnnotations.add(annotation2);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    this.notifyAfterAnnotationChanging(annotation2.getOwner(), annotation2.getAnnotationFQName(), false);
                }
                finally {
                    this.dropAnnotationsCache();
                    ExternalAnnotationsManagerImpl.markForUndo(annotation2.getOwner().getContainingFile());
                }
            }
        }
        this.commitChanges(annotationsFile);
        savedAnnotations.forEach(annotation -> this.notifyAfterAnnotationChanging(annotation.getOwner(), annotation.getAnnotationFQName(), true));
    }

    @Contract(value="null -> null")
    private static XmlTag extractRootTag(XmlFile annotationsFile) {
        if (annotationsFile == null) {
            return null;
        }
        XmlDocument document = annotationsFile.getDocument();
        if (document == null) {
            return null;
        }
        return document.getRootTag();
    }

    private static void markForUndo(@Nullable PsiFile containingFile) {
        if (containingFile == null) {
            return;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile != null && virtualFile.isInLocalFileSystem()) {
            UndoUtil.markPsiFileForUndo((PsiFile)containingFile);
        }
    }

    @NotNull
    private XmlTag addAnnotation(@NotNull XmlTag rootTag, @NotNull String ownerName, @NotNull ExternalAnnotation annotation, @Nullable XmlTag startTag) {
        if (startTag == null) {
            startTag = (XmlTag)PsiTreeUtil.findChildOfType((PsiElement)rootTag, XmlTag.class);
        }
        XmlTag prevItem = null;
        XmlTag curItem = startTag;
        while (curItem != null) {
            XmlTag addedItem = this.addAnnotation(rootTag, ownerName, annotation, curItem, prevItem);
            if (addedItem != null) {
                return addedItem;
            }
            prevItem = curItem;
            curItem = (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)curItem, XmlTag.class);
        }
        return this.addItemTag(rootTag, prevItem, ownerName, annotation);
    }

    @Nullable
    private XmlTag addAnnotation(@NotNull XmlTag rootTag, @NotNull String ownerName, @NotNull ExternalAnnotation annotation, @NotNull XmlTag curItem, @Nullable XmlTag prevItem) {
        String curItemName = curItem.getAttributeValue("name");
        if (curItemName == null) {
            curItem.delete();
            return null;
        }
        int compare = ownerName.compareTo(curItemName);
        if (compare == 0) {
            return this.appendItemAnnotation(curItem, annotation);
        }
        if (compare < 0) {
            return this.addItemTag(rootTag, prevItem, ownerName, annotation);
        }
        return null;
    }

    @NotNull
    private XmlTag addItemTag(@NotNull XmlTag rootTag, @Nullable XmlTag anchor, @NotNull String ownerName, @NotNull ExternalAnnotation annotation) {
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)this.myPsiManager.getProject());
        XmlTag newItemTag = elementFactory.createTagFromText((CharSequence)ExternalAnnotationsManagerImpl.createItemTag(ownerName, annotation));
        Object addedElement = anchor != null ? rootTag.addAfter((PsiElement)newItemTag, (PsiElement)anchor) : rootTag.addSubTag(newItemTag, true);
        if (!(addedElement instanceof XmlTag)) {
            throw new IncorrectOperationException("Failed to add annotation " + annotation + " after " + anchor);
        }
        return (XmlTag)addedElement;
    }

    private XmlTag appendItemAnnotation(@NotNull XmlTag itemTag, @NotNull ExternalAnnotation annotation) {
        XmlTag newAnnotationTag;
        PsiElement addedElement;
        String annotationFQName = annotation.getAnnotationFQName();
        PsiNameValuePair[] values = annotation.getValues();
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)this.myPsiManager.getProject());
        XmlTag anchor = null;
        for (XmlTag itemAnnotation : itemTag.getSubTags()) {
            String curAnnotationName = itemAnnotation.getAttributeValue("name");
            if (curAnnotationName == null) {
                itemAnnotation.delete();
                continue;
            }
            if (annotationFQName.equals(curAnnotationName)) {
                itemAnnotation.delete();
                break;
            }
            anchor = itemAnnotation;
        }
        if (!((addedElement = itemTag.addAfter((PsiElement)(newAnnotationTag = elementFactory.createTagFromText((CharSequence)ExternalAnnotationsManagerImpl.createAnnotationTag(annotationFQName, values))), anchor)) instanceof XmlTag)) {
            throw new IncorrectOperationException("Failed to add annotation " + annotation + " after " + anchor);
        }
        return itemTag;
    }

    @Nullable
    private List<XmlFile> findExternalAnnotationsXmlFiles(@NotNull PsiModifierListOwner listOwner) {
        List<PsiFile> psiFiles = this.findExternalAnnotationsFiles(listOwner);
        if (psiFiles == null) {
            return null;
        }
        ArrayList<XmlFile> xmlFiles = new ArrayList<XmlFile>();
        for (PsiFile psiFile : psiFiles) {
            if (!(psiFile instanceof XmlFile)) continue;
            xmlFiles.add((XmlFile)psiFile);
        }
        return xmlFiles;
    }

    private boolean setupRootAndAnnotateExternally(@NotNull OrderEntry entry, @NotNull Project project, @NotNull ExternalAnnotation annotation) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(JavaBundle.message((String)"external.annotations.root.chooser.title", (Object[])new Object[]{entry.getPresentableName()}));
        descriptor.setDescription(JavaBundle.message((String)"external.annotations.root.chooser.description", (Object[])new Object[0]));
        VirtualFile newRoot = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (newRoot == null) {
            this.notifyAfterAnnotationChanging(annotation.getOwner(), annotation.getAnnotationFQName(), false);
            return false;
        }
        WriteCommandAction.writeCommandAction((Project)project).run(() -> this.appendChosenAnnotationsRoot(entry, newRoot));
        this.annotateExternally(newRoot, annotation);
        return true;
    }

    @Nullable
    private static XmlFile findXmlFileInRoot(@Nullable List<? extends XmlFile> xmlFiles, @NotNull VirtualFile root) {
        if (xmlFiles != null) {
            for (XmlFile xmlFile : xmlFiles) {
                VirtualFile vf = xmlFile.getVirtualFile();
                if (vf == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)vf, (boolean)false)) continue;
                return xmlFile;
            }
        }
        return null;
    }

    private void chooseRootAndAnnotateExternally(VirtualFile @NotNull [] roots, final @NotNull ExternalAnnotation annotation) {
        if (roots.length > 1) {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<VirtualFile>(JavaBundle.message((String)"external.annotations.roots", (Object[])new Object[0]), roots){

                public void canceled() {
                    ExternalAnnotationsManagerImpl.this.notifyAfterAnnotationChanging(annotation.getOwner(), annotation.getAnnotationFQName(), false);
                }

                public PopupStep onChosen(@NotNull VirtualFile file, boolean finalChoice) {
                    ExternalAnnotationsManagerImpl.this.annotateExternally(file, annotation);
                    return FINAL_CHOICE;
                }

                @NotNull
                public String getTextFor(@NotNull VirtualFile value2) {
                    return value2.getPresentableUrl();
                }

                public Icon getIconFor(VirtualFile aValue) {
                    return AllIcons.Modules.Annotation;
                }
            }).showInBestPositionFor(DataManager.getInstance().getDataContext());
        } else {
            this.annotateExternally(roots[0], annotation);
        }
    }

    private static VirtualFile @NotNull [] filterByReadOnliness(VirtualFile @NotNull [] files) {
        List result = ContainerUtil.filter((Object[])files, VirtualFile::isInLocalFileSystem);
        return VfsUtilCore.toVirtualFileArray((Collection)result);
    }

    @Override
    public boolean deannotate(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.processExistingExternalAnnotations(listOwner, annotationFQN, (Processor<? super XmlTag>)((Processor)annotationTag -> {
            PsiElement parent = annotationTag.getParent();
            annotationTag.delete();
            if (parent instanceof XmlTag && ((XmlTag)parent).getSubTags().length == 0) {
                parent.delete();
            }
            return true;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elementRenamedOrMoved(@NotNull PsiModifierListOwner element, @NotNull String oldExternalName) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        try {
            List<XmlFile> files = this.findExternalAnnotationsXmlFiles(element);
            if (files == null) {
                return;
            }
            for (XmlFile file : files) {
                XmlTag rootTag;
                XmlDocument document;
                if (!file.isValid() || (document = file.getDocument()) == null || (rootTag = document.getRootTag()) == null) continue;
                for (XmlTag tag : rootTag.getSubTags()) {
                    String className2;
                    String nameValue = tag.getAttributeValue("name");
                    String string = className2 = nameValue == null ? null : StringUtil.unescapeXmlEntities((String)nameValue);
                    if (!Comparing.strEqual((String)className2, (String)oldExternalName)) continue;
                    WriteCommandAction.runWriteCommandAction((Project)this.myPsiManager.getProject(), (String)ExternalAnnotationsManagerImpl.class.getName(), null, () -> {
                        PsiDocumentManager.getInstance((Project)this.myPsiManager.getProject()).commitAllDocuments();
                        try {
                            String name2 = ExternalAnnotationsManagerImpl.getExternalName(element);
                            tag.setAttribute("name", name2 == null ? null : StringUtil.escapeXmlEntities((String)name2));
                            this.commitChanges(file);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }, (PsiFile[])new PsiFile[]{file});
                }
            }
        }
        finally {
            this.dropAnnotationsCache();
        }
    }

    @Override
    public boolean editExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, PsiNameValuePair @Nullable [] value2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.processExistingExternalAnnotations(listOwner, annotationFQN, (Processor<? super XmlTag>)((Processor)annotationTag -> {
            annotationTag.replace((PsiElement)XmlElementFactory.getInstance((Project)this.myPsiManager.getProject()).createTagFromText((CharSequence)ExternalAnnotationsManagerImpl.createAnnotationTag(annotationFQN, value2)));
            return true;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processExistingExternalAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @NotNull Processor<? super XmlTag> annotationTagProcessor) {
        try {
            List<XmlFile> files = this.findExternalAnnotationsXmlFiles(listOwner);
            if (files == null) {
                this.notifyAfterAnnotationChanging(listOwner, annotationFQN, false);
                boolean bl = false;
                return bl;
            }
            boolean processedAnything = false;
            for (XmlFile file : files) {
                XmlTag rootTag;
                XmlDocument document;
                if (!file.isValid() || (document = file.getDocument()) == null || (rootTag = document.getRootTag()) == null) continue;
                String externalName = ExternalAnnotationsManagerImpl.getExternalName(listOwner);
                ArrayList<XmlTag> tagsToProcess = new ArrayList<XmlTag>();
                for (XmlTag tag : rootTag.getSubTags()) {
                    String className2;
                    String nameValue = tag.getAttributeValue("name");
                    String string = className2 = nameValue == null ? null : StringUtil.unescapeXmlEntities((String)nameValue);
                    if (!Comparing.strEqual((String)className2, (String)externalName)) continue;
                    for (XmlTag annotationTag : tag.getSubTags()) {
                        if (!Comparing.strEqual((String)annotationTag.getAttributeValue("name"), (String)annotationFQN)) continue;
                        tagsToProcess.add(annotationTag);
                        processedAnything = true;
                    }
                }
                if (tagsToProcess.isEmpty() || ReadonlyStatusHandler.getInstance((Project)this.myPsiManager.getProject()).ensureFilesWritable(Collections.singletonList(file.getVirtualFile())).hasReadonlyFiles()) continue;
                WriteCommandAction.runWriteCommandAction((Project)this.myPsiManager.getProject(), (String)ExternalAnnotationsManagerImpl.class.getName(), null, () -> {
                    PsiDocumentManager.getInstance((Project)this.myPsiManager.getProject()).commitAllDocuments();
                    try {
                        for (XmlTag annotationTag : tagsToProcess) {
                            annotationTagProcessor.process((Object)annotationTag);
                        }
                        this.commitChanges(file);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }, (PsiFile[])new PsiFile[0]);
            }
            this.notifyAfterAnnotationChanging(listOwner, annotationFQN, processedAnything);
            boolean bl = processedAnything;
            return bl;
        }
        finally {
            this.dropAnnotationsCache();
        }
    }

    @Override
    @NotNull
    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlaceNoUi(@NotNull PsiElement element) {
        return this.chooseAnnotationsPlace(element, () -> ExternalAnnotationsManager.AnnotationPlace.NEED_ASK_USER);
    }

    @Override
    @NotNull
    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.chooseAnnotationsPlace(element, () -> ExternalAnnotationsManagerImpl.confirmNewExternalAnnotationRoot(element));
    }

    @NotNull
    private ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element, @NotNull Supplier<ExternalAnnotationsManager.AnnotationPlace> confirmNewExternalAnnotationRoot) {
        if (!element.isPhysical() && !(element.getOriginalElement() instanceof PsiCompiledElement)) {
            return ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
        }
        if (!element.getManager().isInProject(element)) {
            return ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
        }
        Project project = this.myPsiManager.getProject();
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null && JavaCodeStyleSettings.getInstance((PsiFile)containingFile).USE_EXTERNAL_ANNOTATIONS) {
            VirtualFile virtualFile = containingFile.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(virtualFile);
            if (!entries.isEmpty()) {
                for (OrderEntry entry : entries) {
                    if (entry instanceof ModuleOrderEntry) continue;
                    if (AnnotationOrderRootType.getUrls((OrderEntry)entry).length <= 0) break;
                    return ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
                }
            }
            return confirmNewExternalAnnotationRoot.get();
        }
        return ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static ExternalAnnotationsManager.AnnotationPlace confirmNewExternalAnnotationRoot(@NotNull PsiElement element) {
        block10: {
            MyExternalPromptDialog dialog;
            PsiFile containingFile = element.getContainingFile();
            Project project = containingFile.getProject();
            MyExternalPromptDialog myExternalPromptDialog = dialog = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment() ? null : new MyExternalPromptDialog(project);
            if (dialog != null && dialog.isToBeShown()) {
                PsiElement highlightElement = element instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)element).getNameIdentifier() : element.getNavigationElement();
                LOG.assertTrue(highlightElement != null);
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                ArrayList highlighters = new ArrayList();
                boolean highlight = editor != null && editor.getDocument() == PsiDocumentManager.getInstance((Project)project).getDocument(containingFile);
                try {
                    ExternalAnnotationsManager.AnnotationPlace annotationPlace;
                    if (highlight) {
                        TextRange textRange = highlightElement.getTextRange();
                        HighlightManager.getInstance((Project)project).addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, true, highlighters);
                        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(textRange.getStartOffset());
                        editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.CENTER);
                    }
                    dialog.show();
                    if (dialog.getExitCode() == 2) {
                        annotationPlace = ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
                        return annotationPlace;
                    }
                    if (dialog.getExitCode() == 1) {
                        annotationPlace = ExternalAnnotationsManager.AnnotationPlace.NOWHERE;
                        return annotationPlace;
                    }
                    break block10;
                }
                finally {
                    if (highlight) {
                        HighlightManager.getInstance((Project)project).removeSegmentHighlighter(editor, (RangeHighlighter)highlighters.get(0));
                    }
                }
            }
            if (dialog != null) {
                dialog.close(0);
            }
        }
        return ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
    }

    private void appendChosenAnnotationsRoot(@NotNull OrderEntry entry, @NotNull VirtualFile vFile) {
        if (entry instanceof LibraryOrderEntry) {
            Library library = ((LibraryOrderEntry)entry).getLibrary();
            LOG.assertTrue(library != null);
            Library.ModifiableModel model = library.getModifiableModel();
            model.addRoot(vFile, AnnotationOrderRootType.getInstance());
            model.commit();
        } else if (entry instanceof ModuleSourceOrderEntry) {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)entry.getOwnerModule()).getModifiableModel();
            JavaModuleExternalPaths extension = (JavaModuleExternalPaths)model.getModuleExtension(JavaModuleExternalPaths.class);
            extension.setExternalAnnotationUrls(ArrayUtil.mergeArrays((String[])extension.getExternalAnnotationsUrls(), (String[])new String[]{vFile.getUrl()}));
            model.commit();
        } else if (entry instanceof JdkOrderEntry) {
            SdkModificator sdkModificator = ((JdkOrderEntry)entry).getJdk().getSdkModificator();
            sdkModificator.addRoot(vFile, AnnotationOrderRootType.getInstance());
            sdkModificator.commitChanges();
        }
        this.dropAnnotationsCache();
    }

    private static void sortItems(@NotNull XmlFile xmlFile) {
        XmlDocument document = xmlFile.getDocument();
        if (document == null) {
            return;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return;
        }
        ArrayList<XmlTag> itemTags = new ArrayList<XmlTag>();
        for (XmlTag item : rootTag.getSubTags()) {
            if (item.getAttributeValue("name") != null) {
                itemTags.add(item);
                continue;
            }
            item.delete();
        }
        ArrayList sorted = new ArrayList(itemTags);
        sorted.sort((item1, item2) -> {
            String externalName1 = item1.getAttributeValue("name");
            String externalName2 = item2.getAttributeValue("name");
            assert (externalName1 != null && externalName2 != null);
            return externalName1.compareTo(externalName2);
        });
        if (!sorted.equals(itemTags)) {
            for (XmlTag item : sorted) {
                rootTag.addAfter((PsiElement)item, null);
                item.delete();
            }
        }
    }

    private void commitChanges(XmlFile xmlFile) {
        ExternalAnnotationsManagerImpl.sortItems(xmlFile);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myPsiManager.getProject());
        Document doc = documentManager.getDocument((PsiFile)xmlFile);
        assert (doc != null);
        documentManager.doPostponedOperationsAndUnblockDocument(doc);
        FileDocumentManager.getInstance().saveDocument(doc);
    }

    @NonNls
    @NotNull
    private static String createItemTag(@NotNull String ownerName, @NotNull ExternalAnnotation annotation) {
        String annotationTag = ExternalAnnotationsManagerImpl.createAnnotationTag(annotation.getAnnotationFQName(), annotation.getValues());
        return String.format("<item name='%s'>%s</item>", ownerName, annotationTag);
    }

    @NonNls
    @VisibleForTesting
    @NotNull
    public static String createAnnotationTag(@NotNull String annotationFQName, PsiNameValuePair @Nullable [] values) {
        String text2;
        if (values != null && values.length != 0) {
            text2 = "  <annotation name='" + annotationFQName + "'>\n";
            text2 = text2 + StringUtil.join((Object[])values, pair2 -> "<val" + (pair2.getName() != null ? " name=\"" + pair2.getName() + "\"" : "") + " val=\"" + StringUtil.escapeXmlEntities((String)pair2.getValue().getText()) + "\"/>", (String)"    \n");
            text2 = text2 + "  </annotation>";
        } else {
            text2 = "  <annotation name='" + annotationFQName + "'/>\n";
        }
        return text2;
    }

    @Nullable
    private XmlFile createAnnotationsXml(@NotNull VirtualFile root, @NonNls @NotNull String packageName) {
        return ExternalAnnotationsManagerImpl.createAnnotationsXml(root, packageName, this.myPsiManager);
    }

    @VisibleForTesting
    @Nullable
    public static XmlFile createAnnotationsXml(@NotNull VirtualFile root, @NonNls @NotNull String packageName, PsiManager manager) {
        String[] dirs;
        for (String dir : dirs = packageName.split("\\.")) {
            if (dir.isEmpty()) break;
            VirtualFile subdir = root.findChild(dir);
            if (subdir == null) {
                try {
                    subdir = root.createChildDirectory(null, dir);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
            root = subdir;
        }
        PsiDirectory directory = manager.findDirectory(root);
        if (directory == null) {
            return null;
        }
        PsiFile psiFile = directory.findFile("annotations.xml");
        if (psiFile instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        try {
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)manager.getProject());
            return (XmlFile)directory.add((PsiElement)factory.createFileFromText("annotations.xml", (FileType)XmlFileType.INSTANCE, (CharSequence)"<root></root>"));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private XmlFile getFileForAnnotations(@NotNull VirtualFile root, @NotNull PsiModifierListOwner owner2, Project project) {
        String packageName;
        PsiFile containingFile = owner2.getOriginalElement().getContainingFile();
        String string = owner2 instanceof PsiPackage ? ((PsiPackage)owner2).getQualifiedName() : (packageName = containingFile instanceof PsiJavaFile ? ((PsiJavaFile)containingFile).getPackageName() : null);
        if (packageName == null) {
            return null;
        }
        List<XmlFile> annotationsFiles = this.findExternalAnnotationsXmlFiles(owner2);
        XmlFile fileInRoot = ExternalAnnotationsManagerImpl.findXmlFileInRoot(annotationsFiles, root);
        if (fileInRoot != null) {
            return fileInRoot;
        }
        return (XmlFile)WriteCommandAction.writeCommandAction((Project)project).compute(() -> {
            PsiModifierListOwner key2;
            XmlFile newAnnotationsFile = this.createAnnotationsXml(root, packageName);
            if (newAnnotationsFile == null) {
                return null;
            }
            Object object = key2 = owner2 instanceof PsiPackage ? owner2 : containingFile.getVirtualFile();
            if (key2 != null) {
                this.registerExternalAnnotations(key2, (PsiFile)newAnnotationsFile);
            }
            return newAnnotationsFile;
        });
    }

    @Override
    public boolean hasAnnotationRootsForFile(@NotNull VirtualFile file) {
        if (this.hasAnyAnnotationsRoots()) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myPsiManager.getProject()).getFileIndex();
            for (OrderEntry entry : fileIndex.getOrderEntriesForFile(file)) {
                if (entry instanceof ModuleOrderEntry || AnnotationOrderRootType.getUrls((OrderEntry)entry).length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void duplicateError(@NotNull VirtualFile virtualFile, @NotNull String externalName, @NotNull String text2) {
        String message2 = text2 + "; for signature: '" + externalName + "' in the file " + virtualFile.getName();
        LOG.error(message2, new Throwable(), new Attachment[]{AttachmentFactory.createAttachment((VirtualFile)virtualFile)});
    }

    public static boolean areExternalAnnotationsApplicable(@NotNull PsiModifierListOwner owner2) {
        PsiElement parent;
        PsiElement originalElement;
        if (!owner2.isPhysical() && !((originalElement = owner2.getOriginalElement()) instanceof PsiCompiledElement)) {
            return false;
        }
        if (owner2 instanceof PsiLocalVariable) {
            return false;
        }
        if (owner2 instanceof PsiParameter && ((parent = owner2.getParent()) == null || !(parent.getParent() instanceof PsiMethod))) {
            return false;
        }
        if (!owner2.getManager().isInProject((PsiElement)owner2)) {
            return true;
        }
        return JavaCodeStyleSettings.getInstance((PsiFile)owner2.getContainingFile()).USE_EXTERNAL_ANNOTATIONS;
    }

    private class MyDocumentListener
    implements DocumentListener {
        final FileDocumentManager myFileDocumentManager = FileDocumentManager.getInstance();

        private MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            VirtualFile file = this.myFileDocumentManager.getFile(event.getDocument());
            if (file != null && "annotations.xml".equals(file.getName()) && ExternalAnnotationsManagerImpl.this.isUnderAnnotationRoot(file)) {
                ExternalAnnotationsManagerImpl.this.dropAnnotationsCache();
            }
        }
    }

    private static class MyExternalPromptDialog
    extends OptionsMessageDialog {
        private final Project myProject;

        MyExternalPromptDialog(Project project) {
            super(project, MyExternalPromptDialog.getMessage(), JavaBundle.message((String)"external.annotation.prompt", (Object[])new Object[0]), Messages.getQuestionIcon());
            this.myProject = project;
            this.init();
        }

        protected String getOkActionName() {
            return MyExternalPromptDialog.getAddInCode();
        }

        @NotNull
        protected String getCancelActionName() {
            return CommonBundle.getCancelButtonText();
        }

        protected Action @NotNull [] createActions() {
            Action okAction = this.getOKAction();
            MyExternalPromptDialog.assignMnemonic((String)MyExternalPromptDialog.getAddInCode(), (Action)okAction);
            final String externalName = JavaBundle.message((String)"external.annotations.external.option", (Object[])new Object[0]);
            return new Action[]{okAction, new AbstractAction(externalName){
                {
                    super(x0);
                    MyExternalPromptDialog.assignMnemonic((String)externalName, (Action)this);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.canBeHidden()) {
                        this.setToBeShown(this.toBeShown(), true);
                    }
                    this.close(2);
                }
            }, this.getCancelAction()};
        }

        protected boolean isToBeShown() {
            return ((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(JavaCodeStyleSettings.class)).USE_EXTERNAL_ANNOTATIONS;
        }

        protected void setToBeShown(boolean value2, boolean onOk) {
            ((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(JavaCodeStyleSettings.class)).USE_EXTERNAL_ANNOTATIONS = value2;
        }

        @NotNull
        protected JComponent createNorthPanel() {
            JPanel northPanel = (JPanel)super.createNorthPanel();
            northPanel.add((Component)new JLabel(MyExternalPromptDialog.getMessage()), "Center");
            return northPanel;
        }

        protected boolean shouldSaveOptionsOnCancel() {
            return true;
        }

        private static String getAddInCode() {
            return JavaBundle.message((String)"external.annotations.in.code.option", (Object[])new Object[0]);
        }

        private static String getMessage() {
            return JavaBundle.message((String)"external.annotations.suggestion.message", (Object[])new Object[0]);
        }
    }
}

