/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.pom.java.AcceptedLanguageLevelsSettings;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.TestIndexingModeSupporter;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.DefaultLightProjectDescriptor;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.JavaCodeInsightTestFixture;
import com.intellij.testFramework.fixtures.JavaIndexingModeCodeInsightTestFixture;
import com.intellij.testFramework.fixtures.JavaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public abstract class LightJavaCodeInsightFixtureTestCase
extends UsefulTestCase
implements TestIndexingModeSupporter {
    @NotNull
    public static final LightProjectDescriptor JAVA_1_4 = new ProjectDescriptor(LanguageLevel.JDK_1_4);
    @NotNull
    public static final LightProjectDescriptor JAVA_1_4_ANNOTATED = new ProjectDescriptor(LanguageLevel.JDK_1_4, true);
    @NotNull
    public static final LightProjectDescriptor JAVA_1_5 = new ProjectDescriptor(LanguageLevel.JDK_1_5);
    @NotNull
    public static final LightProjectDescriptor JAVA_1_6 = new ProjectDescriptor(LanguageLevel.JDK_1_6);
    @NotNull
    public static final LightProjectDescriptor JAVA_1_7 = new ProjectDescriptor(LanguageLevel.JDK_1_7);
    @NotNull
    public static final LightProjectDescriptor JAVA_1_7_ANNOTATED = new ProjectDescriptor(LanguageLevel.JDK_1_7, true);
    @NotNull
    public static final LightProjectDescriptor JAVA_8 = new ProjectDescriptor(LanguageLevel.JDK_1_8);
    @NotNull
    public static final LightProjectDescriptor JAVA_8_ANNOTATED = new ProjectDescriptor(LanguageLevel.JDK_1_8, true);
    @NotNull
    public static final LightProjectDescriptor JAVA_9 = new ProjectDescriptor(LanguageLevel.JDK_1_9);
    @NotNull
    public static final LightProjectDescriptor JAVA_9_ANNOTATED = new ProjectDescriptor(LanguageLevel.JDK_1_9, true);
    @NotNull
    public static final LightProjectDescriptor JAVA_10 = new ProjectDescriptor(LanguageLevel.JDK_10);
    @NotNull
    public static final LightProjectDescriptor JAVA_10_ANNOTATED = new ProjectDescriptor(LanguageLevel.JDK_10, true);
    @NotNull
    public static final LightProjectDescriptor JAVA_11 = new ProjectDescriptor(LanguageLevel.JDK_11);
    @NotNull
    public static final LightProjectDescriptor JAVA_12 = new ProjectDescriptor(LanguageLevel.JDK_12);
    @NotNull
    public static final LightProjectDescriptor JAVA_13 = new ProjectDescriptor(LanguageLevel.JDK_13);
    @NotNull
    public static final LightProjectDescriptor JAVA_14 = new ProjectDescriptor(LanguageLevel.JDK_14_PREVIEW);
    @NotNull
    public static final LightProjectDescriptor JAVA_15 = new ProjectDescriptor(LanguageLevel.JDK_15_PREVIEW);
    @NotNull
    public static final LightProjectDescriptor JAVA_X = new ProjectDescriptor(LanguageLevel.JDK_X);
    @NotNull
    public static final LightProjectDescriptor JAVA_LATEST = new ProjectDescriptor(LanguageLevel.HIGHEST){

        @Override
        public Sdk getSdk() {
            return IdeaTestUtil.getMockJdk17();
        }
    };
    protected JavaCodeInsightTestFixture myFixture;
    @NotNull
    private TestIndexingModeSupporter.IndexingMode myIndexingMode = TestIndexingModeSupporter.IndexingMode.SMART;

    protected void setUp() throws Exception {
        super.setUp();
        IdeaTestFixtureFactory factory = IdeaTestFixtureFactory.getFixtureFactory();
        TestFixtureBuilder fixtureBuilder = factory.createLightFixtureBuilder(this.getProjectDescriptor());
        IdeaProjectTestFixture fixture = (IdeaProjectTestFixture)fixtureBuilder.getFixture();
        this.myFixture = JavaTestFixtureFactory.getFixtureFactory().createCodeInsightFixture(fixture, this.getTempDirFixture());
        this.myFixture = JavaIndexingModeCodeInsightTestFixture.Companion.wrapFixture(this.myFixture, this.myIndexingMode);
        this.myFixture.setTestDataPath(this.getTestDataPath());
        this.myFixture.setUp();
        LanguageLevelProjectExtension.getInstance((Project)this.getProject()).setLanguageLevel(LanguageLevel.JDK_1_6);
    }

    @NotNull
    protected TempDirTestFixture getTempDirFixture() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        return policy != null ? policy.createTempDirTestFixture() : new LightTempDirTestFixtureImpl(true);
    }

    protected void tearDown() throws Exception {
        try {
            this.myFixture.tearDown();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            this.myFixture = null;
            super.tearDown();
        }
    }

    protected String getBasePath() {
        return "";
    }

    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        return JAVA_LATEST;
    }

    protected String getTestDataPath() {
        String communityPath = PlatformTestUtil.getCommunityPath().replace(File.separatorChar, '/');
        String path = communityPath + this.getBasePath();
        return new File(path).exists() ? path : communityPath + "/../" + this.getBasePath();
    }

    protected Project getProject() {
        return this.myFixture.getProject();
    }

    protected PsiFile getFile() {
        return this.myFixture.getFile();
    }

    protected Editor getEditor() {
        return this.myFixture.getEditor();
    }

    protected Module getModule() {
        return this.myFixture.getModule();
    }

    protected PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.getProject());
    }

    public PsiElementFactory getElementFactory() {
        return JavaPsiFacade.getElementFactory((Project)this.getProject());
    }

    protected PsiFile createLightFile(FileType fileType, String text) {
        return PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText("a." + fileType.getDefaultExtension(), fileType, (CharSequence)text);
    }

    public PsiFile createLightFile(String fileName, Language language, String text) {
        return PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(fileName, language, (CharSequence)text, false, true);
    }

    public void setIndexingMode(@NotNull TestIndexingModeSupporter.IndexingMode mode) {
        this.myIndexingMode = mode;
    }

    @NotNull
    public TestIndexingModeSupporter.IndexingMode getIndexingMode() {
        return this.myIndexingMode;
    }

    protected static class ProjectDescriptor
    extends DefaultLightProjectDescriptor {
        protected final LanguageLevel myLanguageLevel;
        private final boolean myWithAnnotations;

        public ProjectDescriptor(@NotNull LanguageLevel languageLevel) {
            this(languageLevel, false);
        }

        public ProjectDescriptor(@NotNull LanguageLevel languageLevel, boolean withAnnotations) {
            this.myLanguageLevel = languageLevel;
            this.myWithAnnotations = withAnnotations;
        }

        public void setUpProject(@NotNull Project project, @NotNull LightProjectDescriptor.SetupHandler handler) throws Exception {
            if (this.myLanguageLevel.isPreview() || this.myLanguageLevel == LanguageLevel.JDK_X) {
                AcceptedLanguageLevelsSettings.allowLevel((Disposable)project, (LanguageLevel)this.myLanguageLevel);
            }
            super.setUpProject(project, handler);
        }

        @Override
        public Sdk getSdk() {
            Sdk jdk = IdeaTestUtil.getMockJdk(this.myLanguageLevel.toJavaVersion());
            return this.myWithAnnotations ? PsiTestUtil.addJdkAnnotations((Sdk)jdk) : jdk;
        }

        @Override
        public void configureModule(@NotNull Module module, @NotNull ModifiableRootModel model, @NotNull ContentEntry contentEntry) {
            ((LanguageLevelModuleExtension)model.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(this.myLanguageLevel);
        }
    }
}

