/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.lang.Language;
import com.intellij.mock.MockPsiElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockPsiDirectory
extends MockPsiElement
implements PsiDirectory {
    private final PsiPackage myPackage;
    private final Project myProject;

    public MockPsiDirectory(PsiPackage aPackage, @NotNull Disposable parentDisposable) {
        super(parentDisposable);
        this.myPackage = aPackage;
        this.myProject = null;
    }

    public MockPsiDirectory(Project project, @NotNull Disposable parentDisposable) {
        super(parentDisposable);
        this.myProject = project;
        this.myPackage = null;
    }

    public boolean isDirectory() {
        return true;
    }

    @NotNull
    public Project getProject() {
        return this.myProject != null ? this.myProject : super.getProject();
    }

    @NotNull
    public Language getLanguage() {
        return Language.ANY;
    }

    public void checkCreateFile(@NotNull String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method checkCreateFile is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public void checkCreateSubdirectory(@NotNull String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method checkCreateSubdirectory is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public PsiDirectory getParent() {
        return this.getParentDirectory();
    }

    @NotNull
    public PsiFile createFile(@NotNull String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method createFile is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public PsiFile copyFileFrom(@NotNull String newName, @NotNull PsiFile originalFile) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method copyFileFrom is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public PsiDirectory createSubdirectory(@NotNull String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method createSubdirectory is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Nullable
    public PsiFile findFile(@NotNull @NonNls String name) {
        throw new UnsupportedOperationException("Method findFile is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Nullable
    public PsiDirectory findSubdirectory(@NotNull String name) {
        throw new UnsupportedOperationException("Method findSubdirectory is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public PsiFile @NotNull [] getFiles() {
        throw new UnsupportedOperationException("Method getFiles is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public String getName() {
        throw new UnsupportedOperationException("Method getName is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Nullable
    public PsiDirectory getParentDirectory() {
        PsiPackage psiPackage = this.myPackage.getParentPackage();
        return psiPackage == null ? null : new MockPsiDirectory(psiPackage, (Disposable)this.getProject());
    }

    public PsiDirectory @NotNull [] getSubdirectories() {
        throw new UnsupportedOperationException("Method getSubdirectories is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
        return null;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return new LightVirtualFile();
    }

    public boolean processChildren(@NotNull PsiElementProcessor<PsiFileSystemItem> processor) {
        throw new UnsupportedOperationException("Method processChildren is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method setName is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Method checkSetName is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Nullable
    public ItemPresentation getPresentation() {
        throw new UnsupportedOperationException("Method getPresentation is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }
}

