/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.projectWizard.ChooseTemplateStep;
import com.intellij.ide.projectWizard.ProjectTypeStep;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.SelectTemplateSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LanguageLevelProjectExtensionImpl;
import com.intellij.openapi.roots.ui.configuration.actions.NewModuleAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectWizardTestCase<T extends AbstractProjectWizard>
extends HeavyPlatformTestCase {
    protected static final String DEFAULT_SDK = "default";
    protected T myWizard;
    @Nullable
    private Project myCreatedProject;
    private Sdk myOldDefaultProjectSdk;

    protected void setUp() throws Exception {
        super.setUp();
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        this.myOldDefaultProjectSdk = ProjectRootManager.getInstance((Project)defaultProject).getProjectSdk();
        Sdk projectSdk = ProjectRootManager.getInstance((Project)this.getProject()).getProjectSdk();
        for (Sdk jdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (projectSdk == jdk) continue;
            ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().removeJdk(jdk));
        }
        ProjectTypeStep.resetGroupForTests();
    }

    public void tearDown() throws Exception {
        try {
            if (this.myWizard != null) {
                Disposer.dispose((Disposable)this.myWizard.getDisposable());
                this.myWizard = null;
            }
            if (this.myCreatedProject != null) {
                PlatformTestUtil.forceCloseProjectWithoutSaving((Project)this.myCreatedProject);
                this.myCreatedProject = null;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                LanguageLevelProjectExtensionImpl extension = LanguageLevelProjectExtensionImpl.getInstanceImpl((Project)ProjectManager.getInstance().getDefaultProject());
                extension.resetDefaults();
                ProjectRootManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).setProjectSdk(this.myOldDefaultProjectSdk);
                JavaAwareProjectJdkTableImpl.removeInternalJdkInTests();
            });
            SelectTemplateSettings.getInstance().setLastTemplate(null, null);
            UIUtil.dispatchAllInvocationEvents();
            LaterInvocator.dispatchPendingFlushes();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected Project createProjectFromTemplate(@NotNull String group, @Nullable String name, @Nullable Consumer<? super Step> adjuster) throws IOException {
        this.runWizard(group, name, null, adjuster);
        try {
            this.myCreatedProject = NewProjectUtil.createFromWizard(this.myWizard);
        }
        catch (Throwable e) {
            this.myCreatedProject = (Project)ContainerUtil.find((Object[])ProjectManager.getInstance().getOpenProjects(), project -> this.myWizard.getProjectName().equals(project.getName()));
            throw new RuntimeException(e);
        }
        ProjectWizardTestCase.assertNotNull((Object)this.myCreatedProject);
        UIUtil.dispatchAllInvocationEvents();
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        ProjectWizardTestCase.assertEquals((String)Arrays.asList(projects).toString(), (int)2, (int)projects.length);
        return this.myCreatedProject;
    }

    @Nullable
    protected Module createModuleFromTemplate(String group, String name, @Nullable Consumer<? super Step> adjuster) throws IOException {
        return this.createModuleFromTemplate(group, name, this.getProject(), adjuster);
    }

    @Nullable
    protected Module createModuleFromTemplate(String group, String name, @NotNull Project project, @Nullable Consumer<? super Step> adjuster) throws IOException {
        this.runWizard(group, name, project, adjuster);
        return this.createModuleFromWizard(project);
    }

    private Module createModuleFromWizard(@NotNull Project project) {
        return new NewModuleAction().createModuleFromWizard(project, null, this.myWizard);
    }

    private void runWizard(@NotNull String group, @Nullable String name, @Nullable Project project, @Nullable Consumer<? super Step> adjuster) throws IOException {
        this.createWizard(project);
        ProjectTypeStep step = (ProjectTypeStep)this.myWizard.getCurrentStepObject();
        if (!step.setSelectedTemplate(group, name)) {
            throw new IllegalArgumentException(group + '/' + name + " template not found. Available groups: " + step.availableTemplateGroupsToString());
        }
        this.runWizard(step1 -> {
            if (name != null && step1 instanceof ChooseTemplateStep) {
                ((ChooseTemplateStep)step1).setSelectedTemplate(name);
            }
            if (adjuster != null) {
                adjuster.consume(step1);
            }
        });
    }

    protected void cancelWizardRun() {
        throw new CancelWizardException();
    }

    private void runWizard(@Nullable java.util.function.Consumer<? super Step> adjuster) {
        block4: {
            ModuleWizardStep currentStep;
            do {
                currentStep = (ModuleWizardStep)this.myWizard.getCurrentStepObject();
                if (adjuster != null) {
                    try {
                        adjuster.accept((Step)currentStep);
                    }
                    catch (CancelWizardException e) {
                        this.myWizard.doCancelAction();
                        return;
                    }
                }
                if (this.myWizard.isLast()) break block4;
                this.myWizard.doNextAction();
            } while (currentStep != this.myWizard.getCurrentStepObject());
            throw new RuntimeException(currentStep + " is not validated");
        }
        this.myWizard.doFinishAction();
    }

    protected void createWizard(@Nullable Project project) throws IOException {
        if (this.myWizard != null) {
            Disposer.dispose((Disposable)this.myWizard.getDisposable());
            this.myWizard = null;
        }
        this.myWizard = this.createWizard(project, this.createTempDirectoryWithSuffix("new").toFile());
        UIUtil.dispatchAllInvocationEvents();
    }

    protected Project createProject(java.util.function.Consumer<? super Step> adjuster) throws IOException {
        this.createWizard(null);
        this.runWizard(adjuster);
        this.myCreatedProject = NewProjectUtil.createFromWizard(this.myWizard);
        return this.myCreatedProject;
    }

    protected T createWizard(Project project, File directory) {
        throw new RuntimeException();
    }

    protected void configureJdk() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.addSdk(new SimpleJavaSdkType().createJdk(DEFAULT_SDK, SystemProperties.getJavaHome()));
            this.addSdk(new SimpleJavaSdkType().createJdk("_other", SystemProperties.getJavaHome()));
            LOG.debug("ProjectWizardTestCase.configureJdk:");
            LOG.debug(String.valueOf(Arrays.asList(ProjectJdkTable.getInstance().getAllJdks())));
        });
    }

    protected void addSdk(Sdk sdk) {
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk, this.getTestRootDisposable()));
    }

    protected Module importModuleFrom(ProjectImportProvider provider, String path) {
        return this.importFrom(path, this.getProject(), null, provider);
    }

    protected Module importProjectFrom(String path, java.util.function.Consumer<? super Step> adjuster, ProjectImportProvider ... providers) {
        Module module = this.importFrom(path, null, adjuster, providers);
        if (module != null) {
            this.myCreatedProject = module.getProject();
        }
        return module;
    }

    private Module importFrom(String path, @Nullable Project project, java.util.function.Consumer<? super Step> adjuster, ProjectImportProvider ... providers) {
        return ProjectWizardTestCase.computeInWriteSafeContext(() -> this.doImportModule(path, project, adjuster, providers));
    }

    private Module doImportModule(String path, @Nullable Project project, java.util.function.Consumer<? super Step> adjuster, ProjectImportProvider[] providers) {
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        ProjectWizardTestCase.assertNotNull((String)("Can't find " + path), (Object)file);
        ProjectWizardTestCase.assertTrue((boolean)providers[0].canImport(file, project));
        this.myWizard = ImportModuleAction.createImportWizard((Project)project, null, (VirtualFile)file, (ProjectImportProvider[])providers);
        ProjectWizardTestCase.assertNotNull(this.myWizard);
        if (this.myWizard.getStepCount() > 0) {
            this.runWizard(adjuster);
        }
        return (Module)ContainerUtil.getFirstItem((List)ImportModuleAction.createFromWizard((Project)project, this.myWizard));
    }

    private static <T> T computeInWriteSafeContext(Supplier<? extends T> supplier) {
        Ref module = Ref.create();
        ApplicationManager.getApplication().invokeLater(() -> module.set(supplier.get()));
        UIUtil.dispatchAllInvocationEvents();
        return (T)module.get();
    }

    protected Sdk createSdk(String name, SdkTypeId sdkType) {
        Sdk sdk = ProjectJdkTable.getInstance().createSdk(name, sdkType);
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk, this.getTestRootDisposable()));
        return sdk;
    }

    private static class CancelWizardException
    extends RuntimeException {
        private CancelWizardException() {
        }
    }
}

