/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ObjectUtils;
import org.editorconfig.Utils;
import org.jetbrains.annotations.NotNull;

public class EditorConfigStatusListener
implements CodeStyleSettingsListener,
Disposable {
    private boolean myEnabledStatus;
    private final VirtualFile myVirtualFile;
    private final Project myProject;

    public EditorConfigStatusListener(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        this.myProject = project;
        this.myEnabledStatus = Utils.isEnabled(project);
        this.myVirtualFile = virtualFile;
        CodeStyleSettingsManager.getInstance((Project)project).addListener((CodeStyleSettingsListener)this);
    }

    public final void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        boolean newEnabledStatus = Utils.isEnabled(this.myProject);
        if (this.myEnabledStatus != newEnabledStatus) {
            this.myEnabledStatus = newEnabledStatus;
            this.onEditorConfigEnabled(newEnabledStatus);
        }
    }

    private void onEditorConfigEnabled(boolean isEnabled) {
        if (!isEnabled) {
            FileEditorManager.getInstance((Project)this.myProject).closeFile(this.myVirtualFile);
            FileEditorManager.getInstance((Project)this.myProject).openFile(this.myVirtualFile, false);
        }
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myVirtualFile);
        ObjectUtils.consumeIfNotNull((Object)FileDocumentManager.getInstance().getDocument(this.myVirtualFile), document -> ObjectUtils.consumeIfNotNull((Object)PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document), psiFile -> DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile)));
    }

    public void dispose() {
        CodeStyleSettingsManager.removeListener((Project)this.myProject, (CodeStyleSettingsListener)this);
    }
}

