/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.Utf8BomOptionProvider;
import java.util.List;
import org.editorconfig.Utils;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;

public class EditorConfigUtf8BomOptionProvider
implements Utf8BomOptionProvider {
    public boolean shouldAddBOMForNewUtf8File(@NotNull VirtualFile file) {
        Project project = ProjectLocator.getInstance().guessProjectForFile(file);
        if (project != null) {
            List<EditorConfig.OutPair> optionsList = SettingsProviderComponent.getInstance().getOutPairs(project, file);
            String encoding = Utils.configValueForKey(optionsList, "charset");
            return "utf-8-bom".equals(encoding);
        }
        return false;
    }
}

