/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.internal;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.gradle.api.Project;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.gson.GsonBuilder;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.internal.DummyModel;
import org.jetbrains.plugins.gradle.model.internal.TurnOffDefaultTasks;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.annotation.TargetVersions;
import org.jetbrains.plugins.gradle.tooling.util.VersionMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtraModelBuilder
implements ToolingModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ExtraModelBuilder.class);
    @ApiStatus.Internal
    public static final String MODEL_BUILDER_SERVICE_MESSAGE_PREFIX = "ModelBuilderService message: ";
    private final List<ModelBuilderService> modelBuilderServices;
    @NotNull
    private final GradleVersion myCurrentGradleVersion;
    private ModelBuilderContext myModelBuilderContext;
    @Deprecated
    public static final ThreadLocal<ModelBuilderContext> CURRENT_CONTEXT = new ThreadLocal();

    public ExtraModelBuilder() {
        this(GradleVersion.current());
    }

    public ExtraModelBuilder(@NotNull GradleVersion gradleVersion) {
        this.myCurrentGradleVersion = gradleVersion;
        this.modelBuilderServices = Lists.newArrayList(ServiceLoader.load(ModelBuilderService.class, ExtraModelBuilder.class.getClassLoader()));
    }

    public boolean canBuild(String modelName) {
        if (DummyModel.class.getName().equals(modelName)) {
            return true;
        }
        if (TurnOffDefaultTasks.class.getName().equals(modelName)) {
            return true;
        }
        for (ModelBuilderService service : this.modelBuilderServices) {
            if (!service.canBuild(modelName) || !this.isVersionMatch(service)) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public Object buildAll(String modelName, Project project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void reportPerformanceStatistic(Project project, ModelBuilderService service, String modelName, long timeInMs) {
        String msg = String.format("%s: service %s imported '%s' in %d ms", project.getDisplayName(), service.getClass().getSimpleName(), modelName, timeInMs);
        project.getLogger().error(msg);
    }

    public static void reportModelBuilderFailure(@NotNull Project project, @NotNull ModelBuilderService service, @NotNull ModelBuilderContext modelBuilderContext, @NotNull Exception modelBuilderError) {
        try {
            Message message = service.getErrorMessageBuilder(project, modelBuilderError).buildMessage();
            modelBuilderContext.report(project, message);
        }
        catch (Throwable e) {
            LOG.warn("Failed to report model builder error", e);
        }
    }

    private boolean isVersionMatch(@NotNull ModelBuilderService builderService) {
        TargetVersions targetVersions = builderService.getClass().getAnnotation(TargetVersions.class);
        return new VersionMatcher(this.myCurrentGradleVersion).isVersionMatch(targetVersions);
    }

    @NotNull
    private static Gradle getRootGradle(@NotNull Gradle gradle) {
        Gradle root = gradle;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    private static class MyModelBuilderContext
    implements ModelBuilderContext {
        private final Map<ModelBuilderContext.DataProvider, Object> myMap = new IdentityHashMap<ModelBuilderContext.DataProvider, Object>();
        private final Gradle myGradle;

        private MyModelBuilderContext(Gradle gradle) {
            this.myGradle = gradle;
        }

        @NotNull
        public Gradle getRootGradle() {
            return this.myGradle;
        }

        @NotNull
        public <T> T getData(@NotNull ModelBuilderContext.DataProvider<T> provider) {
            Object data = this.myMap.get(provider);
            if (data == null) {
                Object value = provider.create(this.myGradle);
                this.myMap.put(provider, value);
                return (T)value;
            }
            return (T)data;
        }

        @ApiStatus.Experimental
        public void report(@NotNull Project project, @NotNull Message message) {
            if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"2.14.1")) < 0) {
                return;
            }
            try {
                ProgressLoggerFactory progressLoggerFactory = (ProgressLoggerFactory)((DefaultProject)project).getServices().get(ProgressLoggerFactory.class);
                ProgressLogger operation = progressLoggerFactory.newOperation(ModelBuilderService.class);
                String jsonMessage = new GsonBuilder().create().toJson((Object)message);
                operation.setDescription(ExtraModelBuilder.MODEL_BUILDER_SERVICE_MESSAGE_PREFIX + jsonMessage);
                operation.started();
                operation.completed();
            }
            catch (Throwable e) {
                LOG.warn("Failed to report model builder message", e);
            }
        }
    }
}

