/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingConfig;

public class AnnotationProcessingConfigImpl
implements AnnotationProcessingConfig,
Serializable {
    private final List<String> myPaths;
    private final List<String> myArgs;
    private final String myProcessorOutput;
    private final boolean isTestSources;

    public AnnotationProcessingConfigImpl(List<String> files, List<String> args, String output, boolean sources) {
        this.myProcessorOutput = output;
        this.isTestSources = sources;
        this.myPaths = new ArrayList<String>(files);
        this.myArgs = args;
    }

    @NotNull
    public Collection<String> getAnnotationProcessorPath() {
        return this.myPaths;
    }

    @NotNull
    public Collection<String> getAnnotationProcessorArguments() {
        return this.myArgs;
    }

    public boolean isTestSources() {
        return this.isTestSources;
    }

    @Nullable
    public String getProcessorOutput() {
        return this.myProcessorOutput;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationProcessingConfigImpl config = (AnnotationProcessingConfigImpl)o;
        return this.isTestSources == config.isTestSources && Objects.equal((Object)this.myProcessorOutput, (Object)config.myProcessorOutput) && Objects.equal(this.myPaths, config.myPaths) && Objects.equal(this.myArgs, config.myArgs);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myPaths, this.myArgs, this.myProcessorOutput, this.isTestSources});
    }
}

