/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.serialization.PropertyMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.GradleConfiguration;

public final class DefaultGradleConfiguration
implements GradleConfiguration {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final boolean visible;
    private final boolean scriptClasspathConfiguration;

    @PropertyMapping(value={"name", "description", "visible"})
    public DefaultGradleConfiguration(String name, String description, boolean visible) {
        this(name, description, visible, false);
    }

    public DefaultGradleConfiguration(@NotNull String name, @Nullable String description, boolean visible, boolean scriptClasspathConfiguration) {
        this.name = name;
        this.description = description;
        this.visible = visible;
        this.scriptClasspathConfiguration = scriptClasspathConfiguration;
    }

    public DefaultGradleConfiguration(GradleConfiguration configuration) {
        this(configuration.getName(), configuration.getDescription(), configuration.isVisible(), configuration.isScriptClasspathConfiguration());
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isScriptClasspathConfiguration() {
        return this.scriptClasspathConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGradleConfiguration that = (DefaultGradleConfiguration)o;
        if (this.visible != that.visible) {
            return false;
        }
        if (this.scriptClasspathConfiguration != that.scriptClasspathConfiguration) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.description != null ? !this.description.equals(that.description) : that.description != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.visible ? 1 : 0);
        result = 31 * result + (this.scriptClasspathConfiguration ? 1 : 0);
        return result;
    }
}

