/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;

public final class ClassSetProjectImportModelProvider
implements ProjectImportModelProvider {
    @NotNull
    private final Set<Class<?>> classSet;

    public ClassSetProjectImportModelProvider(@NotNull Collection<Class<?>> classes) {
        this.classSet = new LinkedHashSet(classes);
    }

    public void populateBuildModels(@NotNull BuildController controller, @NotNull GradleBuild build, @NotNull ProjectImportModelProvider.BuildModelConsumer consumer) {
    }

    public void populateProjectModels(@NotNull BuildController controller, @Nullable Model module, @NotNull ProjectImportModelProvider.ProjectModelConsumer modelConsumer) {
        for (Class<?> aClass : this.classSet) {
            Object instance = controller.findModel(module, aClass);
            if (instance == null) continue;
            modelConsumer.consume(instance, aClass);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassSetProjectImportModelProvider provider = (ClassSetProjectImportModelProvider)o;
        return this.classSet.equals(provider.classSet);
    }

    public int hashCode() {
        return this.classSet.hashCode();
    }
}

