/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.ui;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceSelectionUtils;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.TargetDeviceFilter;
import com.android.tools.idea.run.tasks.ShellCommandLauncher;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.google.api.services.fetchasgoogle_pa.model.AppIndexingStats;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleTask;
import com.google.appindexing.ui.CollapsablePanel;
import com.google.appindexing.util.AppIndexingBundle;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppIndexingResultPanel
extends JPanel {
    private JPanel myRootPanel;
    private JPanel myLeftPanel;
    private JPanel myTitlePanel;
    private JBLabel myDateLabel;
    private HyperlinkLabel myDeepLinkUrl;
    private JBLabel myPackageLabel;
    private JBLabel myUrlTitle;
    private JPanel myDetailPanel;
    private FetchAsGoogleTask myTask;

    private AppIndexingResultPanel(@NotNull FetchAsGoogleTask task, @NotNull String deepLink) {
        super(new BorderLayout());
        this.myTask = task;
        this.$$$setupUI$$$();
        this.initializeTitle(task, deepLink);
        this.myPackageLabel.setText(task.getPackageId());
        this.myRootPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.add(this.myRootPanel);
        this.fillPanelContent();
    }

    @NotNull
    public static AppIndexingResultPanel buildPanelFromFetchTask(@NotNull FetchAsGoogleTask task, @NotNull String deepLink) {
        return new AppIndexingResultPanel(task, deepLink);
    }

    private void initializeTitle(@NotNull FetchAsGoogleTask task, @NotNull String deepLink) {
        this.myPackageLabel.setText(task.getPackageId());
        this.myDateLabel.setText(task.getCreatedTime().toString());
        if (FetchAsGoogleTask.RequestType.USER_ACTION_LOGGING_DEBUGGING == task.getRequestType() || FetchAsGoogleTask.RequestType.PERSONAL_CONTENT_INDEXING_DEBUGGING == task.getRequestType()) {
            this.myUrlTitle.setText("App Version in Play Store:");
            if (task.getFetchResponse() != null) {
                this.myDeepLinkUrl.setText(task.getFetchResponse().getAppVersion());
            }
        } else {
            this.myDeepLinkUrl.setHyperlinkText(deepLink);
            this.myDeepLinkUrl.setHyperlinkTarget(deepLink);
        }
    }

    private void fillPanelContent() {
        FetchAsGoogleTask.ErrorCode errorCode = this.myTask.getErrorCode();
        block0 : switch (this.myTask.getRequestType()) {
            case APP_INDEXING: 
            case INSTANT_APP: {
                if (errorCode == null) {
                    this.addCollapsablePanel(AllIcons.RunConfigurations.TestPassed, AppIndexingBundle.message("app.indexing.fetch.as.google.test.success", new Object[0]), "Please see <a href=\"" + this.myTask.getFetchResponse().getUrl() + "\">" + AppIndexingBundle.message("app.indexing.fetch.as.google.test.result.text", new Object[0]) + "</a>");
                    return;
                }
                this.addCollapsablePanel(AllIcons.RunConfigurations.TestError, errorCode.name(), errorCode.getMessage() + " <a href='https://g.co/AppIndexing/AndroidStudio'>" + AppIndexingBundle.message("app.indexing.fetch.as.google.test.learn.more", new Object[0]) + "</a>");
                break;
            }
            case USER_ACTION_LOGGING_DEBUGGING: 
            case PERSONAL_CONTENT_INDEXING_DEBUGGING: {
                if (errorCode == null || errorCode.equals((Object)FetchAsGoogleTask.ErrorCode.OK)) {
                    this.handleAppIndexingStats();
                    break;
                }
                switch (errorCode) {
                    case NOT_FOUND: {
                        this.addCollapsablePanel(AllIcons.RunConfigurations.TestPassed, errorCode.name(), errorCode.getMessage());
                        break block0;
                    }
                    case APP_OWNERSHIP_VERIFICATION_FAILED: 
                    case BACKEND_ERROR: 
                    case RESOURCE_EXHAUSTED: {
                        this.addCollapsablePanel(AllIcons.RunConfigurations.TestError, errorCode.name(), errorCode.getMessage());
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private void handleAppIndexingStats() {
        if (this.myTask.getFetchResponse() == null) {
            FetchAsGoogleTask.ErrorCode errorCode = FetchAsGoogleTask.ErrorCode.BACKEND_ERROR;
            this.addCollapsablePanel(AllIcons.RunConfigurations.TestError, errorCode.name(), errorCode.getMessage());
            return;
        }
        if (StringUtil.isEmpty((String)this.myTask.getFetchResponse().getAppVersion())) {
            this.addCollapsablePanel(AllIcons.RunConfigurations.TestError, FetchAsGoogleTask.ErrorCode.APK_NOT_FOUND.name(), FetchAsGoogleTask.ErrorCode.APK_NOT_FOUND.getMessage());
            return;
        }
        List stats = this.myTask.getFetchResponse().getStats();
        if (stats == null || stats.isEmpty()) {
            this.addCollapsablePanel(AllIcons.RunConfigurations.TestPassed, AppIndexingBundle.message("app.indexing.fetch.as.google.test.success", new Object[0]), AppIndexingBundle.message("app.indexing.fetch.as.google.test.success.detail.message", new Object[0]));
            return;
        }
        for (AppIndexingStats stat : stats) {
            long value = stat.getValue();
            switch (stat.getName()) {
                case "DAILY_UNRESOLVED_URI": {
                    this.handleUnresolvedUri(value);
                    break;
                }
                case "DAILY_UPDATE_CALL": {
                    this.addCollapsablePanel(AllIcons.RunConfigurations.TestError, AppIndexingBundle.message("app.indexing.fetch.as.google.test.error.daily.update.call", value), AppIndexingBundle.message("app.indexing.fetch.as.google.test.error.daily.update.call.detail.message", new Object[0]));
                    break;
                }
                case "DAILY_UPLOADED_PERSONAL_CONTENT_URI": {
                    this.addCollapsablePanel(AllIcons.RunConfigurations.TestError, AppIndexingBundle.message("app.indexing.fetch.as.google.test.error.upload.call.missing", new Object[0]), AppIndexingBundle.message("app.indexing.fetch.as.google.test.error.upload.call.missing.detail.message", new Object[0]));
                    break;
                }
                case "DAILY_WRONG_USER_ACTION_START_CALL": {
                    this.addCollapsablePanel(AllIcons.RunConfigurations.TestError, AppIndexingBundle.message("app.indexing.fetch.as.google.test.error.wrong.start.call", new Object[0]), AppIndexingBundle.message("app.indexing.fetch.as.google.test.error.wrong.start.call.detail.message", new Object[0]));
                    break;
                }
                case "DAILY_WRONG_USER_ACTION_END_CALL": {
                    this.addCollapsablePanel(AllIcons.RunConfigurations.TestError, AppIndexingBundle.message("app.indexing.fetch.as.google.test.error.wrong.end.call", new Object[0]), AppIndexingBundle.message("app.indexing.fetch.as.google.test.error.wrong.start.call.detail.message", new Object[0]));
                }
            }
        }
    }

    private void handleUnresolvedUri(long value) {
        CollapsablePanel collapsablePanel = this.addCollapsablePanel(AllIcons.RunConfigurations.TestError, AppIndexingBundle.message("app.indexing.fetch.as.google.test.error.unresolved.uri", value), AppIndexingBundle.message("app.indexing.fetch.as.google.test.error.unresolved.uri.detail.message", new Object[0]));
        JButton button = collapsablePanel.getButton();
        button.setVisible(true);
        button.setText(AppIndexingBundle.message("app.indexing.button.open.developer.tool", new Object[0]));
        button.addActionListener(e -> this.initializeAdbAndOpenDebuggingTool(collapsablePanel));
    }

    @NotNull
    private CollapsablePanel addCollapsablePanel(@NotNull Icon icon, @NotNull String titleMessage, @NotNull String detailMessage) {
        CollapsablePanel collapsablePanel = new CollapsablePanel(icon, titleMessage, detailMessage);
        this.myDetailPanel.add((Component)collapsablePanel.getRootPanel(), "South");
        return collapsablePanel;
    }

    private void initializeAdbAndOpenDebuggingTool(final @NotNull CollapsablePanel collapsablePanel) {
        collapsablePanel.startLoading();
        final AndroidFacet facet = AndroidFacet.getInstance((Module)this.myTask.getModule());
        if (facet == null || this.myTask.getPackageId() == null) {
            this.setOpenDeveloperToolResult(false, collapsablePanel);
            return;
        }
        File adb = AndroidSdkUtils.getAdb((Project)this.myTask.getProject());
        if (adb == null) {
            this.setOpenDeveloperToolResult(false, collapsablePanel);
            return;
        }
        ListenableFuture debugBridge = AdbService.getInstance().getDebugBridge(adb);
        Futures.addCallback((ListenableFuture)debugBridge, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(AndroidDebugBridge result) {
                AppIndexingResultPanel.this.launchDebuggingTool(facet, collapsablePanel);
            }

            public void onFailure(@NotNull Throwable t) {
                AppIndexingResultPanel.this.setOpenDeveloperToolResult(false, collapsablePanel);
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    private void launchDebuggingTool(@NotNull AndroidFacet facet, final @NotNull CollapsablePanel collapsablePanel) {
        Collection collection = DeviceSelectionUtils.chooseRunningDevice((AndroidFacet)facet, (Predicate)new TargetDeviceFilter.UsbDeviceFilter(), (DeviceCount)DeviceCount.SINGLE);
        if (collection == null) {
            this.setOpenDeveloperToolResult(true, collapsablePanel);
            return;
        }
        if (collection.isEmpty()) {
            this.setOpenDeveloperToolResult(false, collapsablePanel);
            return;
        }
        IDevice device = (IDevice)collection.iterator().next();
        AndroidProcessHandler androidProcessHandler = new AndroidProcessHandler(facet.getModule().getProject(), this.myTask.getPackageId());
        androidProcessHandler.addTargetDevice(device);
        FutureCallbackExecutor f = FutureCallbackExecutor.wrap((Executor)Executors.newSingleThreadExecutor());
        ListenableFuture launchResult = f.executeAsync(() -> ShellCommandLauncher.execute((String)"am start -a \"com.google.android.gms.icing.APP_INDEXING_DEBUG\"", (IDevice)device, (LaunchStatus)new ProcessHandlerLaunchStatus((ProcessHandler)androidProcessHandler), (ConsolePrinter)new ProcessHandlerConsolePrinter((ProcessHandler)androidProcessHandler), (long)10L, (TimeUnit)TimeUnit.SECONDS));
        Futures.addCallback((ListenableFuture)launchResult, (FutureCallback)new FutureCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                AppIndexingResultPanel.this.setOpenDeveloperToolResult(result, collapsablePanel);
            }

            public void onFailure(@NotNull Throwable t) {
                AppIndexingResultPanel.this.setOpenDeveloperToolResult(false, collapsablePanel);
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    private void setOpenDeveloperToolResult(@Nullable Boolean succeeded, @NotNull CollapsablePanel collapsablePanel) {
        if (this.myTask.getProject().isDisposed()) {
            return;
        }
        collapsablePanel.stopLoading();
        collapsablePanel.setActionErrorMessage(succeeded != null && succeeded != false ? "" : AppIndexingBundle.message("app.indexing.open.developer.tool.fail.message", new Object[0]));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        HyperlinkLabel hyperlinkLabel;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myRootPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.setFocusCycleRoot(true);
        this.myLeftPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel4.add((Component)jPanel3, gridBagConstraints);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-5789785)), "Test Result Details", 0, 0, null, null));
        this.myTitlePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setFocusable(false);
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("App ID:");
        jPanel2.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Date:");
        jPanel2.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUrlTitle = jBLabel3 = new JBLabel();
        jBLabel3.setText("URL:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("(app id)");
        jPanel2.add((Component)jBLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myDateLabel = jBLabel = new JBLabel();
        jBLabel.setText("(date)");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myDeepLinkUrl = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setFocusable(false);
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDetailPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

