/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadNameManager;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeIdeaFormatWriterKt;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeaFormatWriter;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.lang.management.ManagementFactory;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0014J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J(\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0004H\u0014J\u000e\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"J(\u0010#\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0015H\u0014R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lcom/intellij/diagnostic/startUpPerformanceReporter/IdeIdeaFormatWriter;", "Lcom/intellij/diagnostic/startUpPerformanceReporter/IdeaFormatWriter;", "activities", "", "", "", "Lcom/intellij/diagnostic/ActivityImpl;", "pluginCostMap", "", "Lit/unimi/dsi/fastutil/objects/Object2LongMap;", "threadNameManager", "Lcom/intellij/diagnostic/ThreadNameManager;", "(Ljava/util/Map;Ljava/util/Map;Lcom/intellij/diagnostic/ThreadNameManager;)V", "publicStatMetrics", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "getPublicStatMetrics", "()Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "beforeActivityWrite", "", "item", "ownOrTotalDuration", "", "fieldName", "writeAppInfo", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "writeExtraData", "writeItemTimeInfo", "duration", "offset", "writeProjectName", "projectName", "writeToLog", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "writeTotalDuration", "totalDuration", "end", "timeOffset", "intellij.platform.diagnostic"})
public final class IdeIdeaFormatWriter
extends IdeaFormatWriter {
    @NotNull
    private final Object2IntOpenHashMap<String> publicStatMetrics;
    private final Map<String, Object2LongMap<String>> pluginCostMap;

    @NotNull
    public final Object2IntOpenHashMap<String> getPublicStatMetrics() {
        return this.publicStatMetrics;
    }

    public final void writeToLog(@NotNull Logger log) {
        this.getStringWriter().write("\n=== Stop: StartUp Measurement ===");
        log.info(this.getStringWriter().toString());
    }

    @Override
    protected void writeAppInfo(@NotNull JsonGenerator writer) {
        boolean bl;
        block4: {
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            writer.writeStringField("build", appInfo.getBuild().asStringWithoutProductCode());
            writer.writeStringField("buildDate", ZonedDateTime.ofInstant(appInfo.getBuildDate().toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.RFC_1123_DATE_TIME));
            writer.writeStringField("productCode", appInfo.getBuild().getProductCode());
            Iterable $this$any$iv = ManagementFactory.getRuntimeMXBean().getInputArguments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it, (Object)"-Xshare:auto") || Intrinsics.areEqual((Object)it, (Object)"-Xshare:on"))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            writer.writeBooleanField("cds", true);
        }
    }

    @Override
    protected void writeProjectName(@NotNull JsonGenerator writer, @NotNull String projectName) {
        writer.writeStringField("project", IdeIdeaFormatWriterKt.access$safeHashValue(projectName));
    }

    @Override
    protected void writeExtraData(@NotNull JsonGenerator writer) {
        IdeIdeaFormatWriterKt.access$writeServiceStats(writer);
        IdeIdeaFormatWriterKt.access$writeIcons(writer);
    }

    @Override
    protected void writeItemTimeInfo(@NotNull ActivityImpl item, long duration, long offset, @NotNull JsonGenerator writer) {
        if (Intrinsics.areEqual((Object)item.getName(), (Object)"bootstrap") || Intrinsics.areEqual((Object)item.getName(), (Object)"app initialization")) {
            this.publicStatMetrics.put((Object)item.getName(), (int)TimeUnit.NANOSECONDS.toMillis(duration));
        }
        super.writeItemTimeInfo(item, duration, offset, writer);
    }

    @Override
    protected long writeTotalDuration(@NotNull JsonGenerator writer, long totalDuration, long end, long timeOffset) {
        long totalDurationActual = super.writeTotalDuration(writer, totalDuration, end, timeOffset);
        this.publicStatMetrics.put((Object)"totalDuration", (int)totalDurationActual);
        return totalDurationActual;
    }

    @Override
    protected void beforeActivityWrite(@NotNull ActivityImpl item, long ownOrTotalDuration, @NotNull String fieldName) {
        String string = item.getPluginId();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Object object = item.getCategory();
            if (object == null || (object = object.name()) == null) {
                object = "unknown";
            }
            StartUpMeasurer.doAddPluginCost((String)it, (String)object, (long)ownOrTotalDuration, this.pluginCostMap);
        }
        if (Intrinsics.areEqual((Object)fieldName, (Object)"prepareAppInitActivities") && Intrinsics.areEqual((Object)item.getName(), (Object)"splash initialization")) {
            this.publicStatMetrics.put((Object)"splash", (int)TimeUnit.NANOSECONDS.toMillis(ownOrTotalDuration));
        }
    }

    public IdeIdeaFormatWriter(@NotNull Map<String, ? extends List<ActivityImpl>> activities, @NotNull Map<String, Object2LongMap<String>> pluginCostMap, @NotNull ThreadNameManager threadNameManager) {
        super(activities, threadNameManager);
        this.pluginCostMap = pluginCostMap;
        this.publicStatMetrics = new Object2IntOpenHashMap();
        this.publicStatMetrics.defaultReturnValue(-1);
    }
}

