/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.VirtualFileResolver;
import com.intellij.configurationStore.schemeManager.SchemeFileTracker;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u00012\u00020\u0002:\u0003345B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0091\u0001\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\b\b\u0000\u0010\u0014*\u00020\u0015\"\b\b\u0001\u0010\u0016*\u0002H\u00142\u0006\u0010\u0017\u001a\u00020\u00102\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00160\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001b\u001a\u00020\u001c2%\u0010\u001d\u001a!\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00100\u001ej\u0002`!2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'J3\u0010(\u001a-\u0012\u001b\u0012\u0019\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b()\u0012\u0004\u0012\u00020*\u0018\u00010\u001ej\u0004\u0018\u0001`+H\u0014J\u0014\u0010,\u001a\u00020*2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\n\u0010-\u001a\u0004\u0018\u00010.H\u0014J\u0010\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020\u0010H&J&\u00101\u001a\u00020*2\u001e\u0010\u0018\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020*0\u001eJ\u0006\u00102\u001a\u00020*R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007Rj\u0010\b\u001a^\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b \f*\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n \f*-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b \f*\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n0\u000e\u00a2\u0006\u0002\b\r0\t\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003678\u00a8\u00069"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase;", "Lcom/intellij/openapi/options/SchemeManagerFactory;", "Lcom/intellij/openapi/components/SettingsSavingComponent;", "()V", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "managers", "", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "Lcom/intellij/openapi/options/Scheme;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "checkPath", "", "originalPath", "create", "Lcom/intellij/openapi/options/SchemeManager;", "T", "", "MutableT", "directoryName", "processor", "Lcom/intellij/openapi/options/SchemeProcessor;", "presentableName", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "schemeNameToFileName", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lcom/intellij/configurationStore/SchemeNameToFileName;", "streamProvider", "Lcom/intellij/configurationStore/StreamProvider;", "directoryPath", "Ljava/nio/file/Path;", "isAutoSave", "", "createFileChangeSubscriber", "schemeManager", "", "Lcom/intellij/configurationStore/schemeManager/FileChangeSubscriber;", "dispose", "getVirtualFileResolver", "Lcom/intellij/configurationStore/VirtualFileResolver;", "pathToFile", "path", "process", "save", "ApplicationSchemeManagerFactory", "ProjectSchemeManagerFactory", "TestSchemeManagerFactory", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase$ApplicationSchemeManagerFactory;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase$ProjectSchemeManagerFactory;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase$TestSchemeManagerFactory;", "intellij.platform.configurationStore.impl"})
public abstract class SchemeManagerFactoryBase
extends SchemeManagerFactory
implements SettingsSavingComponent {
    private final List<SchemeManagerImpl<Scheme, Scheme>> managers = ContainerUtil.createLockFreeCopyOnWriteList();
    @Nullable
    private final ComponentManager componentManager;

    @Nullable
    protected ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Nullable
    protected Function1<SchemeManagerImpl<?, ?>, Unit> createFileChangeSubscriber() {
        return null;
    }

    @Nullable
    protected VirtualFileResolver getVirtualFileResolver() {
        return null;
    }

    @NotNull
    public final <T, MutableT extends T> SchemeManager<T> create(@NotNull String directoryName, @NotNull SchemeProcessor<T, ? super MutableT> processor2, @Nullable String presentableName, @NotNull RoamingType roamingType, @NotNull Function1<? super String, String> schemeNameToFileName, @Nullable StreamProvider streamProvider, @Nullable Path directoryPath, boolean isAutoSave) {
        Path path;
        String path2 = this.checkPath(directoryName);
        Function1<SchemeManagerImpl<?, ?>, Unit> fileChangeSubscriber = streamProvider != null && streamProvider.isApplicable(path2, roamingType) ? null : this.createFileChangeSubscriber();
        StreamProvider streamProvider2 = streamProvider;
        if (streamProvider2 == null) {
            StateStorageManager stateStorageManager;
            ComponentManager componentManager = this.getComponentManager();
            if (!((componentManager != null && (componentManager = ServiceKt.getStateStore((ComponentManager)componentManager)) != null ? componentManager.getStorageManager() : (stateStorageManager = null)) instanceof StateStorageManagerImpl)) {
                stateStorageManager = null;
            }
            StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
            streamProvider2 = stateStorageManagerImpl != null ? stateStorageManagerImpl.getCompoundStreamProvider() : null;
        }
        if ((path = directoryPath) == null) {
            path = this.pathToFile(path2);
        }
        SchemeManagerImpl<T, ? super MutableT> manager = new SchemeManagerImpl<T, MutableT>(path2, processor2, streamProvider2, path, roamingType, presentableName, schemeNameToFileName, fileChangeSubscriber, this.getVirtualFileResolver());
        if (isAutoSave) {
            this.managers.add(manager);
        }
        return (SchemeManager)manager;
    }

    public void dispose(@NotNull SchemeManager<?> schemeManager) {
        Collection collection = this.managers;
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)collection2).remove(schemeManager);
    }

    @NotNull
    public String checkPath(@NotNull String originalPath) {
        block1: {
            block0: {
                if (!StringsKt.contains$default((CharSequence)originalPath, (char)'\\', (boolean)false, (int)2, null)) break block0;
                ComponentStoreImplKt.getLOG().error("Path must be system-independent, use forward slash instead of backslash");
                break block1;
            }
            CharSequence charSequence = originalPath;
            boolean bl = false;
            if (!(charSequence.length() == 0)) break block1;
            ComponentStoreImplKt.getLOG().error("Path must not be empty");
        }
        return originalPath;
    }

    @NotNull
    public abstract Path pathToFile(@NotNull String var1);

    public final void process(@NotNull Function1<? super SchemeManagerImpl<Scheme, Scheme>, Unit> processor2) {
        for (SchemeManagerImpl<Scheme, Scheme> manager : this.managers) {
            try {
                processor2.invoke(manager);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().error("Cannot reload settings for " + ((Object)manager).getClass().getName(), e);
            }
        }
    }

    public final void save() {
        SmartList errors = new SmartList();
        for (SchemeManagerImpl<Scheme, Scheme> registeredManager : this.managers) {
            try {
                registeredManager.save((List)errors);
            }
            catch (Throwable e) {
                errors.add((Object)e);
            }
        }
        CompoundRuntimeException.throwIfNotEmpty((List)((List)errors));
    }

    private SchemeManagerFactoryBase() {
    }

    public /* synthetic */ SchemeManagerFactoryBase(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase$ApplicationSchemeManagerFactory;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase;", "()V", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "checkPath", "", "originalPath", "pathToFile", "Ljava/nio/file/Path;", "path", "intellij.platform.configurationStore.impl"})
    private static final class ApplicationSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        @Override
        @NotNull
        protected ComponentManager getComponentManager() {
            return (ComponentManager)ApplicationManager.getApplication();
        }

        @Override
        @NotNull
        public String checkPath(@NotNull String originalPath) {
            String path = super.checkPath(originalPath);
            if (StringsKt.startsWith$default((String)path, (String)"$ROOT_CONFIG$", (boolean)false, (int)2, null)) {
                String string = path;
                int n = 14;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                path = string3;
                String message = "Path must not contains ROOT_CONFIG macro, corrected: " + path;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                ComponentStoreImplKt.getLOG().warn(message);
            }
            return path;
        }

        @Override
        @NotNull
        public Path pathToFile(@NotNull String path) {
            return Paths.get(ServiceKt.getStateStore((ComponentManager)((ComponentManager)ApplicationManager.getApplication())).getStorageManager().expandMacros("$ROOT_CONFIG$"), path);
        }

        public ApplicationSchemeManagerFactory() {
            super(null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0002J3\u0010\f\u001a-\u0012\u001b\u0012\u0019\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\t\u0018\u00010\rj\u0004\u0018\u0001`\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase$ProjectSchemeManagerFactory;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "componentManager", "getComponentManager", "()Lcom/intellij/openapi/project/Project;", "addVfsListener", "", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "createFileChangeSubscriber", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lcom/intellij/configurationStore/schemeManager/FileChangeSubscriber;", "getVirtualFileResolver", "Lcom/intellij/configurationStore/VirtualFileResolver;", "pathToFile", "Ljava/nio/file/Path;", "path", "", "intellij.platform.configurationStore.impl"})
    private static final class ProjectSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        @NotNull
        private final Project componentManager;
        private final Project project;

        @NotNull
        protected Project getComponentManager() {
            return this.componentManager;
        }

        @Override
        @Nullable
        protected VirtualFileResolver getVirtualFileResolver() {
            Project project = this.project;
            if (!(project instanceof VirtualFileResolver)) {
                project = null;
            }
            return (VirtualFileResolver)project;
        }

        private final void addVfsListener(SchemeManagerImpl<?, ?> schemeManager) {
            SchemeManagerImpl<Object, Object> schemeManagerImpl = schemeManager;
            if (schemeManagerImpl == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerImpl<kotlin.Any, kotlin.Any>");
            }
            this.project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new SchemeFileTracker(schemeManagerImpl, this.project));
        }

        @Override
        @Nullable
        protected Function1<SchemeManagerImpl<?, ?>, Unit> createFileChangeSubscriber() {
            return new Function1<SchemeManagerImpl<?, ?>, Unit>(this){
                final /* synthetic */ ProjectSchemeManagerFactory this$0;

                public final void invoke(@NotNull SchemeManagerImpl<?, ?> schemeManager) {
                    if (!ApplicationManager.getApplication().isUnitTestMode() || Intrinsics.areEqual((Object)((Boolean)ProjectSchemeManagerFactory.access$getProject$p(this.this$0).getUserData(Scheme_implKt.getLISTEN_SCHEME_VFS_CHANGES_IN_TEST_MODE())), (Object)true)) {
                        StartupManagerEx.getInstanceEx((Project)ProjectSchemeManagerFactory.access$getProject$p(this.this$0)).runAfterOpened(new Runnable(this, schemeManager){
                            final /* synthetic */ createFileChangeSubscriber.1 this$0;
                            final /* synthetic */ SchemeManagerImpl $schemeManager;

                            public final void run() {
                                ProjectSchemeManagerFactory.access$addVfsListener(this.this$0.this$0, this.$schemeManager);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$schemeManager = schemeManagerImpl;
                            }
                        });
                    }
                }
                {
                    this.this$0 = projectSchemeManagerFactory;
                    super(1);
                }
            };
        }

        @Override
        @NotNull
        public Path pathToFile(@NotNull String path) {
            String projectFileDir;
            if (this.project.isDefault()) {
                return Paths.get("__not_existent_path__", new String[0]);
            }
            IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)this.project));
            if (!(iComponentStore instanceof IProjectStore)) {
                iComponentStore = null;
            }
            IProjectStore iProjectStore = (IProjectStore)iComponentStore;
            String string = projectFileDir = iProjectStore != null ? iProjectStore.getProjectConfigDir() : null;
            if (projectFileDir == null) {
                String string2 = this.project.getBasePath();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                return Paths.get(string2, '.' + path);
            }
            return Paths.get(projectFileDir, path);
        }

        public ProjectSchemeManagerFactory(@NotNull Project project) {
            super(null);
            this.componentManager = this.project = project;
        }

        public static final /* synthetic */ Project access$getProject$p(ProjectSchemeManagerFactory $this) {
            return $this.project;
        }

        public static final /* synthetic */ void access$addVfsListener(ProjectSchemeManagerFactory $this, SchemeManagerImpl schemeManager) {
            $this.addVfsListener(schemeManager);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase$TestSchemeManagerFactory;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase;", "basePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "pathToFile", "path", "", "intellij.platform.configurationStore.impl"})
    public static final class TestSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        private final Path basePath;

        @Override
        @NotNull
        public Path pathToFile(@NotNull String path) {
            return this.basePath.resolve(path);
        }

        public TestSchemeManagerFactory(@NotNull Path basePath) {
            super(null);
            this.basePath = basePath;
        }
    }
}

